/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.property;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.property.PropertyMapCreater;
import cgdp.recog.property.PropertyTableCellEditor;
import cgdp.recog.property.PropertyTableCellRenderer;
import cgdp.recog.property.PropertyTableModel;
import cgdp.recog.server.Server;
import cgdp.recog.server.ServerComboBox;
import cgdp.recog.util.AbstractApplyDialog;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumn;

public class PropertyDialog
extends AbstractApplyDialog {
    private static PropertyDialog PROPERTY_DIALOG;
    private MediatorImpl mediator;
    private static final String TITLE = "Properties";
    private JTable propertyTable;

    private PropertyDialog(Frame frame, MediatorImpl mediatorImpl) {
        super(frame);
        this.mediator = mediatorImpl;
        this.createComponents();
    }

    public static void createInstance(Frame frame, MediatorImpl mediatorImpl) {
        PROPERTY_DIALOG = new PropertyDialog(frame, mediatorImpl);
    }

    public static PropertyDialog getInstance() {
        return PROPERTY_DIALOG;
    }

    private void createComponents() {
        this.setTitle(TITLE);
        this.setModal(false);
        this.setResizable(true);
        Set set = PropertyMapCreater.createEditableComboBoxProperryTitleSet();
        Set set2 = PropertyMapCreater.createTextAreaPropertyTitleSet();
        HashSet hashSet = new HashSet(set);
        hashSet.addAll(set2);
        PropertyTableModel propertyTableModel = new PropertyTableModel(hashSet);
        this.propertyTable = new JTable(propertyTableModel);
        TableColumn tableColumn = this.propertyTable.getColumnModel().getColumn(0);
        PropertyTableCellRenderer propertyTableCellRenderer = new PropertyTableCellRenderer();
        tableColumn.setCellRenderer(propertyTableCellRenderer);
        TableColumn tableColumn2 = this.propertyTable.getColumnModel().getColumn(1);
        PropertyTableCellRenderer propertyTableCellRenderer2 = new PropertyTableCellRenderer();
        propertyTableCellRenderer2.setComboBoxNameSet(set);
        propertyTableCellRenderer2.setTestAreaNameSet(set2);
        tableColumn2.setCellRenderer(propertyTableCellRenderer2);
        ServerComboBox serverComboBox = new ServerComboBox();
        PropertyTableCellEditor propertyTableCellEditor = new PropertyTableCellEditor();
        propertyTableCellEditor.addComboBox("Server", serverComboBox);
        propertyTableCellEditor.addTextArea("Comment");
        tableColumn2.setCellEditor(propertyTableCellEditor);
        JScrollPane jScrollPane = new JScrollPane(this.propertyTable, 20, 31);
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)jScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 10, 0, 10), 0, 0));
        this.getContentPane().add((Component)this.getButtonPanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 0, new Insets(5, 0, 5, 0), 0, 0));
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    public void updateValue(Map map) {
        PropertyTableModel propertyTableModel = this.getPropertyTableModel();
        propertyTableModel.setPropertyMap(map);
    }

    private PropertyTableModel getPropertyTableModel() {
        return (PropertyTableModel)this.propertyTable.getModel();
    }

    public String getServerUrl() {
        PropertyTableModel propertyTableModel = this.getPropertyTableModel();
        return propertyTableModel.getProperty("Server");
    }

    @Override
    protected boolean apply() {
        Server server = new Server();
        server.setUrl(this.getServerUrl());
        this.mediator.changeSelectServer(server);
        return true;
    }
}

