/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.property;

import cgdp.recog.util.ReadOnlyTextArea;
import cgdp.recog.util.StringTool;
import java.awt.Color;
import java.awt.Component;
import java.util.HashSet;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellRenderer;

public class PropertyTableCellRenderer
implements TableCellRenderer {
    private static final String TITLE_LINE_PREFIX = "#TITLE#";
    private Set comboBoxNameSet = new HashSet();
    private Set testAreaNameSet = new HashSet();
    private JLabel label = new JLabel();
    private JComboBox comboBox;
    private ReadOnlyTextArea textArea;
    private JScrollPane textAreaScrollPane;
    private final JTextField editor;

    public PropertyTableCellRenderer() {
        this.label.setOpaque(true);
        this.label.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        this.comboBox = new JComboBox();
        this.editor = (JTextField)this.comboBox.getEditor().getEditorComponent();
        this.editor.setBorder(BorderFactory.createEmptyBorder());
        this.editor.setOpaque(true);
        this.textArea = new ReadOnlyTextArea();
        this.textAreaScrollPane = new JScrollPane(this.textArea, 20, 30);
    }

    public void setComboBoxNameSet(Set set) {
        this.comboBoxNameSet = set;
    }

    public void setTestAreaNameSet(Set set) {
        this.testAreaNameSet = set;
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        String string = (String)jTable.getValueAt(n, 0);
        if (this.comboBoxNameSet.contains(string)) {
            if (bl) {
                this.editor.setForeground(jTable.getSelectionForeground());
                this.editor.setBackground(jTable.getSelectionBackground());
            } else {
                this.editor.setForeground(jTable.getForeground());
                this.editor.setBackground(jTable.getBackground());
            }
            this.comboBox.removeAllItems();
            this.comboBox.addItem(object == null ? "" : object.toString());
            return this.comboBox;
        }
        if (this.testAreaNameSet.contains(string)) {
            if (bl) {
                this.textArea.setForeground(jTable.getSelectionForeground());
                this.textArea.setBackground(jTable.getSelectionBackground());
            } else {
                this.textArea.setForeground(jTable.getForeground());
                this.textArea.setBackground(jTable.getBackground());
            }
            this.textArea.setFont(jTable.getFont());
            this.textArea.setText(StringTool.displayNewLine2NewLine(object.toString()));
            jTable.setRowHeight(n, 50);
            return this.textAreaScrollPane;
        }
        if (this.isTitleLine(string)) {
            this.label.setForeground(Color.white);
            this.label.setBackground(Color.darkGray);
            object = this.extractNameFromTitleLine((String)object);
        } else if (bl) {
            this.label.setForeground(jTable.getSelectionForeground());
            this.label.setBackground(jTable.getSelectionBackground());
        } else {
            this.label.setForeground(jTable.getForeground());
            this.label.setBackground(jTable.getBackground());
        }
        this.label.setText(object == null ? "" : object.toString());
        return this.label;
    }

    private boolean isTitleLine(String string) {
        return string.startsWith(TITLE_LINE_PREFIX);
    }

    public static String addTitlePrefix(String string) {
        return TITLE_LINE_PREFIX + string;
    }

    private String extractNameFromTitleLine(String string) {
        return string.replaceAll(TITLE_LINE_PREFIX, "");
    }
}

