/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.property;

import edu.emory.mathcs.backport.java.util.TreeMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.table.AbstractTableModel;

public class PropertyTableModel
extends AbstractTableModel {
    private static final String[] COLUMNS = new String[]{"name", "value"};
    private Map propertyMap = new TreeMap();
    private Set editableNameSet = new HashSet();

    PropertyTableModel() {
    }

    PropertyTableModel(Set set) {
        this.editableNameSet = set;
    }

    void setPropertyMap(Map map) {
        this.propertyMap = map;
        this.fireTableDataChanged();
    }

    @Override
    public int getColumnCount() {
        return COLUMNS.length;
    }

    @Override
    public String getColumnName(int n) {
        return COLUMNS[n];
    }

    @Override
    public int getRowCount() {
        return this.propertyMap.size();
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (n2 == 0) {
            return false;
        }
        String string = (String)this.getValueAt(n, 0);
        return this.editableNameSet.contains(string);
    }

    @Override
    public Object getValueAt(int n, int n2) {
        ArrayList arrayList = new ArrayList(this.propertyMap.keySet());
        String string = (String)arrayList.get(n);
        if (n2 == 0) {
            return string;
        }
        Object v = this.propertyMap.get(string);
        if (v != null) {
            return this.propertyMap.get(string).toString();
        }
        return "";
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (!this.isCellEditable(n, n2)) {
            return;
        }
        ArrayList arrayList = new ArrayList(this.propertyMap.keySet());
        String string = (String)arrayList.get(n);
        this.propertyMap.put(string, object);
    }

    public String getProperty(String string) {
        return (String)this.propertyMap.get(string);
    }
}

