/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.propvect;

import cgdp.recog.propvect.CalcDistancePhyloPat;
import cgdp.recog.propvect.PhyloPat;

class CalcCorrelationPhyloPat
extends CalcDistancePhyloPat {
    boolean abs;

    CalcCorrelationPhyloPat(int n, double d, boolean bl) {
        super(n);
        this.abs = bl;
        CalcCorrelationPhyloPat.calcCache(n, d);
    }

    @Override
    double calc(PhyloPat phyloPat, PhyloPat phyloPat2) {
        double d = this.correlation(phyloPat, phyloPat2);
        if (this.abs) {
            return 1.0 - Math.abs(d);
        }
        return 1.0 - d;
    }

    double correlation(PhyloPat phyloPat, PhyloPat phyloPat2) throws RuntimeException {
        int n;
        int n2 = phyloPat.count();
        if (McutCache[n2][n = phyloPat2.count()] == Double.MIN_VALUE && (McutCache2 == null || McutCache2[n2][n] == Double.MIN_VALUE)) {
            return 0.0;
        }
        int n3 = phyloPat.countMatch(phyloPat2);
        if ((double)n3 < McutCache[n2][n] && (McutCache2 == null || (double)n3 > McutCache2[n2][n])) {
            return 0.0;
        }
        if (n2 == this.length || n == this.length) {
            return 0.0;
        }
        double d = (double)(this.length * n3 - n2 * n) / Math.sqrt((this.length * n2 - n2 * n2) * (this.length * n - n * n));
        return d;
    }

    static void calcCache(int n, double d) {
        McutCache = new double[n + 1][n + 1];
        McutCache2 = new double[n + 1][n + 1];
        for (int i = 0; i <= n; ++i) {
            for (int j = 0; j <= n; ++j) {
                CalcCorrelationPhyloPat.McutCache[i][j] = ((1.0 - d) * Math.sqrt((n * i - i * i) * (n * j - j * j)) + (double)(i * j)) / (double)n;
                CalcCorrelationPhyloPat.McutCache2[i][j] = (-(1.0 - d) * Math.sqrt((n * i - i * i) * (n * j - j * j)) + (double)(i * j)) / (double)n;
                if (McutCache[i][j] > (double)Math.min(i, j)) {
                    CalcCorrelationPhyloPat.McutCache[i][j] = Double.MIN_VALUE;
                }
                if (McutCache2 == null || !(McutCache2[i][j] < 0.0)) continue;
                CalcCorrelationPhyloPat.McutCache2[i][j] = Double.MIN_VALUE;
            }
        }
    }
}

