/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.propvect;

import cgdp.recog.propvect.PropVect;

public class NumVect
extends PropVect {
    float[] vect;
    int length;
    String name;
    double sum = -1.0;

    public NumVect() {
    }

    public NumVect(int n) {
        this.vect = new float[n];
        this.length = n;
    }

    public NumVect(int n, String string) {
        this(n);
        this.name = string;
    }

    public void set(int n, double d) {
        this.vect[n] = (float)d;
    }

    @Override
    public void set(int n, String string) {
        this.vect[n] = Double.valueOf(string).floatValue();
    }

    public double get(int n) {
        return this.vect[n];
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int compareTo(Object object) {
        NumVect numVect = (NumVect)object;
        for (int i = 0; i < this.length; ++i) {
            int n = (int)(this.get(i) - numVect.get(i));
            if (n == 0) continue;
            return n;
        }
        return 0;
    }

    double sum() {
        if (this.sum < 0.0) {
            this.sum = 0.0;
            for (int i = 0; i < this.length; ++i) {
                this.sum += (double)this.vect[i];
            }
        }
        return this.sum;
    }

    double mean() {
        return this.sum() / (double)this.length;
    }

    double correlation(NumVect numVect) {
        int n = 0;
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < this.length; ++i) {
            double d3 = this.vect[i];
            double d4 = numVect.vect[i];
            if (Double.isNaN(d3) || Double.isNaN(d4)) continue;
            d += d3;
            d2 += d4;
            ++n;
        }
        if (n == 0) {
            return Double.NaN;
        }
        d /= (double)n;
        d2 /= (double)n;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        for (int i = 0; i < this.length; ++i) {
            double d8 = this.vect[i];
            double d9 = numVect.vect[i];
            if (Double.isNaN(d8) || Double.isNaN(d9)) continue;
            d5 += ((double)this.vect[i] - d) * ((double)numVect.vect[i] - d2);
            d6 += ((double)this.vect[i] - d) * ((double)this.vect[i] - d);
            d7 += ((double)numVect.vect[i] - d2) * ((double)numVect.vect[i] - d2);
        }
        if (d6 == 0.0 || d7 == 0.0) {
            return Double.NaN;
        }
        return d5 / Math.sqrt(d6 * d7);
    }

    double correlation_old(NumVect numVect) {
        double d = this.mean();
        double d2 = numVect.mean();
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        for (int i = 0; i < this.length; ++i) {
            d3 += ((double)this.vect[i] - d) * ((double)numVect.vect[i] - d2);
            d4 += ((double)this.vect[i] - d) * ((double)this.vect[i] - d);
            d5 += ((double)numVect.vect[i] - d2) * ((double)numVect.vect[i] - d2);
        }
        return d3 / Math.sqrt(d4 * d5);
    }

    double distance(NumVect numVect) {
        return this.normalizedEuclidDistance(numVect);
    }

    double normalizedEuclidDistance(NumVect numVect) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = this.mean();
        double d5 = numVect.mean();
        for (int i = 0; i < this.length; ++i) {
            double d6 = (double)this.vect[i] - d4 - ((double)numVect.vect[i] - d5);
            d += d6 * d6;
            d2 += ((double)this.vect[i] - d4) * ((double)this.vect[i] - d4);
            d3 += ((double)numVect.vect[i] - d5) * ((double)numVect.vect[i] - d5);
        }
        return Math.sqrt(d / d2 / d3);
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        for (int i = 0; i < this.length; ++i) {
            stringBuffer.append(this.vect[i]);
            if (i >= this.length - 1) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }
}

