/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.propvect;

import cgdp.recog.hcluster.DistMatrix;
import cgdp.recog.hcluster.HClustException;
import cgdp.recog.process.DummyProgressComponent;
import cgdp.recog.process.ProgressImpl;
import cgdp.recog.propvect.CalcDistance;
import cgdp.recog.propvect.CompressedPropVectArray;
import cgdp.recog.propvect.PropVect;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;

public abstract class PropVectArray {
    ArrayList vectSet = new ArrayList();
    int colnum;

    public PropVectArray() {
    }

    public PropVectArray(int n) {
        this();
        this.colnum = n;
    }

    abstract PropVect createNewElement(String var1);

    public void add(PropVect propVect) {
        this.vectSet.add(propVect);
    }

    public PropVect get(int n) {
        return (PropVect)this.vectSet.get(n);
    }

    public void setVectSet(ArrayList arrayList) {
        this.vectSet = arrayList;
    }

    public void setColnum(int n) {
        this.colnum = n;
    }

    public int colnum() {
        return this.colnum;
    }

    public void readFromFile(String string) throws IOException {
        BufferedReader bufferedReader;
        this.colnum = 0;
        this.vectSet = new ArrayList();
        if (string == null) {
            bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        } else {
            bufferedReader = new BufferedReader(new FileReader(string));
        }
        String string2 = null;
        while ((string2 = bufferedReader.readLine()) != null) {
            String string3;
            if (string2.charAt(0) == '#') {
                int n = string2.indexOf("colnum=", 1);
                if (n < 0) continue;
                string3 = string2.substring(n + 7);
                this.setColnum(Integer.valueOf(string3));
                continue;
            }
            String[] stringArray = string2.split("[ \t]");
            string3 = stringArray[0];
            PropVect propVect = this.createNewElement(string3);
            for (int i = 1; i < stringArray.length; ++i) {
                propVect.set(i - 1, stringArray[i]);
            }
            this.add(propVect);
        }
    }

    abstract CalcDistance createCalcDistance(int var1, double var2);

    abstract CalcDistance createCalcProbability(double var1);

    public void compareAll(int n, double d, double d2) throws HClustException {
        this.compareAll(n, d, d2, null, false);
    }

    public void compareAll(int n, double d, double d2, DistMatrix distMatrix) throws HClustException {
        this.compareAll(n, d, d2, distMatrix, false);
    }

    public void compareAll(int n, double d, double d2, DistMatrix distMatrix, boolean bl) throws HClustException {
        this.compareAll(n, d, d2, distMatrix, bl, new DummyProgressComponent());
    }

    public void compareAll(int n, double d, double d2, DistMatrix distMatrix, boolean bl, ProgressImpl progressImpl) throws HClustException {
        CalcDistance calcDistance = this.createCalcDistance(n, d);
        CalcDistance calcDistance2 = null;
        if (d2 <= 1.0) {
            calcDistance2 = this.createCalcProbability(d2);
        }
        for (int i = 0; i < this.vectSet.size(); ++i) {
            if (progressImpl.isCanceled()) {
                return;
            }
            progressImpl.increment();
            PropVect propVect = (PropVect)this.vectSet.get(i);
            if (bl && i % 1000 == 1) {
                System.err.println("Executing: " + i + "/" + this.vectSet.size());
            }
            for (int j = i; j < this.vectSet.size(); ++j) {
                PropVect propVect2 = (PropVect)this.vectSet.get(j);
                double d3 = 0.0;
                double d4 = 0.0;
                if (calcDistance2 != null && (d4 = calcDistance2.calc(propVect, propVect2)) > d2 || !((d3 = calcDistance.calc(propVect, propVect2)) <= d)) continue;
                if (distMatrix != null) {
                    distMatrix.add(propVect.getName(), propVect2.getName(), d3);
                    continue;
                }
                this.printComparison(i, j, d3);
            }
        }
    }

    ArrayList findEquiv(ArrayList arrayList) {
        if (this.vectSet.size() == 0) {
            return null;
        }
        Collections.sort(this.vectSet);
        ArrayList<PropVect> arrayList2 = new ArrayList<PropVect>();
        LinkedList<PropVect> linkedList = new LinkedList<PropVect>();
        if (arrayList != null) {
            arrayList.add(linkedList);
        }
        PropVect propVect = (PropVect)this.vectSet.get(0);
        arrayList2.add(propVect);
        linkedList.add(propVect);
        for (int i = 1; i < this.vectSet.size(); ++i) {
            PropVect propVect2 = (PropVect)this.vectSet.get(i);
            if (propVect.compareTo(propVect2) != 0) {
                arrayList2.add(propVect2);
                linkedList = new LinkedList();
                if (arrayList != null) {
                    arrayList.add(linkedList);
                }
                linkedList.add(propVect2);
            } else {
                linkedList.add(propVect2);
            }
            propVect = propVect2;
        }
        return arrayList2;
    }

    void printComparison(int n, int n2, double d) {
        this.printComparison((PropVect)this.vectSet.get(n), (PropVect)this.vectSet.get(n2), d);
    }

    void printComparison(PropVect propVect, PropVect propVect2, double d) {
        DecimalFormat decimalFormat = new DecimalFormat("####0.########");
        System.out.println(propVect.getName() + " " + propVect2.getName() + " " + decimalFormat.format(d));
    }

    public CompressedPropVectArray doCompress() {
        return new CompressedPropVectArray(this);
    }

    public int size() {
        if (this.vectSet == null) {
            return 0;
        }
        return this.vectSet.size();
    }
}

