/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.ptree.bean;

import cgdp.recog.ptree.bean.Node;
import cgdp.recog.ptree.bean.Tree;
import cgdp.recog.ptree.bean.TreeStyles;
import cgdp.recog.ptree.bean.Utils;
import cgdp.recog.ptree.bean.data.DPoint;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.util.Vector;

public class CalcTree {
    public static int PIXEL_PER_STEM_UNIT = 8;
    public static int MIN_WIDTH = 300;
    public static int MIN_HEIGHT = 300;
    protected FontMetrics m_fm;
    protected Tree m_tree;
    protected Vector m_nodes;
    protected Node m_root;
    protected TreeStyles m_styles;
    protected double m_tipx;
    protected double m_firstlet;
    protected double m_textlength;
    protected double m_maxtextlength;
    protected double m_expand;
    protected double m_expandY;
    protected double m_expandX;
    protected double m_labelHeight;
    protected double m_angle;
    protected double m_maxheight;
    protected double m_maxyabs;
    protected double m_tipspacing;
    protected double m_rooty;
    protected Rectangle m_rect;
    protected Component m_comp;
    protected boolean m_isUseLengths;
    protected boolean m_isUnrooted;
    protected double m_scalebar;
    protected DPoint m_scalebarPoint = new DPoint();
    protected boolean m_rotate = false;
    protected double m_labelheightUR;
    protected double m_fontheight;
    protected double m_labangle;
    protected double m_xx;
    protected double m_yy;
    protected double m_maxx;
    protected double m_maxy;
    protected double m_minx;
    protected double m_miny;
    protected double m_extrax;
    protected double m_extray;
    protected double m_xsize;
    protected double m_ysize;
    protected double m_xmargin;
    protected double m_ymargin;

    public CalcTree(Tree tree, Component component) {
        this.m_comp = component;
        this.m_tree = tree;
        if (this.m_comp.getGraphics() != null) {
            this.m_fm = this.m_comp.getGraphics().getFontMetrics();
        }
    }

    protected void init() {
        this.m_root = this.m_tree.getRoot();
        this.m_nodes = this.m_tree.getNodes();
        this.m_styles = this.m_tree.getStyles();
        this.m_labelHeight = 1.0;
        this.m_expand = 1.0;
        this.m_maxheight = 0.0;
        this.m_isUseLengths = this.m_tree.isUseLengths();
        this.m_isUnrooted = this.m_tree.isUnrooted();
        if (this.m_rect == null) {
            this.m_rect = new Rectangle(0, 0, MIN_WIDTH, MIN_HEIGHT);
            Dimension dimension = this.m_comp.getSize();
            if (dimension != null) {
                if (dimension.width < MIN_WIDTH) {
                    dimension.width = MIN_WIDTH;
                }
                if (dimension.height < MIN_HEIGHT) {
                    dimension.height = MIN_HEIGHT;
                }
                this.m_rect = new Rectangle(dimension);
            }
        }
    }

    public void setFontMetrics(FontMetrics fontMetrics) {
        this.m_fm = fontMetrics;
    }

    public void setRect(Rectangle rectangle) {
        this.m_rect = rectangle;
    }

    public Rectangle getRect() {
        return this.m_rect;
    }

    public double getExpand() {
        return this.m_expand;
    }

    public void doCalc() {
        try {
            this.init();
            if (this.m_isUnrooted) {
                this.calculateUnrooted();
            } else {
                this.calculateRooted();
            }
            this.rescale();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void doScale() {
        this.init();
        this.rescale();
    }

    public double getHeight() {
        return this.m_maxheight;
    }

    public double getAbsHeight() {
        return this.m_maxyabs;
    }

    public final double scalebar() {
        return this.scalebar(null);
    }

    public double scalebar(DPoint dPoint) {
        if (dPoint != null) {
            dPoint.x = this.m_scalebarPoint.x;
            dPoint.y = this.m_scalebarPoint.y;
        }
        return this.m_scalebar;
    }

    protected void calcTraverse(Node node, double d) {
        Node node2 = null;
        if (node == null) {
            return;
        }
        double d2 = node.equals(this.m_root) ? 0.0 : (this.m_isUseLengths ? d + node.getUserLength() : 1.0);
        if (this.m_maxheight < d2) {
            this.m_maxheight = d2;
        }
        if (node.isTip()) {
            node.setX(this.m_tipx);
            if (this.m_isUseLengths) {
                node.setY(d2);
            } else {
                node.setY(1.0);
            }
            this.m_tipx += this.m_tipspacing;
        } else {
            double d3;
            double d4;
            double d5;
            double d6 = 0.0;
            double d7 = 0.0;
            double d8 = 0.0;
            double d9 = d5 = node.getX();
            double d10 = d4 = node.getY();
            Node node3 = node.getNext();
            if (node3 != null) {
                do {
                    this.calcTraverse(node3.getBack(), d2);
                    d7 += (double)node3.getBack().getTipsAbove();
                    d6 += (double)node3.getBack().getTipsAbove() * node3.getBack().getX();
                    if (Math.abs(node3.getBack().getX() - 0.5) < Math.abs(d8 - 0.5)) {
                        d8 = node3.getBack().getX();
                    }
                    node2 = node3;
                } while ((node3 = node3.getNext()) != null && node3 != node);
                d5 = node.getNext().getBack().getX();
                d4 = node.getNext().getBack().getY();
                d9 = node2.getBack().getX();
                d10 = node2.getBack().getY();
            }
            switch (this.m_styles.getNodePosition()) {
                case 0: {
                    d3 = d4 - d2;
                    double d11 = d10 - d2;
                    if (d3 + d11 <= 0.0) {
                        node.setX((d5 + d9) / 2.0);
                        break;
                    }
                    node.setX((d11 * d5 + d3 * d9) / (d3 + d11));
                    break;
                }
                case 1: {
                    node.setX((d5 + d9) / 2.0);
                    break;
                }
                case 2: {
                    node.setX(d6 / d7);
                    break;
                }
                case 3: {
                    node.setX(d8);
                    break;
                }
                case 4: {
                    node.setX((d5 + d9 + (d4 - d10) / this.m_maxheight) / 2.0);
                }
            }
            if (this.m_isUseLengths) {
                node.setY(d2);
            } else {
                node.setY((d5 - d9 + d4 + d10) / 2.0);
                if (this.m_styles.getNodePosition() == 3) {
                    if (Math.abs(d5 - 0.5) > Math.abs(d9 - 0.5)) {
                        node.setY(d4 + d5 - d9);
                        d3 = d10 - node.getY();
                    } else {
                        node.setY(d10 + d5 - d9);
                        d3 = d4 - node.getY();
                    }
                    if (d3 < 1.0E-5) {
                        node.setY(node.getY() - Math.abs(d5 - d9));
                    }
                }
            }
        }
    }

    protected void getTextLength() {
        int n = this.m_nodes.size();
        for (int i = 0; i < n; ++i) {
            Node node = (Node)this.m_nodes.elementAt(i);
            if (!node.isTip() || node.getName() == null || node.getName().length() <= 0) continue;
            this.m_firstlet = this.m_fm.charWidth(node.getName().charAt(0));
            this.m_textlength = this.m_fm.stringWidth(node.getName() + "()");
            if (!(this.m_textlength > this.m_maxtextlength)) continue;
            this.m_maxtextlength = this.m_textlength;
        }
    }

    protected void scaleYcoord() {
        double d = 1.0;
        double d2 = d * this.m_styles.getStemLength();
        double d3 = d * (1.0 - this.m_styles.getStemLength()) / (this.m_maxheight - this.m_rooty);
        this.m_maxyabs = 0.0;
        int n = this.m_nodes.size();
        for (int i = 0; i < n; ++i) {
            Node node = (Node)this.m_nodes.elementAt(i);
            if (node.getTipsAbove() == 0) continue;
            node.setYAbs(node.getY());
            if (this.m_maxyabs < node.getY()) {
                this.m_maxyabs = node.getY();
            }
            node.setY(d2 + d3 * (node.getY() - this.m_rooty));
        }
        this.m_maxheight = d2 + d3 * (this.m_maxheight - this.m_rooty);
    }

    protected void calculateRooted() {
        this.m_maxheight = 0.0;
        this.m_maxtextlength = 0.0;
        double d = 0.0;
        this.m_tipx = 0.0;
        int n = this.m_tree.getNumTips() > 1 ? this.m_tree.getNumTips() - 1 : 1;
        double d2 = this.m_styles.getNodeSpace();
        this.m_fontheight = this.m_fm.getHeight();
        this.m_labelHeight = 1.0 / (d2 * (double)n);
        this.m_tipspacing = 1.0 / (double)n;
        this.getTextLength();
        this.m_maxtextlength /= this.m_fontheight;
        this.m_textlength /= this.m_fontheight;
        this.m_firstlet /= this.m_fontheight;
        this.m_angle = Math.PI * this.m_styles.getLabelRotation() / 180.0;
        this.calcTraverse(this.m_root, d);
        this.m_rooty = this.m_tree.getRooty();
        if (this.m_styles.isNodeScaley()) {
            this.scaleYcoord();
        }
        this.m_rooty = 0.0;
        this.m_tree.setRooty(this.m_rooty);
    }

    protected void getWidth(Node node) {
        double d;
        double d2 = 0.0;
        if (node.isTip()) {
            d = 1.0;
        } else {
            d = 0.0;
            Node node2 = node;
            Node node3 = node.getNext();
            do {
                if (node3 != null) {
                    this.getWidth(node3.getBack());
                }
                d += node3.getBack().getWidth();
                if (!(node3.getBack().getDepth() > d2)) continue;
                d2 = node3.getBack().getDepth();
            } while ((node3 = node3.getNext()) != node2);
        }
        node.setDepth(d2 + (this.m_isUseLengths ? node.getUserLength() : 1.0));
        node.setWidth(d);
    }

    protected void polartrans(Node node, double d, double d2, double d3) {
        double d4 = node.getWidth();
        double d5 = d;
        double d6 = (d3 - d2) / d4;
        Node node2 = node;
        Node node3 = node.getNext();
        if (!node.isTip()) {
            d5 = d3;
            do {
                double d7;
                d5 -= node3.getBack().getWidth() / 2.0 * d6;
                double d8 = node.getR();
                double d9 = node.getTheta();
                if (this.m_styles.isRegular()) {
                    int n = 1;
                    while ((double)n * d6 < Math.PI * 2) {
                        n *= 2;
                    }
                    d7 = d5 >= 0.0 ? Math.PI * 2 / (double)n * Math.floor((double)n * d5 / (Math.PI * 2) + 0.5) : Math.PI * 2 / (double)n * Math.floor((double)n * d5 / (Math.PI * 2) - 0.5);
                } else {
                    d7 = d5;
                }
                double d10 = this.m_isUseLengths ? node3.getBack().getUserLength() : 1.0;
                node3.getBack().setR(Math.sqrt(Utils.sqr(d10) + Utils.sqr(d8) + 2.0 * d10 * d8 * Math.cos(d7 - d9)));
                if (Math.abs(d8 * Math.cos(d9) + d10 * Math.cos(d7)) > 1.0E-5) {
                    node3.getBack().setTheta(Math.atan((d8 * Math.sin(d9) + d10 * Math.sin(d7)) / (d8 * Math.cos(d9) + d10 * Math.cos(d7))));
                } else if (d8 * Math.sin(d9) + d10 * Math.sin(d7) >= 0.0) {
                    node3.getBack().setTheta(1.5707963267948966);
                } else {
                    node3.getBack().setTheta(4.71238898038469);
                }
                if (d8 * Math.cos(d9) + d10 * Math.cos(d7) < -1.0E-5) {
                    node3.getBack().setTheta(node3.getBack().getTheta() + Math.PI);
                }
                if (!node3.getBack().isTip()) {
                    this.polartrans(node3.getBack(), node3.getBack().getTheta(), d5 - node3.getBack().getWidth() * d6 / 2.0, d5 + node3.getBack().getWidth() * d6 / 2.0);
                }
                d5 -= node3.getBack().getWidth() / 2.0 * d6;
            } while ((node3 = node3.getNext()) != node2);
        }
    }

    protected void coordXY(Node node) {
        if (!node.isTip()) {
            for (Node node2 = node.getNext(); node2 != node && node2 != null; node2 = node2.getNext()) {
                this.coordXY(node2.getBack());
            }
        }
        if (node.isTip()) {
            node.setTextLength(this.m_fm.stringWidth(node.getName()));
        }
        this.m_xx = node.getR() * Math.cos(node.getTheta());
        this.m_yy = node.getR() * Math.sin(node.getTheta());
        if (this.m_xx > this.m_maxx) {
            this.m_maxx = this.m_xx;
        }
        if (this.m_xx < this.m_minx) {
            this.m_minx = this.m_xx;
        }
        if (this.m_yy > this.m_maxy) {
            this.m_maxy = this.m_yy;
        }
        if (this.m_yy < this.m_miny) {
            this.m_miny = this.m_yy;
        }
        node.setX(this.m_xx);
        node.setY(this.m_yy);
        node.setYAbs(node.getY());
        if (this.m_maxyabs < node.getY()) {
            this.m_maxyabs = node.getY();
        }
    }

    protected void setWidthLength() {
        int n = this.m_nodes.size();
        for (int i = 0; i < n; ++i) {
            Node node = (Node)this.m_nodes.elementAt(i);
            node.setWidth(1.0);
        }
    }

    protected void fixWidth() {
        int n = this.m_tree.getNumTips() > 1 ? this.m_tree.getNumTips() - 1 : 1;
        double d = (double)n / this.m_root.getWidth();
        int n2 = this.m_nodes.size();
        for (int i = 0; i < n2; ++i) {
            Node node = (Node)this.m_nodes.elementAt(i);
            node.setWidth(node.getWidth() * d);
        }
    }

    protected void fixTextLength() {
        int n = this.m_nodes.size();
        for (int i = 0; i < n; ++i) {
            Node node = (Node)this.m_nodes.elementAt(i);
            if (!node.isTip()) continue;
            node.setTextLength(node.getTextLength() / this.m_fontheight);
        }
    }

    protected void calculateUnrooted() {
        this.m_maxheight = 0.0;
        this.setWidthLength();
        this.getWidth(this.m_root);
        this.fixWidth();
        this.polartrans(this.m_root, this.m_styles.getAngle(), this.m_styles.getAngle() - this.m_styles.getArc() / 2.0, this.m_styles.getAngle() + this.m_styles.getArc() / 2.0);
        this.m_maxx = 0.0;
        this.m_minx = 0.0;
        this.m_maxy = 0.0;
        this.m_miny = 0.0;
        this.m_maxyabs = 0.0;
        this.coordXY(this.m_root);
        this.m_fontheight = this.m_fm.getHeight();
        if (this.m_styles.getLabelDirec() == 1) {
            this.m_labangle = Math.PI * this.m_styles.getLabelRotation() / 180.0;
        }
        this.m_maxheight = this.m_root.getDepth();
    }

    protected Rectangle locateStr(int n, int n2, long l, String string) {
        int n3 = this.m_fm.getHeight();
        int n4 = this.m_fm.stringWidth(string);
        Rectangle rectangle = new Rectangle(n, n2, n4, n3);
        return rectangle;
    }

    public Rectangle getPicRect() {
        Rectangle rectangle = new Rectangle();
        DPoint dPoint = new DPoint();
        DPoint dPoint2 = new DPoint();
        boolean bl = true;
        boolean bl2 = true;
        int n = 1;
        int n2 = 1;
        int n3 = (int)Math.round(this.m_styles.getLabelRotation());
        int n4 = this.m_nodes.size();
        for (int i = 0; i < n4; ++i) {
            Node node = (Node)this.m_nodes.elementAt(i);
            if (node.getTipsAbove() == 0 || Utils.isMissing(node.getX())) continue;
            if (bl) {
                dPoint2.x = dPoint.x = node.getX();
                dPoint2.y = dPoint.y = node.getY();
                bl = false;
            } else {
                if (node.getX() > dPoint.x) {
                    dPoint.x = node.getX();
                } else if (node.getX() < dPoint2.x) {
                    dPoint2.x = node.getX();
                }
                if (node.getY() > dPoint.y) {
                    dPoint.y = node.getY();
                } else if (node.getY() < dPoint2.y) {
                    dPoint2.y = node.getY();
                }
            }
            if (!node.isTip()) continue;
            Rectangle rectangle2 = this.locateStr(n, n2, n3, node.getName());
            if (bl2) {
                rectangle = rectangle2;
                bl2 = false;
            } else {
                rectangle = rectangle.union(rectangle2);
            }
            if (this.m_styles.isVertical()) {
                n = rectangle.x + rectangle.width + 2;
                continue;
            }
            n2 = rectangle.y + rectangle.height + 2;
        }
        this.m_tree.setTmin(dPoint2);
        this.m_tree.setTmax(dPoint);
        return rectangle;
    }

    protected void getTreeScale() {
        Rectangle rectangle = this.getPicRect();
        this.m_tree.getScale().x = 1.0;
        this.m_tree.getScale().y = 1.0;
    }

    protected void scaleXY(double d) {
        d = this.m_expandX * d;
        int n = this.m_nodes.size();
        for (int i = 0; i < n; ++i) {
            Node node = (Node)this.m_nodes.elementAt(i);
            if (node.getTipsAbove() == 0) continue;
            if (this.m_isUnrooted) {
                node.setX(this.m_expand * (node.getX() - this.m_minx));
                node.setY(this.m_expand * (node.getY() - this.m_miny));
            } else {
                node.setX(this.m_expand * (node.getX() - this.m_minx));
                node.setY(this.m_expand * (node.getY() - this.m_miny + this.m_rooty));
            }
            if (!this.m_styles.isVertical()) {
                double d2 = node.getY();
                node.setY(d - node.getX());
                node.setX(d2);
            }
            node.setX(node.getX() + this.m_xmargin + this.m_extrax);
            node.setY(node.getY() + this.m_ymargin + this.m_extray);
            if (this.m_rect.width < (int)node.getX()) {
                this.m_rect.width = (int)node.getX();
            }
            if (this.m_rect.height >= (int)node.getY()) continue;
            this.m_rect.height = (int)node.getY();
        }
    }

    protected double findTreeMax() {
        double d = 0.0;
        int n = this.m_nodes.size();
        for (int i = 0; i < n; ++i) {
            Node node = (Node)this.m_nodes.elementAt(i);
            if (node.getTipsAbove() == 0 || !(node.getY() > d)) continue;
            d = node.getY();
        }
        return d;
    }

    public double roundHeight(double d) {
        int n = 0;
        if (d != 0.0) {
            boolean bl;
            if ((d /= this.getAbsHeight()) < 0.0) {
                bl = true;
                d = Math.abs(d);
            } else {
                bl = false;
            }
            while (d >= 100.0) {
                d *= 0.1;
                ++n;
            }
            while (d < 10.0) {
                d *= 10.0;
                --n;
            }
            d = Math.floor(d);
        }
        return d * Math.pow(10.0, n);
    }

    protected void calcScalebar(double d) {
        double d2 = 1.0;
        int n = -1;
        this.m_scalebar = d2 * Math.pow(10.0, n);
        this.m_scalebarPoint.x = d2;
        this.m_scalebarPoint.y = n;
    }

    protected void rescale() {
        double d;
        double d2;
        this.m_xsize = this.m_rect.width;
        this.m_ysize = this.m_rect.height;
        this.m_xmargin = 0.1 * this.m_xsize;
        this.m_ymargin = 0.1 * this.m_ysize;
        if (this.m_xmargin < 40.0) {
            this.m_xmargin = 40.0;
        }
        if (this.m_ymargin < 40.0) {
            this.m_ymargin = 40.0;
        }
        this.m_expandY = 1.0;
        this.m_expandX = 1.0;
        this.m_expand = 1.0;
        this.m_extray = 10.0;
        this.m_extrax = 10.0;
        int n = this.m_tree.getNumTips() > 1 ? this.m_tree.getNumTips() - 1 : 1;
        double d3 = this.m_rect.width;
        double d4 = this.m_rect.height;
        if (this.m_isUnrooted) {
            this.m_maxheight = this.m_styles.isVertical() ? this.m_maxy - this.m_miny : this.m_maxx - this.m_minx;
            d2 = this.m_maxy - this.m_miny;
            d = this.m_maxx - this.m_minx;
        } else {
            if (this.m_maxheight == 0.0) {
                this.m_maxheight = this.findTreeMax();
            }
            d2 = this.m_maxheight;
            d = (double)n * this.m_tipspacing;
            d4 = this.m_rect.height;
            d3 = n * this.m_fm.getHeight();
        }
        if (this.m_isUnrooted) {
            this.m_rect.setSize((int)Math.max((double)this.m_rect.width, d3), (int)Math.max((double)this.m_rect.height, d4));
            this.m_expandX = (Math.max(d3, this.m_xsize) - 2.0 * this.m_xmargin) / d;
            this.m_expandY = (Math.max(d4, this.m_ysize) - 2.0 * this.m_ymargin) / d2;
        } else if (this.m_styles.isVertical()) {
            this.m_rect.setSize((int)Math.max((double)this.m_rect.width, d3), this.m_rect.height);
            this.m_expandX = (Math.max(d3, this.m_xsize) - 2.0 * this.m_xmargin) / d;
            this.m_expandY = (this.m_ysize - 2.0 * this.m_ymargin) / d2;
        } else {
            this.m_rect.setSize(this.m_rect.width, (int)Math.max((double)this.m_rect.height, d3));
            this.m_expandX = (Math.max(d3, this.m_ysize) - 2.0 * this.m_ymargin) / d;
            this.m_expandY = (this.m_xsize - 2.0 * this.m_xmargin) / d2;
        }
        this.m_expand = Math.min(this.m_expandY, this.m_expandX);
        this.scaleXY(d);
        this.m_rooty = this.m_styles.isVertical() ? this.m_ymargin + this.m_extray : this.m_xmargin + this.m_extrax;
        this.m_tree.setRooty(this.m_rooty);
        this.calcScalebar(this.getAbsHeight());
        this.getTreeScale();
    }
}

