/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.ptree.bean;

import cgdp.recog.ptree.bean.interfaces.CommandImpl;
import cgdp.recog.ptree.bean.interfaces.MediatorImpl;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import javax.swing.JButton;

public class ColorButton
extends JButton
implements CommandImpl {
    MediatorImpl m_mediatorImpl;

    public ColorButton(ActionListener actionListener, MediatorImpl mediatorImpl, String string) {
        this.m_mediatorImpl = mediatorImpl;
        this.setPreferredSize(new Dimension(40, 40));
        this.setBackground(ColorButton.str2Color(string));
        this.addActionListener(actionListener);
    }

    public static boolean isColor(String string) {
        if (string.length() != 7) {
            return false;
        }
        if (!string.startsWith("#")) {
            return false;
        }
        try {
            Integer.parseInt(string.substring(1), 16);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static Color str2Color(String string) {
        int n = Integer.parseInt(string.substring(1), 16);
        return new Color(n >> 16 & 0xFF, n >> 8 & 0xFF, n & 0xFF);
    }

    public static String color2Str(Color color) {
        String string = Integer.toString(color.getRed(), 16);
        string = string.length() == 1 ? "0" + string : string;
        String string2 = Integer.toString(color.getGreen(), 16);
        string2 = string2.length() == 1 ? "0" + string2 : string2;
        String string3 = Integer.toString(color.getBlue(), 16);
        string3 = string3.length() == 1 ? "0" + string3 : string3;
        return "#" + string + string2 + string3;
    }

    @Override
    public void execute() {
        this.m_mediatorImpl.chooseColor(this);
    }
}

