/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.ptree.bean;

import cgdp.recog.ptree.bean.NodeLabel;
import cgdp.recog.ptree.bean.NodeStyle;
import cgdp.recog.ptree.bean.TextShape;
import cgdp.recog.ptree.bean.Utils;
import cgdp.recog.ptree.bean.interfaces.NodeStyleImpl;
import cgdp.recog.util.StringTool;
import java.awt.FontMetrics;
import java.awt.Point;
import java.text.NumberFormat;
import java.util.Vector;

public class Node
implements NodeStyleImpl,
Cloneable {
    private static final int NO_VALUE = Integer.MIN_VALUE;
    public static NodeStyle stNdstyle = new NodeStyle();
    public static int stIndex = 0;
    static NumberFormat m_decform = NumberFormat.getNumberInstance();
    private int m_order;
    private boolean m_isTip;
    private boolean m_isSelect;
    private boolean m_isHideTree;
    private int m_tipsAbove;
    private int m_nameWidth;
    private double m_x;
    private double m_y;
    private double m_yAbs;
    private int m_h;
    private int m_v;
    private String m_name;
    private double m_userLength;
    private int bootstrapValue = Integer.MIN_VALUE;
    private NodeStyle m_ndStyle;
    private Node m_parent;
    private Node m_next;
    private Node m_back;
    private Vector m_children;
    private NodeLabel m_label;
    private TextShape m_text;
    private Object m_panel;
    private double m_width;
    private double m_depth;
    private double m_r;
    private double m_theta;
    private double m_oldTheta;
    private double m_textLength;
    private double m_firstLet;
    private boolean m_isMoved;

    public Node() {
        this.init();
    }

    protected void init() {
        this.m_order = stIndex++;
        this.m_isTip = false;
        this.m_isSelect = false;
        this.m_isHideTree = false;
        this.m_tipsAbove = 0;
        this.m_x = Double.MIN_VALUE;
        this.m_y = Double.MIN_VALUE;
        this.m_yAbs = Double.MIN_VALUE;
        this.m_width = Double.MIN_VALUE;
        this.m_depth = Double.MIN_VALUE;
        this.m_theta = Double.MIN_VALUE;
        this.m_userLength = 0.1;
        this.m_name = "";
        this.m_ndStyle = new NodeStyle(stNdstyle);
        this.m_isMoved = false;
    }

    public final int getOrder() {
        return this.m_order;
    }

    public final boolean isTip() {
        return this.m_isTip;
    }

    public final boolean isSelect() {
        return this.m_isSelect;
    }

    public final boolean isHideTree() {
        return this.m_isHideTree;
    }

    public final int getTipsAbove() {
        return this.m_tipsAbove;
    }

    public final int getNameWidth() {
        return this.m_nameWidth;
    }

    public final double getX() {
        return this.m_x;
    }

    public final double getY() {
        return this.m_y;
    }

    public final double getYAbs() {
        return this.m_yAbs;
    }

    public final int getH() {
        return this.m_h;
    }

    public final int getV() {
        return this.m_v;
    }

    public final String getName() {
        return this.m_name;
    }

    public final double getUserLength() {
        return this.m_userLength;
    }

    public int getBootstrapValue() {
        return this.bootstrapValue;
    }

    @Override
    public final NodeStyle getNodeStyle() {
        return this.m_ndStyle;
    }

    public final Node getParent() {
        return this.m_parent;
    }

    public final Node getNext() {
        return this.m_next;
    }

    public final Node getBack() {
        return this.m_back;
    }

    public final Vector getChildren() {
        if (this.m_children == null) {
            this.m_children = new Vector();
        }
        return this.m_children;
    }

    public final NodeLabel getLabel() {
        return this.m_label;
    }

    public final TextShape getTextShape() {
        return this.m_text;
    }

    public final Object getPanel() {
        return this.m_panel;
    }

    public final double getWidth() {
        return this.m_width;
    }

    public final double getDepth() {
        return this.m_depth;
    }

    public final double getR() {
        return this.m_r;
    }

    public final double getTheta() {
        return this.m_theta;
    }

    public final double getOldTheta() {
        return this.m_oldTheta;
    }

    public final double getTextLength() {
        return this.m_textLength;
    }

    public final double getFirstLet() {
        return this.m_firstLet;
    }

    public final boolean isMoved() {
        return this.m_isMoved;
    }

    public final void setOrder(int n) {
        this.m_order = n;
    }

    public final void setTip(boolean bl) {
        this.m_isTip = bl;
    }

    public final void setSelect(boolean bl) {
        this.m_isSelect = bl;
    }

    public final void setHideTree(boolean bl) {
        this.m_isHideTree = bl;
    }

    public final void setTipsAbove(int n) {
        this.m_tipsAbove = n;
    }

    public final void setNameWidth(int n) {
        this.m_nameWidth = n;
    }

    public final void setX(double d) {
        this.m_x = d;
    }

    public final void setY(double d) {
        this.m_y = d;
    }

    public final void setYAbs(double d) {
        this.m_yAbs = d;
    }

    public final void setH(int n) {
        this.m_h = n;
    }

    public final void setV(int n) {
        this.m_v = n;
    }

    public final void setName(String string) {
        this.m_name = string;
    }

    public void appendName(String string) {
        this.m_name = StringTool.isNull(string) ? string : this.m_name + string;
    }

    public final void setUserLength(double d) {
        this.m_userLength = d < 0.0 ? 0.0 : d;
    }

    public void setBootstrapValue(int n) {
        this.bootstrapValue = n;
    }

    public final void setNodeStyle(NodeStyle nodeStyle) {
        this.m_ndStyle = nodeStyle;
    }

    public final void setParent(Node node) {
        this.m_parent = node;
    }

    public final void setNext(Node node) {
        this.m_next = node;
    }

    public final void setBack(Node node) {
        this.m_back = node;
    }

    public final void setChildren(Vector vector) {
        this.m_children = vector;
    }

    public final void setLabel(NodeLabel nodeLabel) {
        this.m_label = nodeLabel;
    }

    public final void setTextShape(TextShape textShape) {
        this.m_text = textShape;
    }

    public final void setPanel(Object object) {
        this.m_panel = object;
    }

    public final void setWidth(double d) {
        this.m_width = d;
    }

    public final void setDepth(double d) {
        this.m_depth = d;
    }

    public final void setR(double d) {
        this.m_r = d;
    }

    public final void setTheta(double d) {
        this.m_theta = d;
    }

    public final void setOldTheta(double d) {
        this.m_oldTheta = d;
    }

    public final void setTextLength(double d) {
        this.m_textLength = d;
    }

    public final void setFirstLet(double d) {
        this.m_firstLet = d;
    }

    public final void setMoved(boolean bl) {
        this.m_isMoved = bl;
    }

    public final void setHV(int n, int n2) {
        this.m_h = n;
        this.m_v = n2;
    }

    public final void setHV(Point point) {
        this.m_h = point.x;
        this.m_v = point.y;
    }

    public final void setXY(double d, double d2) {
        this.m_x = d;
        this.m_y = d2;
    }

    public final void setXY(float f, float f2) {
        this.m_x = f;
        this.m_y = f2;
    }

    public int childSize() {
        if (this.m_children == null) {
            return 0;
        }
        return this.m_children.size();
    }

    public Node child(int n) {
        if (this.m_children == null) {
            return null;
        }
        return (Node)this.m_children.elementAt(n);
    }

    public boolean setHidden(boolean bl) {
        boolean bl2 = this.m_ndStyle.isHidden();
        this.m_ndStyle.setHidden(bl);
        return bl2;
    }

    public boolean isHidden() {
        boolean bl = false;
        return this.m_ndStyle.isHidden();
    }

    public final boolean toggleHidden() {
        return this.setHidden(!this.isHidden());
    }

    public final void clear() {
        this.m_isSelect = false;
        this.m_x = Double.MIN_VALUE;
        this.m_y = Double.MIN_VALUE;
        this.m_yAbs = Double.MIN_VALUE;
        this.m_h = 0;
        this.m_v = 0;
        this.m_width = Double.MIN_VALUE;
        this.m_depth = Double.MIN_VALUE;
        this.m_theta = Double.MIN_VALUE;
        this.m_nameWidth = 0;
    }

    public Object clone() {
        try {
            Node node = (Node)super.clone();
            node.clear();
            node.setNodeStyle(new NodeStyle(this.m_ndStyle));
            if (this.m_name != null && 0 < this.m_name.length()) {
                node.setName(new String(this.m_name));
            }
            return node;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.toString());
        }
    }

    public final void setNodeStyle(NodeStyle nodeStyle, NodeStyle nodeStyle2, int n) {
        this.m_ndStyle.set(nodeStyle, nodeStyle2, n);
        this.m_nameWidth = 0;
    }

    public final boolean isNeedStringWidths() {
        return this.m_name != null && this.m_nameWidth == 0;
    }

    public final void setStringWidths(FontMetrics fontMetrics) {
        this.m_nameWidth = this.m_name == null ? 0 : fontMetrics.stringWidth(this.m_name + "()");
    }

    public String toString() {
        String string = this.getClass().getName() + "[" + this.m_order;
        string = string + ",tip=" + this.m_isTip + ",tipsabove=" + this.m_tipsAbove + ",hidetree=" + this.m_isHideTree + ",h=" + this.m_h + ",v=" + this.m_v;
        string = string + (this.m_name == null ? "" : ",name=" + this.m_name);
        string = string + (this.m_next == null ? "" : ",next=" + String.valueOf(this.m_next.getOrder()));
        string = string + (this.m_back == null ? "" : ",back=" + String.valueOf(this.m_back.getOrder()));
        string = string + (Utils.isMissing(this.m_x) ? "" : ",x=" + this.m_x);
        string = string + (Utils.isMissing(this.m_y) ? "" : ",y=" + this.m_y);
        string = string + (Utils.isMissing(this.m_userLength) ? "" : ",userlen=" + this.m_userLength);
        string = string + (Utils.isMissing(this.m_width) ? "" : ",width=" + this.m_width);
        string = string + (Utils.isMissing(this.m_depth) ? "" : ",depth=" + this.m_depth);
        string = string + (Utils.isMissing(this.m_r) ? "" : ",r=" + this.m_r);
        string = string + (Utils.isMissing(this.m_theta) ? "" : ",theta=" + this.m_theta);
        string = string + "]";
        return string;
    }

    public static boolean isNoValue(int n) {
        return n == Integer.MIN_VALUE;
    }

    static {
        m_decform.setMaximumFractionDigits(8);
    }
}

