/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.ptree.bean;

import cgdp.recog.ptree.bean.data.PPoint;
import cgdp.recog.ptree.bean.dgGraphics;
import java.awt.Graphics;
import java.awt.Point;

public class Plotter
implements Cloneable {
    public static final double EPSILON = 1.0E-5;
    public static double NORTH = 0.0;
    public static double SOUTH = 180.0;
    public static double EAST = 90.0;
    public static double WEST = 270.0;
    public static double m_rad2degrees = 57.29577951308232;
    public static double m_halfPI = 1.5707963267948966;
    private boolean m_isPenIsUp;
    private double m_angle;
    private double m_vPos;
    private double m_hPos;
    private double m_vInc;
    private double m_hInc;
    private Graphics m_g;
    private dgGraphics m_dg;

    public Plotter(Graphics graphics, dgGraphics dgGraphics2) {
        this.m_g = graphics;
        this.m_dg = dgGraphics2 == null ? new dgGraphics(this.m_g) : dgGraphics2;
        this.init();
    }

    private void init() {
        this.m_isPenIsUp = false;
        this.m_angle = NORTH;
        this.m_vPos = 0.5;
        this.m_hPos = 0.5;
        this.m_vInc = -1.0;
        this.m_hInc = 0.0;
        this.syncPlotterTo();
    }

    public Graphics getGraphics() {
        return this.m_g;
    }

    public dgGraphics getDgGraphics() {
        return this.m_dg;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.toString());
        }
    }

    public static final double adjust(double d) {
        int n = d < 0.0 ? -1 : 1;
        double d2 = Math.abs(d) / 360.0;
        double d3 = d2 - Math.floor(d2);
        double d4 = (double)n * d3 * 360.0;
        if (n < 0) {
            d4 += 360.0;
        }
        return d4;
    }

    public static double headFromPt(double d, double d2) {
        boolean bl;
        boolean bl2 = d < 0.0;
        boolean bl3 = bl = d2 < 0.0;
        if (bl2) {
            d = -d;
        }
        if (bl) {
            d2 = -d2;
        }
        double d3 = d < 1.0E-5 && d2 < 1.0E-5 ? 0.0 : (d < 1.0E-5 ? 0.0 : (d2 < 1.0E-5 ? m_halfPI : Math.atan2(d, d2)));
        if (bl) {
            d3 = Math.PI - d3;
        }
        d3 = bl2 ? -Math.abs(d3) : Math.abs(d3);
        return m_rad2degrees * d3;
    }

    public static final double headFromTpt(PPoint pPoint, PPoint pPoint2) {
        return Plotter.headFromPt(pPoint2.x - pPoint.x, pPoint2.y - pPoint.y);
    }

    public void home() {
        this.setHeading(NORTH);
        this.setPosition(0, 0);
    }

    public final void penUp() {
        this.m_isPenIsUp = true;
    }

    public final void penDown() {
        this.m_isPenIsUp = false;
    }

    public void setPlotterHeading(double d) {
        this.m_angle = Plotter.adjust(d);
        double d2 = this.m_angle / m_rad2degrees;
        this.m_vInc = Math.cos(d2);
        this.m_hInc = Math.sin(d2);
    }

    public final void setHeading(double d) {
        this.setPlotterHeading(d);
    }

    public void setPosition(int n, int n2) {
        this.m_dg.moveto(n, n2);
        this.m_hPos = n;
        this.m_vPos = n2;
    }

    public final void turnRight(double d) {
        this.setPlotterHeading(this.m_angle + d);
    }

    public final void turnLeft(double d) {
        this.setPlotterHeading(this.m_angle - d);
    }

    public void forward(int n) {
        Point point = this.m_dg.atPoint();
        this.m_hPos = point.x;
        this.m_vPos = point.y;
        this.m_hPos += this.m_hInc * (double)n;
        this.m_vPos += this.m_vInc * (double)n;
        if (this.m_isPenIsUp) {
            this.m_dg.moveto((int)Math.round(this.m_hPos), (int)Math.round(this.m_vPos));
        } else {
            this.m_dg.lineto((int)Math.round(this.m_hPos), (int)Math.round(this.m_vPos));
        }
    }

    public final void back(int n) {
        this.forward(-n);
    }

    public final double heading() {
        return this.m_angle;
    }

    public void syncPlotterTo() {
        Point point = this.m_dg.atPoint();
        this.m_hPos = point.x;
        this.m_vPos = point.y;
    }

    public void getPlotter(PPoint pPoint) {
        this.syncPlotterTo();
        pPoint.set(this.m_angle, (int)Math.round(this.m_hPos), (int)Math.round(this.m_vPos));
    }

    public void setPlotter(PPoint pPoint) {
        this.setHeading(pPoint.h);
        this.setPosition(pPoint.x, pPoint.y);
    }
}

