/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.ptree.bean;

import cgdp.recog.ptree.bean.ColorItem;
import cgdp.recog.ptree.bean.ColorTool;
import cgdp.recog.ptree.bean.CommonProcess;
import cgdp.recog.ptree.bean.ExitItem;
import cgdp.recog.ptree.bean.FileOpenItem;
import cgdp.recog.ptree.bean.FileOpenTool;
import cgdp.recog.ptree.bean.Mediator;
import cgdp.recog.ptree.bean.PageSetupItem;
import cgdp.recog.ptree.bean.PdfItem;
import cgdp.recog.ptree.bean.PdfTool;
import cgdp.recog.ptree.bean.RedrawItem;
import cgdp.recog.ptree.bean.RedrawTool;
import cgdp.recog.ptree.bean.RootedHItem;
import cgdp.recog.ptree.bean.RootedHTool;
import cgdp.recog.ptree.bean.SetupItem;
import cgdp.recog.ptree.bean.SetupTool;
import cgdp.recog.ptree.bean.ShowLengthOnOffItem;
import cgdp.recog.ptree.bean.ShowLengthOnOffTool;
import cgdp.recog.ptree.bean.Tree;
import cgdp.recog.ptree.bean.TreeArea;
import cgdp.recog.ptree.bean.UnrootedItem;
import cgdp.recog.ptree.bean.UnrootedTool;
import cgdp.recog.ptree.bean.data.OptionValues;
import cgdp.recog.ptree.bean.interfaces.CommandImpl;
import cgdp.recog.ptree.bean.interfaces.MediatorImpl;
import cgdp.recog.ptree.bean.interfaces.RecogQueryImpl;
import cgdp.recog.util.ApplicationFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.ToolTipManager;
import javax.swing.border.BevelBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PtreeMainWindow
extends ApplicationFrame
implements ActionListener,
ChangeListener,
AdjustmentListener,
ComponentListener {
    private MediatorImpl m_mediator;
    private RecogQueryImpl m_queryImpl;
    private JScrollPane m_scrollPane;

    public PtreeMainWindow() {
        this((String)null, (RecogQueryImpl)null);
    }

    public PtreeMainWindow(RecogQueryImpl recogQueryImpl) {
        this((String)null, recogQueryImpl);
    }

    private PtreeMainWindow(String string, RecogQueryImpl recogQueryImpl) {
        this.m_queryImpl = recogQueryImpl;
        this.m_mediator = Mediator.createInstance(string, recogQueryImpl);
        this.m_mediator.register(this);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                PtreeMainWindow.this.m_mediator.exit();
            }
        });
        String string2 = CommonProcess.getPtreeTitle() + " " + CommonProcess.getVersion();
        this.setTitle(string2);
        this.setDefaultCloseOperation(0);
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        toolTipManager.setInitialDelay(750);
        toolTipManager.setDismissDelay(20000);
        toolTipManager.setReshowDelay(0);
        this.createMenu();
        this.createToolBar();
        this.createComponent();
        this.pack();
        OptionValues optionValues = this.m_mediator.getOptionTbl().getOptionValues();
        if (optionValues.getMainWindowW() != 0 && optionValues.getMainWindowH() != 0) {
            this.setBounds(optionValues.getMainWindowX(), optionValues.getMainWindowY(), optionValues.getMainWindowW(), optionValues.getMainWindowH());
        } else {
            this.setBounds(0, 0, 400, 400);
        }
        this.setVisible(true);
    }

    public PtreeMainWindow(MediatorImpl mediatorImpl, RecogQueryImpl recogQueryImpl) {
        this.m_queryImpl = recogQueryImpl;
        this.m_mediator = mediatorImpl;
        this.m_mediator.register(this);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                PtreeMainWindow.this.m_mediator.exit();
            }
        });
        String string = CommonProcess.getPtreeTitle() + " " + CommonProcess.getVersion();
        this.setTitle(string);
        this.setDefaultCloseOperation(0);
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        toolTipManager.setInitialDelay(750);
        toolTipManager.setDismissDelay(20000);
        toolTipManager.setReshowDelay(0);
        this.createMenu();
        this.createToolBar();
        this.createComponent();
        this.pack();
        OptionValues optionValues = this.m_mediator.getOptionTbl().getOptionValues();
        if (optionValues.getMainWindowW() != 0 && optionValues.getMainWindowH() != 0) {
            this.setBounds(optionValues.getMainWindowX(), optionValues.getMainWindowY(), optionValues.getMainWindowW(), optionValues.getMainWindowH());
        } else {
            this.setBounds(0, 0, 400, 400);
        }
        this.setVisible(true);
    }

    private void createMenu() {
        JMenuBar jMenuBar = new JMenuBar();
        this.setJMenuBar(jMenuBar);
        JMenu jMenu = new JMenu("File");
        jMenuBar.add(jMenu);
        jMenu.add(new FileOpenItem(this, this.m_mediator));
        jMenu.add(new PageSetupItem(this, this.m_mediator));
        jMenu.add(new PdfItem(this, this.m_mediator));
        jMenu.addSeparator();
        jMenu.add(new ExitItem(this, this.m_mediator));
        jMenu = new JMenu("View");
        jMenuBar.add(jMenu);
        jMenu.add(new RedrawItem(this, this.m_mediator));
        JMenu jMenu2 = new JMenu("Tree Style");
        jMenu.add(jMenu2);
        jMenu2.add(new RootedHItem(this, this.m_mediator));
        jMenu2.add(new UnrootedItem(this, this.m_mediator));
        jMenu.add(new ShowLengthOnOffItem(this, this.m_mediator));
        jMenu = new JMenu("Option Settings");
        jMenuBar.add(jMenu);
        jMenu.add(new ColorItem(this, this.m_mediator));
        jMenu.add(new SetupItem(this, this.m_mediator));
    }

    private void createToolBar() {
        JToolBar jToolBar = new JToolBar();
        this.getContentPane().add((Component)jToolBar, "North");
        jToolBar.add(new FileOpenTool(this, this.m_mediator));
        jToolBar.add(new PdfTool(this, this.m_mediator));
        jToolBar.addSeparator();
        jToolBar.add(new RedrawTool(this, this.m_mediator));
        jToolBar.add(new RootedHTool(this, this.m_mediator));
        jToolBar.add(new UnrootedTool(this, this.m_mediator));
        jToolBar.addSeparator();
        jToolBar.add(new ShowLengthOnOffTool(this, this.m_mediator));
        jToolBar.addSeparator();
        jToolBar.add(new ColorTool(this, this.m_mediator));
        jToolBar.add(new SetupTool(this, this.m_mediator));
    }

    private void createComponent() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new BevelBorder(1));
        this.getContentPane().add((Component)jPanel, "Center");
        TreeArea treeArea = new TreeArea(this.m_mediator, this.m_queryImpl, this);
        this.m_scrollPane = new JScrollPane(treeArea);
        this.m_scrollPane.setBorder(new BevelBorder(1));
        this.m_scrollPane.setVerticalScrollBarPolicy(22);
        this.m_scrollPane.setHorizontalScrollBarPolicy(32);
        this.m_scrollPane.addComponentListener(this);
        jPanel.add((Component)this.m_scrollPane, "Center");
    }

    public void setExitAction(int n) {
        this.m_mediator.setExitAction(n);
    }

    public Tree createTreeFromFile(String string) throws Exception {
        return this.m_mediator.createTreeFromFile(string);
    }

    public void updateTreeArea(Tree tree) throws Exception {
        this.m_mediator.updateTreeArea(tree);
    }

    public void readDnd(String string) {
        this.m_mediator.readDnd(string);
    }

    public void updateView() {
        if (this.m_queryImpl != null) {
            OptionValues optionValues = this.m_mediator.getOptionTbl().getOptionValues();
            optionValues.setInGroupColor(this.m_queryImpl.getInGroupColor());
            optionValues.setOutGroupColor(this.m_queryImpl.getOutGroupColor());
        }
        this.m_mediator.updateView();
    }

    public void done() {
        this.m_mediator.exit();
    }

    public RecogQueryImpl getQueryImpl() {
        return this.m_queryImpl;
    }

    public JScrollPane getScrollPane() {
        return this.m_scrollPane;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        ((CommandImpl)actionEvent.getSource()).execute();
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        ((CommandImpl)changeEvent.getSource()).execute();
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        ((CommandImpl)adjustmentEvent.getSource()).execute();
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        this.m_mediator.changeWindowSize();
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }
}

