/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.ptree.bean;

import cgdp.recog.ptree.bean.BaseShape;
import cgdp.recog.ptree.bean.Node;
import cgdp.recog.ptree.bean.NodeLabel;
import cgdp.recog.ptree.bean.NodeStyle;
import cgdp.recog.ptree.bean.NodeVector;
import cgdp.recog.ptree.bean.Plotter;
import cgdp.recog.ptree.bean.ShapeVector;
import cgdp.recog.ptree.bean.TextShape;
import cgdp.recog.ptree.bean.TextStyle;
import cgdp.recog.ptree.bean.TreeStyles;
import cgdp.recog.ptree.bean.Utils;
import cgdp.recog.ptree.bean.data.DPoint;
import cgdp.recog.ptree.bean.interfaces.NodeStyleImpl;
import cgdp.recog.ptree.bean.interfaces.ShapeImpl;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Vector;

public class Tree
implements ShapeImpl,
NodeStyleImpl,
Cloneable {
    public static TreeStyles gTreeStyles = new TreeStyles();
    protected Node m_root;
    protected NodeVector m_nodes;
    protected String m_name;
    protected TreeStyles m_styles;
    protected ShapeVector m_shapes;
    protected Vector m_textStyles;
    protected BaseShape m_drawer;
    protected boolean m_hasLengths;
    protected boolean m_isShapesArePinned;
    protected double m_rooty;
    protected DPoint m_scale;
    protected DPoint m_tmin;
    protected DPoint m_tmax;
    protected int m_nTips;
    protected int m_minDepth;
    protected int m_maxDepth;
    protected int m_fdx;
    protected int m_fdy;
    protected int m_boxWidth;

    public Tree() {
        this.init();
    }

    protected void init() {
        this.m_root = null;
        this.m_nTips = 0;
        this.m_maxDepth = Integer.MAX_VALUE;
        this.m_minDepth = Integer.MIN_VALUE;
        this.m_name = null;
        this.m_hasLengths = false;
        this.m_styles = new TreeStyles(gTreeStyles);
        this.m_shapes = new ShapeVector();
        this.m_textStyles = new Vector();
        this.m_nodes = new NodeVector();
        this.m_rooty = Double.MIN_VALUE;
        this.m_fdy = 0;
        this.m_fdx = 0;
        this.m_scale = new DPoint(1.0, 1.0);
        this.m_tmin = new DPoint();
        this.m_tmax = new DPoint();
        this.m_boxWidth = 5;
    }

    public final void setRoot(Node node) {
        this.m_root = node;
    }

    public final Node getRoot() {
        return this.m_root;
    }

    public final int getNumTips() {
        return this.m_nTips;
    }

    public final void setNumTips(int n) {
        this.m_nTips = n;
    }

    public final int getMinDepth() {
        return this.m_minDepth;
    }

    public final void setMinDepth(int n) {
        this.m_minDepth = n;
    }

    public final int getMaxDepth() {
        return this.m_maxDepth;
    }

    public final void setMaxDepth(int n) {
        this.m_maxDepth = n;
    }

    public final DPoint getScale() {
        return this.m_scale;
    }

    public final void setScale(DPoint dPoint) {
        this.m_scale = dPoint;
    }

    public final DPoint getTmin() {
        return this.m_tmin;
    }

    public final void setTmin(DPoint dPoint) {
        this.m_tmin = dPoint;
    }

    public final DPoint getTmax() {
        return this.m_tmax;
    }

    public final void setTmax(DPoint dPoint) {
        this.m_tmax = dPoint;
    }

    public final void setRooty(double d) {
        this.m_rooty = d;
    }

    public final double getRooty() {
        if (Utils.isMissing(this.m_rooty)) {
            return this.m_root.getY();
        }
        return this.m_rooty;
    }

    public final TreeStyles getStyles() {
        return this.m_styles;
    }

    public final void setStyles(TreeStyles treeStyles) {
        this.m_styles = treeStyles;
    }

    public final boolean hasLengths() {
        return this.m_hasLengths;
    }

    public final void setHasLengths(boolean bl) {
        this.m_hasLengths = bl;
    }

    public final boolean isShapesArePinned() {
        return this.m_isShapesArePinned;
    }

    public final void setShapesArePinned(boolean bl) {
        this.m_isShapesArePinned = bl;
    }

    public final boolean isUseLengths() {
        return this.m_hasLengths && this.m_styles.isUseLengths();
    }

    public final boolean isUnrooted() {
        return this.m_styles.getStyle() == 2;
    }

    public final boolean isVertical() {
        return this.m_styles.isVertical();
    }

    public final void setParams() {
        this.setNodePosition();
    }

    public final void setDrawer(BaseShape baseShape) {
        this.m_drawer = baseShape;
    }

    public BaseShape getDrawer() {
        return this.m_drawer;
    }

    public void setFontMetrics(FontMetrics fontMetrics) {
        this.m_boxWidth = Math.max(fontMetrics.getMaxAdvance(), fontMetrics.getHeight()) / 2;
    }

    public final void setName(String string) {
        this.m_name = string;
    }

    public final String getName() {
        return this.m_name;
    }

    public final ShapeVector getShapes() {
        return this.m_shapes;
    }

    public final void setShapes(ShapeVector shapeVector) {
        this.m_shapes = shapeVector;
    }

    public final Vector getTextStyles() {
        return this.m_textStyles;
    }

    public final void setTextStyles(Vector vector) {
        this.m_textStyles = vector;
    }

    public final int size() {
        return this.m_nodes.size();
    }

    public final Node nodeAt(int n) {
        return (Node)this.m_nodes.elementAt(n);
    }

    public final NodeVector getNodes() {
        return this.m_nodes;
    }

    private final void setNodes(NodeVector nodeVector) {
        this.m_nodes = nodeVector;
    }

    public Node newNode() {
        Node node = new Node();
        this.m_nodes.addElement(node);
        return node;
    }

    public void clear() {
        this.m_scale.set(1.0, 1.0);
        this.m_tmin.set();
        this.m_tmax.set();
        this.m_rooty = Double.MIN_VALUE;
        this.m_fdy = 0;
        this.m_fdx = 0;
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            this.nodeAt(i).clear();
        }
    }

    @Override
    public final boolean isSelected() {
        return this.m_drawer.isSelected();
    }

    @Override
    public final void setSelected(boolean bl) {
        this.m_drawer.setSelected(bl);
    }

    public boolean isVisible(Node node) {
        if (node == null) {
            return false;
        }
        if (node.getParent() != null && node.getParent().getNodeStyle().isHidden()) {
            return false;
        }
        return !node.isTip() || !node.getNodeStyle().isHidden();
    }

    protected void setNodePosition() {
        if (this.isUseLengths()) {
            this.m_styles.setNodePosition(1);
        } else {
            this.m_styles.setNodePosition(4);
        }
    }

    public void listNodes() {
        System.out.println("Tree.nodes:");
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            System.out.println(this.nodeAt(i));
        }
    }

    public int findNode(Point point) {
        boolean bl = false;
        Rectangle rectangle = this.m_drawer.getBounds();
        int n = point.x - rectangle.x;
        int n2 = point.y - rectangle.y;
        int n3 = this.size();
        for (int i = 0; i < n3; ++i) {
            Node node = this.nodeAt(i);
            Rectangle rectangle2 = new Rectangle(node.getH() - this.m_boxWidth, node.getV() - this.m_boxWidth, this.m_boxWidth * 2, this.m_boxWidth * 2);
            bl = rectangle2.contains(n, n2);
            if (!bl) continue;
            return i;
        }
        return -1;
    }

    public int findNode(Rectangle rectangle) {
        boolean bl = false;
        Rectangle rectangle2 = this.m_drawer.getBounds();
        rectangle.x -= rectangle2.x;
        rectangle.y -= rectangle2.y;
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            Node node = this.nodeAt(i);
            Rectangle rectangle3 = new Rectangle(node.getH() - this.m_boxWidth, node.getV() - this.m_boxWidth, this.m_boxWidth * 2, this.m_boxWidth * 2);
            bl = rectangle3.intersects(rectangle);
            if (!bl) continue;
            return i;
        }
        return -1;
    }

    public int findNodeById(int n) {
        int n2 = this.size();
        for (int i = 0; i < n2; ++i) {
            Node node = this.nodeAt(i);
            if (node.getOrder() != n) continue;
            return i;
        }
        return -1;
    }

    public Node firstSelectedNode() {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            Node node = this.nodeAt(i);
            if (!node.isSelect()) continue;
            return node;
        }
        return null;
    }

    @Override
    public NodeStyle getNodeStyle() {
        Node node = this.firstSelectedNode();
        return node == null ? null : node.getNodeStyle();
    }

    public int firstSelectedINode() {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            if (!this.nodeAt(i).isSelect()) continue;
            return i;
        }
        return -1;
    }

    public final void setNodeStyleNodes(NodeStyle nodeStyle, NodeStyle nodeStyle2) {
        this.setNodeStyleNodes(nodeStyle, nodeStyle2, null);
    }

    public void setNodeStyleNodes(NodeStyle nodeStyle, NodeStyle nodeStyle2, TextStyle textStyle) {
        boolean bl = this.setNodeStyleSomeNodes(nodeStyle, nodeStyle2, textStyle, false);
        if (bl) {
            this.setNodeStyleSomeNodes(nodeStyle, nodeStyle2, textStyle, true);
        }
    }

    protected boolean setNodeStyleSomeNodes(NodeStyle nodeStyle, NodeStyle nodeStyle2, TextStyle textStyle, boolean bl) {
        boolean bl2 = this.size() > 0;
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            int n2;
            Node node = this.nodeAt(i);
            if (!bl && !node.isSelect()) continue;
            if (textStyle == null) {
                n2 = -1;
            } else {
                this.m_textStyles.add(textStyle);
                n2 = this.m_textStyles.size() - 1;
            }
            node.setNodeStyle(nodeStyle, nodeStyle2, n2);
            bl2 = false;
        }
        return bl2;
    }

    public void moveShapes(Rectangle rectangle, Rectangle rectangle2) {
        int n = rectangle2.x - rectangle.x;
        int n2 = rectangle2.y - rectangle.y;
        if (n != 0 || n2 != 0) {
            this.m_isShapesArePinned = false;
            for (int i = 0; i < this.m_shapes.size(); ++i) {
                ((BaseShape)this.m_shapes.elementAt(i)).translate(n, n2);
            }
        }
    }

    protected void pinShape(Rectangle rectangle, Plotter plotter, BaseShape baseShape) {
        if (baseShape instanceof NodeLabel) {
            ((NodeLabel)baseShape).pinShape(this, plotter);
        }
        rectangle = rectangle.union(baseShape.getBounds());
    }

    public void setShapeRects(Plotter plotter) {
        if (this.m_drawer != null) {
            this.m_isShapesArePinned = true;
            Rectangle rectangle = this.m_drawer.getBounds();
            for (int i = 0; i < this.m_shapes.size(); ++i) {
                this.pinShape(rectangle, plotter, (BaseShape)this.m_shapes.elementAt(i));
            }
            this.m_drawer.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    public final NodeLabel storeLabel(int n, String string, Node node) {
        return this.storeLabel(n, string, node, 0, 0.0);
    }

    public NodeLabel storeLabel(int n, String string, Node node, int n2, double d) {
        if (n != 3) {
            if (n == 2) {
                string = Integer.toString(this.m_nodes.indexOf(node));
            }
            n2 = 0;
            d = 0.0;
        }
        NodeLabel nodeLabel = new NodeLabel(string, this, node, n2, d);
        this.m_shapes.addElement(nodeLabel);
        this.m_isShapesArePinned = false;
        return nodeLabel;
    }

    public final TextShape storeText(Node node) {
        TextShape textShape = new TextShape(node.getName(), 0, 0, 0, 0);
        textShape.setNode(node);
        this.m_shapes.addElement(textShape);
        return textShape;
    }

    @Override
    public final void setGraphics(Graphics graphics) {
        this.m_drawer.setGraphics(graphics);
    }

    @Override
    public final void draw() {
        this.m_drawer.draw();
    }

    @Override
    public final void drawOutline() {
        this.m_drawer.drawOutline();
    }

    @Override
    public final void setPen() {
        this.m_drawer.setPen();
    }

    @Override
    public final void highlight(int n, int n2) {
        this.m_drawer.highlight(n, n2);
    }

    @Override
    public final void setMagnify(boolean bl, double d, double d2) {
        this.m_drawer.setMagnify(bl, d, d2);
    }

    @Override
    public final int ID() {
        return this.m_drawer.ID();
    }

    @Override
    public int getX() {
        return this.m_drawer.getX();
    }

    @Override
    public int getY() {
        return this.m_drawer.getY();
    }

    @Override
    public final boolean contains(int n, int n2) {
        return this.m_drawer.contains(n, n2);
    }

    @Override
    public final void move(int n, int n2) {
        this.m_drawer.move(n, n2);
    }

    @Override
    public final void grow(int n, int n2) {
        this.m_drawer.grow(n, n2);
    }

    @Override
    public final void translate(int n, int n2) {
        this.m_drawer.translate(n, n2);
    }

    @Override
    public final void setBounds(int n, int n2, int n3, int n4) {
        this.m_drawer.setBounds(n, n2, n3, n4);
    }

    @Override
    public final boolean isLocked() {
        return this.m_drawer.isLocked();
    }

    @Override
    public final void setLocked(boolean bl) {
        this.m_drawer.setLocked(bl);
    }

    public Object clone() {
        try {
            Tree tree = (Tree)super.clone();
            tree.setName(new String(this.m_name));
            tree.setStyles(new TreeStyles(this.m_styles));
            tree.setShapes((ShapeVector)this.m_shapes.clone());
            tree.setTextStyles((Vector)this.m_textStyles.clone());
            tree.setNodes((NodeVector)this.m_nodes.clone());
            int n = this.m_nodes.indexOf(this.m_root);
            if (0 <= n) {
                tree.setRoot(tree.getNodes().nodeAt(n));
            }
            tree.setScale(new DPoint(this.m_scale));
            tree.setTmin(new DPoint(this.m_tmin));
            tree.setTmax(new DPoint(this.m_tmax));
            return tree;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.toString());
        }
    }

    @Override
    public final boolean contains(double d, double d2) {
        return this.m_drawer.contains(d, d2);
    }

    @Override
    public final boolean contains(double d, double d2, double d3, double d4) {
        return this.m_drawer.contains(d, d2, d3, d4);
    }

    @Override
    public final boolean contains(Point2D point2D) {
        return this.m_drawer.contains(point2D);
    }

    @Override
    public final boolean contains(Rectangle2D rectangle2D) {
        return this.m_drawer.contains(rectangle2D);
    }

    @Override
    public final Rectangle getBounds() {
        return this.m_drawer == null ? null : this.m_drawer.getBounds();
    }

    @Override
    public final Rectangle2D getBounds2D() {
        return this.m_drawer == null ? null : this.m_drawer.getBounds2D();
    }

    @Override
    public PathIterator getPathIterator(AffineTransform affineTransform) {
        return this.m_drawer.getPathIterator(affineTransform);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform affineTransform, double d) {
        return this.m_drawer.getPathIterator(affineTransform, d);
    }

    @Override
    public boolean intersects(double d, double d2, double d3, double d4) {
        return this.m_drawer.intersects(d, d2, d3, d4);
    }

    @Override
    public boolean intersects(Rectangle2D rectangle2D) {
        return this.m_drawer.intersects(rectangle2D);
    }

    public Node findParent(Node node) {
        return this.findParent(this.m_root, node);
    }

    private Node findParent(Node node, Node node2) {
        if (node != null && !node.isTip()) {
            int n = node.getChildren().size();
            for (int i = 0; i < n; ++i) {
                if (node.child(i) == node2) {
                    return node;
                }
                Node node3 = this.findParent(node.child(i), node2);
                if (node3 == null) continue;
                return node3;
            }
        }
        return null;
    }

    public Node findUpper(Node node) {
        return this.findUpper(this.m_root, this.m_root, node);
    }

    private Node findUpper(Node node, Node node2, Node node3) {
        if (node == null) {
            return null;
        }
        if (node.getOrder() == node3.getOrder()) {
            return node2;
        }
        for (Node node4 = node.getNext(); node4 != null && node4 != node; node4 = node4.getNext()) {
            Node node5 = this.findUpper(node4.getBack(), node, node3);
            if (node5 == null) continue;
            return node5;
        }
        return null;
    }
}

