/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.ptree.bean;

import cgdp.recog.ptree.bean.BaseShape;
import cgdp.recog.ptree.bean.CalcTree;
import cgdp.recog.ptree.bean.ColorButton;
import cgdp.recog.ptree.bean.CommonProcess;
import cgdp.recog.ptree.bean.Const;
import cgdp.recog.ptree.bean.IsTreeNodeAt;
import cgdp.recog.ptree.bean.Node;
import cgdp.recog.ptree.bean.NodeLabel;
import cgdp.recog.ptree.bean.NodeStyle;
import cgdp.recog.ptree.bean.NodeVector;
import cgdp.recog.ptree.bean.ScaleShape;
import cgdp.recog.ptree.bean.ShapeVector;
import cgdp.recog.ptree.bean.TextShape;
import cgdp.recog.ptree.bean.TextStyle;
import cgdp.recog.ptree.bean.Tree;
import cgdp.recog.ptree.bean.TreeAt;
import cgdp.recog.ptree.bean.TreeShape;
import cgdp.recog.ptree.bean.data.DPoint;
import cgdp.recog.ptree.bean.data.OptionTbl;
import cgdp.recog.ptree.bean.dgGraphics;
import cgdp.recog.ptree.bean.interfaces.CommandImpl;
import cgdp.recog.ptree.bean.interfaces.IsShapeImpl;
import cgdp.recog.ptree.bean.interfaces.MediatorImpl;
import cgdp.recog.ptree.bean.interfaces.RecogQueryImpl;
import cgdp.recog.ptree.bean.interfaces.ShapeImpl;
import com.lowagie.text.Document;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class TreeArea
extends JPanel
implements ActionListener,
MouseListener,
MouseMotionListener,
Printable {
    private static final int DRAG_MOVE_SIZE = 30;
    protected MediatorImpl m_mediatorImpl;
    protected RecogQueryImpl m_queryImpl;
    protected OptionTbl m_optionTbl;
    protected BufferedImage m_image;
    protected Graphics m_g;
    protected Font m_font;
    protected JFrame m_frame;
    protected Tree m_tree;
    protected CalcTree m_calc;
    protected ShapeVector m_shapes;
    protected ShapeImpl m_selectedShape;
    protected Cursor m_curCursor;
    protected Cursor m_defaultCursor;
    protected Color m_curColor;
    protected boolean m_isMagnify;
    protected double m_magX;
    protected double m_magY;
    protected int m_lastX;
    protected int m_lastY;
    protected int m_x0;
    protected int m_y0;
    protected boolean m_isOutlineShown;
    protected boolean m_isFillShown;
    protected java.awt.Rectangle m_anchor;
    protected TreeAt m_treeAt;
    protected TreeAt m_treeAnchor;
    protected BaseShape m_nodeShape;
    protected Node m_upperNode;
    protected Node m_dragNode;
    protected Node m_changeNode;
    protected ArrayList m_childList;
    protected boolean m_isBaseClicked;
    protected boolean m_isMovedNode;
    protected boolean m_isPinYmove;
    protected boolean m_isPinXmove;
    protected java.awt.Rectangle m_treeBox;
    BufferedImage m_pdfImage;
    Graphics m_pdfG;
    protected TreeMap m_groupNodeMap;
    protected TreeMap m_spidColorMap;

    public TreeArea(MediatorImpl mediatorImpl, RecogQueryImpl recogQueryImpl, JFrame jFrame) {
        this.m_mediatorImpl = mediatorImpl;
        this.m_queryImpl = recogQueryImpl;
        this.m_frame = jFrame;
        this.m_optionTbl = this.m_mediatorImpl.getOptionTbl();
        this.m_mediatorImpl.register(this);
        this.clear();
        this.setLayout(null);
        this.setFont(this.m_font);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    protected void clear() {
        this.m_image = null;
        this.m_g = null;
        this.m_font = this.m_optionTbl.getFont();
        this.m_tree = null;
        this.m_calc = new CalcTree(this.m_tree, this);
        this.m_calc.setFontMetrics(this.getFontMetrics(this.m_font));
        this.m_shapes = new ShapeVector();
        this.m_selectedShape = null;
        this.m_curCursor = new Cursor(12);
        this.m_defaultCursor = new Cursor(0);
        this.m_curColor = Color.black;
        this.m_isMagnify = false;
        this.m_magX = 1.0;
        this.m_magY = 1.0;
        this.m_lastY = 0;
        this.m_lastX = 0;
        this.m_y0 = 0;
        this.m_x0 = 0;
        this.m_isOutlineShown = false;
        this.m_isFillShown = false;
        this.m_anchor = null;
        this.m_treeAt = new TreeAt();
        this.m_treeAnchor = null;
        this.m_nodeShape = null;
        this.m_upperNode = null;
        this.m_dragNode = null;
        this.m_changeNode = null;
        this.m_childList = new ArrayList();
        this.m_isBaseClicked = false;
        this.m_isMovedNode = false;
        this.m_isPinYmove = false;
        this.m_isPinXmove = false;
        this.m_treeBox = null;
        this.m_groupNodeMap = new TreeMap();
        this.m_spidColorMap = new TreeMap();
    }

    public void setCurCurosr(Cursor cursor) {
        this.m_curCursor = cursor;
    }

    public Tree getTree() {
        return this.m_tree;
    }

    public TreeMap getGroupNodeMap() {
        return this.m_groupNodeMap;
    }

    public TreeMap getSpeciesColorMap() {
        return this.m_spidColorMap;
    }

    public void changeWindowSize() throws Exception {
        Dimension dimension = this.getSize();
        int n = dimension.width;
        int n2 = dimension.height;
        if (n <= 0 || n2 <= 0) {
            this.m_image = null;
            this.repaint();
            return;
        }
        if (this.m_image == null || this.m_image.getWidth() != n || this.m_image.getHeight() != n2) {
            this.m_image = new BufferedImage(n, n2, 1);
            this.m_g = this.m_image.getGraphics();
            this.draw();
        }
        this.repaint();
    }

    public void setTree(Tree tree) throws Exception {
        this.m_tree = tree;
        this.setGroups(tree);
        this.initDraw(this.getSize());
    }

    private void setGroups(Tree tree) throws Exception {
        String string;
        int n;
        if (tree == null) {
            return;
        }
        this.m_groupNodeMap.clear();
        this.m_spidColorMap.clear();
        for (int i = 0; i < tree.getNodes().size(); ++i) {
            boolean bl;
            Node node = tree.getNodes().nodeAt(i);
            if (!node.isTip()) continue;
            String string2 = node.getName();
            n = string2.indexOf(95);
            if (n != -1) {
                string = string2.substring(0, n);
                bl = this.m_queryImpl != null ? this.m_queryImpl.isInGroup(string) : false;
                this.m_spidColorMap.put(string, new String(""));
            } else {
                bl = false;
            }
            this.m_groupNodeMap.put(string2, new Boolean(bl));
        }
        if (!this.m_spidColorMap.isEmpty()) {
            Iterator iterator = this.m_spidColorMap.keySet().iterator();
            n = 0;
            while (iterator.hasNext()) {
                ++n;
                string = (String)iterator.next();
                if (this.m_queryImpl != null) {
                    this.m_spidColorMap.put(string, this.m_queryImpl.getSpeciesColor(string));
                    continue;
                }
                this.m_spidColorMap.put(string, this.getSpeciesColor(n));
            }
        }
    }

    private String getSpeciesColor(int n) {
        int n2 = n;
        if (10 < n && (n2 = n % 10) == 0) {
            n2 = 10;
        }
        return Const.SpeciesColors[n2 - 1];
    }

    public void showLengthOnOff() {
        boolean bl = this.m_optionTbl.getOptionValues().isShowLength();
        NodeVector nodeVector = this.m_tree.getNodes();
        for (int i = 0; i < nodeVector.size(); ++i) {
            Node node = nodeVector.nodeAt(i);
            node.getNodeStyle().setShowLength(bl);
        }
        this.draw();
        this.repaint();
    }

    public void changeTreeStyle(Dimension dimension) {
        NodeVector nodeVector = this.m_tree.getNodes();
        for (int i = 0; i < nodeVector.size(); ++i) {
            Node node = nodeVector.nodeAt(i);
            node.setMoved(false);
        }
        this.initDraw(dimension);
    }

    public void changeFont(Font font) {
        this.m_font = font;
        this.setFont(this.m_font);
        this.m_calc.setFontMetrics(this.getFontMetrics(this.m_font));
        Vector vector = this.m_tree.getTextStyles();
        for (int i = 0; i < vector.size(); ++i) {
            TextStyle textStyle = (TextStyle)vector.elementAt(i);
            if (textStyle == null) continue;
            textStyle.changeFont(this.m_font);
        }
        this.initDraw(this.getSize());
    }

    public void changeNodeSymbol(int n) {
        this.changeNodeVectorSymbol(n);
        this.updateShapes();
        this.draw();
        this.revalidate();
        this.repaint();
    }

    public void changeNodeVectorSymbol(int n) {
        NodeVector nodeVector = this.m_tree.getNodes();
        block4: for (int i = 0; i < nodeVector.size(); ++i) {
            Node node = nodeVector.nodeAt(i);
            NodeStyle nodeStyle = node.getNodeStyle();
            switch (n) {
                case 1: {
                    nodeStyle.setDoBox(true);
                    nodeStyle.setDoCircle(false);
                    continue block4;
                }
                case 2: {
                    nodeStyle.setDoBox(false);
                    nodeStyle.setDoCircle(true);
                    continue block4;
                }
                default: {
                    nodeStyle.setDoBox(false);
                    nodeStyle.setDoCircle(false);
                }
            }
        }
    }

    public void colorChanged() throws Exception {
        this.setGroups(this.m_tree);
        this.draw();
        this.repaint();
    }

    private void setSpeciesColor() {
        if (this.m_tree == null) {
            return;
        }
        for (int i = 0; i < this.m_tree.getNodes().size(); ++i) {
            Object object;
            String string;
            Node node = this.m_tree.getNodes().nodeAt(i);
            if (!node.isTip() || node.getNodeStyle().isNoLabel() || !(node.getTextShape() instanceof TextShape)) continue;
            String string2 = node.getName();
            int n = string2.indexOf(95);
            Color color = n != -1 ? ((string = (String)this.m_spidColorMap.get(object = string2.substring(0, n))) != null ? ColorButton.str2Color(string) : ColorButton.str2Color("#000000")) : ColorButton.str2Color("#000000");
            object = node.getTextShape();
            if (object == null) continue;
            ((BaseShape)object).setColor(color);
        }
    }

    private void setOutInGroupColor() {
        Color color;
        Color color2;
        if (this.m_tree == null) {
            return;
        }
        if (this.m_queryImpl != null) {
            color2 = ColorButton.str2Color(this.m_queryImpl.getInGroupColor());
            color = ColorButton.str2Color(this.m_queryImpl.getOutGroupColor());
        } else {
            color2 = ColorButton.str2Color(this.m_optionTbl.getOptionValues().getInGroupColor());
            color = ColorButton.str2Color(this.m_optionTbl.getOptionValues().getOutGroupColor());
        }
        for (int i = 0; i < this.m_tree.getNodes().size(); ++i) {
            Node node = this.m_tree.getNodes().nodeAt(i);
            if (!node.isTip() || node.getNodeStyle().isNoLabel() || !(node.getTextShape() instanceof TextShape)) continue;
            String string = node.getName();
            boolean bl = (Boolean)this.m_groupNodeMap.get(string);
            TextShape textShape = node.getTextShape();
            if (textShape == null) continue;
            if (bl) {
                textShape.setColor(color2);
                continue;
            }
            textShape.setColor(color);
        }
    }

    public void initDraw(Dimension dimension) {
        this.doCalc(dimension);
        java.awt.Rectangle rectangle = this.m_calc.getRect();
        java.awt.Rectangle rectangle2 = this.getBounds();
        this.setPreferredSize(rectangle.getSize());
        this.m_image = new BufferedImage(rectangle.width, rectangle.height, 1);
        this.m_g = this.m_image.getGraphics();
        this.updateShapes();
        this.draw();
        this.revalidate();
        this.repaint();
    }

    protected void doCalc(Dimension dimension) {
        if (this.m_tree == null) {
            return;
        }
        this.m_tree.clear();
        this.m_tree.setDrawer(null);
        int n = this.m_optionTbl.getOptionValues().getTreeStyle();
        this.m_tree.getStyles().setStyle(n);
        if (n == 0) {
            this.m_tree.getStyles().setVertical(true);
        } else {
            this.m_tree.getStyles().setVertical(false);
        }
        boolean bl = this.m_optionTbl.getOptionValues().isShowLength();
        int n2 = this.m_optionTbl.getOptionValues().getNodeSymbol();
        NodeVector nodeVector = this.m_tree.getNodes();
        block4: for (int i = 0; i < nodeVector.size(); ++i) {
            Node node = nodeVector.nodeAt(i);
            NodeStyle nodeStyle = node.getNodeStyle();
            nodeStyle.setShowLength(bl);
            switch (n2) {
                case 1: {
                    nodeStyle.setDoBox(true);
                    nodeStyle.setDoCircle(false);
                    continue block4;
                }
                case 2: {
                    nodeStyle.setDoBox(false);
                    nodeStyle.setDoCircle(true);
                    continue block4;
                }
                default: {
                    nodeStyle.setDoBox(false);
                    nodeStyle.setDoCircle(false);
                }
            }
        }
        this.m_calc = new CalcTree(this.m_tree, this);
        this.m_calc.setFontMetrics(this.getFontMetrics(this.m_font));
        this.m_calc.setRect(new java.awt.Rectangle(dimension));
        this.m_calc.doCalc();
    }

    protected void doScale() {
        if (this.m_tree == null) {
            return;
        }
        this.m_calc.doScale();
    }

    protected void updateShapes() {
        if (this.m_tree == null) {
            return;
        }
        this.clearShapes();
        TreeShape treeShape = new TreeShape(this, this.m_tree, this.m_calc);
        TextStyle textStyle = new TextStyle(null, this.m_font);
        treeShape.setNcStyle(textStyle);
        treeShape.setGraphics(this.getGraphics());
        this.m_tree.setDrawer(treeShape);
        this.addShape(treeShape);
        this.addTreeShapes();
        ScaleShape scaleShape = new ScaleShape(this, this.m_tree, this.m_calc);
        treeShape.setNcStyle(textStyle);
        this.addShape(scaleShape);
        treeShape.setScalebar(scaleShape);
        if (this.m_tree.getName() == null) {
            this.m_tree.setName("Tree");
        }
        if (this.m_tree.getName() != null) {
            TextShape textShape = new TextShape(this.m_tree.getName(), 10, 10, 100, 30);
            textShape.setFont(this.m_font);
            textShape.setGraphics(this.getGraphics());
            textShape.setExtent();
            this.addShape(textShape);
        }
    }

    public void draw() {
        if (this.m_image == null) {
            return;
        }
        this.m_g.setColor(Color.white);
        this.m_g.fillRect(0, 0, this.m_image.getWidth(), this.m_image.getHeight());
        this.drawTree(this.m_g);
    }

    public void drawTree(Graphics graphics) {
        if (this.m_tree == null) {
            return;
        }
        if (this.m_optionTbl.getOptionValues().getColorType() == 0) {
            this.setSpeciesColor();
        } else {
            this.setOutInGroupColor();
        }
        for (int i = 0; i < this.m_shapes.size(); ++i) {
            ShapeImpl shapeImpl = this.m_shapes.shapeAt(i);
            shapeImpl.setGraphics(graphics);
            shapeImpl.setMagnify(this.m_isMagnify, this.m_magX, this.m_magY);
            shapeImpl.draw();
            shapeImpl.highlight(0, 1);
        }
    }

    protected void addShape(ShapeImpl shapeImpl) {
        if (shapeImpl != null) {
            this.m_shapes.addElement(shapeImpl);
        }
    }

    protected void registerShape(ShapeImpl shapeImpl) {
        if (shapeImpl != null) {
            java.awt.Rectangle rectangle = this.getBounds();
            java.awt.Rectangle rectangle2 = shapeImpl.getBounds();
            rectangle2.grow(20, 20);
            rectangle.add(rectangle2);
            this.setSize(rectangle.width, rectangle.height);
        }
    }

    protected void clearShapes() {
        this.m_shapes.removeAllElements();
        this.m_selectedShape = null;
    }

    protected void addTreeShapes() {
        if (this.m_tree != null) {
            ShapeVector shapeVector = this.m_tree.getShapes();
            java.awt.Rectangle rectangle = this.m_tree.getBounds();
            int n = rectangle.x;
            int n2 = rectangle.y;
            for (int i = 0; i < shapeVector.size(); ++i) {
                BaseShape baseShape = (BaseShape)shapeVector.elementAt(i);
                baseShape.setGraphics(this.m_g);
                baseShape.setVisible(false);
                baseShape.translate(n, n2);
                this.addShape(baseShape);
            }
        }
    }

    public void selectAll() {
        this.selectAll(1);
    }

    public void selectAll(int n) {
        boolean bl = false;
        switch (n) {
            case 1: {
                bl = true;
                break;
            }
            case 0: {
                bl = false;
                break;
            }
            case -1: {
                this.m_selectedShape = null;
                for (int i = 0; i < this.m_shapes.size(); ++i) {
                    ShapeImpl shapeImpl;
                    shapeImpl.setSelected(!(shapeImpl = this.m_shapes.shapeAt(i)).isSelected());
                    if (!shapeImpl.isSelected()) continue;
                    this.m_selectedShape = shapeImpl;
                }
                return;
            }
        }
        for (int i = 0; i < this.m_shapes.size(); ++i) {
            ShapeImpl shapeImpl = this.m_shapes.shapeAt(i);
            shapeImpl.setSelected(bl);
        }
        this.m_selectedShape = bl ? this.m_shapes.front() : null;
    }

    public void removeShape() {
        if (this.m_selectedShape != null) {
            this.m_shapes.removeElement(this.m_selectedShape);
            this.m_selectedShape = null;
        }
    }

    protected void removeShape(ShapeImpl shapeImpl) {
        if (shapeImpl != null) {
            this.m_shapes.removeElement(shapeImpl);
        }
    }

    public final ShapeImpl selectedShape() {
        return this.m_selectedShape;
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.m_image != null) {
            graphics.drawImage(this.m_image, 0, 0, null);
        }
    }

    private void showPopup(Point point) {
    }

    private void checkPopupTrigger(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger() && mouseEvent.getClickCount() == 1) {
            this.showPopup(mouseEvent.getPoint());
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        ((CommandImpl)actionEvent.getSource()).execute();
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (this.m_frame != null) {
            this.m_frame.setCursor(this.m_defaultCursor);
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        int n = mouseEvent.getPoint().x;
        int n2 = mouseEvent.getPoint().y;
        this.m_lastX = n;
        this.m_lastY = n2;
        ShapeImpl shapeImpl = this.m_shapes.shapeAt(n, n2);
        if (this.m_selectedShape != null && this.m_selectedShape != shapeImpl) {
            this.m_selectedShape.setSelected(false);
            this.repaint();
        }
        if (shapeImpl != null) {
            if (shapeImpl.isLocked()) {
                shapeImpl = null;
            } else {
                this.m_anchor = shapeImpl.getBounds();
                this.m_selectedShape = shapeImpl;
            }
        }
        if (this.m_selectedShape != null) {
            if (this.m_selectedShape instanceof NodeLabel) {
                this.m_selectedShape = null;
            } else if (this.m_selectedShape instanceof TreeShape) {
                this.m_isBaseClicked = this.baseClick(mouseEvent, this.m_selectedShape);
                this.m_isMovedNode = false;
                if (this.m_isBaseClicked) {
                    this.m_treeAnchor = new TreeAt();
                    this.m_treeAnchor.set(this.m_treeAt);
                    this.startMoveNode(mouseEvent.isShiftDown());
                }
            }
        }
        this.checkPopupTrigger(mouseEvent);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.m_isBaseClicked) {
            if (this.m_nodeShape != null) {
                this.moveShape(this.m_nodeShape, 0, 0, false, this.m_isOutlineShown, false);
                if (this.m_treeAt.getTree().isUnrooted()) {
                    Node node = this.m_treeAt.getTree().nodeAt(this.m_treeAt.at());
                    TreeShape treeShape = this.m_treeAnchor.getTreeShape();
                    int n = this.m_nodeShape.getX() - treeShape.getBounds().x;
                    int n2 = this.m_nodeShape.getY() - treeShape.getBounds().y;
                    int n3 = n - node.getH();
                    int n4 = n2 - node.getV();
                    DPoint dPoint = treeShape.getDgGraphics().map2world(n, n2);
                    node.setHV(n, n2);
                    node.setXY(dPoint.x, dPoint.y);
                    this.moveChildren(node, n3, n4, treeShape.getDgGraphics());
                } else if (this.m_upperNode == null || this.m_changeNode == null) {
                    int n;
                    int n5;
                    Node node = this.m_treeAt.getTree().nodeAt(this.m_treeAt.at());
                    TreeShape treeShape = this.m_treeAnchor.getTreeShape();
                    if (this.m_treeAt.getTree().isVertical()) {
                        n5 = this.m_nodeShape.getX() - treeShape.getBounds().x;
                        n = this.m_dragNode.getV();
                    } else {
                        n5 = this.m_dragNode.getH();
                        n = this.m_nodeShape.getY() - treeShape.getBounds().y;
                    }
                    int n6 = n5 - node.getH();
                    int n7 = n - node.getV();
                    DPoint dPoint = treeShape.getDgGraphics().map2world(n5, n);
                    node.setHV(n5, n);
                    node.setXY(dPoint.x, dPoint.y);
                    this.moveChildren(node, n6, n7, treeShape.getDgGraphics());
                } else if (this.m_changeNode != null) {
                    int n;
                    int n8;
                    int n9;
                    int n10;
                    TreeShape treeShape = this.m_treeAnchor.getTreeShape();
                    if (this.m_treeAt.getTree().isVertical()) {
                        n10 = this.m_changeNode.getH();
                        n9 = this.m_dragNode.getV();
                        n8 = this.m_dragNode.getH();
                        n = this.m_changeNode.getV();
                    } else {
                        n10 = this.m_dragNode.getH();
                        n9 = this.m_changeNode.getV();
                        n8 = this.m_changeNode.getH();
                        n = this.m_dragNode.getV();
                    }
                    Node node = this.m_dragNode;
                    int n11 = n10 - node.getH();
                    int n12 = n9 - node.getV();
                    DPoint dPoint = treeShape.getDgGraphics().map2world(n10, n9);
                    node.setHV(n10, n9);
                    node.setXY(dPoint.x, dPoint.y);
                    this.moveChildren(node, n11, n12, treeShape.getDgGraphics());
                    node = this.m_changeNode;
                    n11 = n8 - node.getH();
                    n12 = n - node.getV();
                    dPoint = treeShape.getDgGraphics().map2world(n8, n);
                    node.setHV(n8, n);
                    node.setXY(dPoint.x, dPoint.y);
                    this.moveChildren(node, n11, n12, treeShape.getDgGraphics());
                }
                this.draw();
                this.repaint();
                this.m_nodeShape = null;
                this.m_upperNode = null;
                this.m_dragNode = null;
                this.m_changeNode = null;
                this.m_childList.clear();
            }
            this.m_isBaseClicked = false;
        } else {
            if (this.m_selectedShape != null && !(this.m_selectedShape instanceof TreeShape)) {
                TextShape textShape;
                Node node;
                if (this.m_selectedShape instanceof TextShape && (node = (textShape = (TextShape)this.m_selectedShape).getNode()) != null) {
                    node.setMoved(true);
                }
                this.m_shapes.bringToFront(this.m_selectedShape);
                this.m_selectedShape.setSelected(this.m_selectedShape.isSelected());
                this.draw();
                this.repaint();
            }
            this.m_nodeShape = null;
            this.m_upperNode = null;
            this.m_dragNode = null;
            this.m_changeNode = null;
            this.m_childList.clear();
            this.m_lastX = mouseEvent.getX();
            this.m_lastY = mouseEvent.getY();
        }
        this.checkPopupTrigger(mouseEvent);
    }

    private void moveChildren(Node node, int n, int n2, dgGraphics dgGraphics2) {
        if (node == null) {
            return;
        }
        int n3 = node.getChildren().size();
        for (int i = 0; i < n3; ++i) {
            Node node2 = node.child(i);
            if (node2 == null) continue;
            int n4 = node2.getH() + n;
            int n5 = node2.getV() + n2;
            DPoint dPoint = dgGraphics2.map2world(n4, n5);
            node2.setHV(n4, n5);
            node2.setXY(dPoint.x, dPoint.y);
            this.moveChildren(node2, n, n2, dgGraphics2);
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        int n = mouseEvent.getPoint().x;
        int n2 = mouseEvent.getPoint().y;
        int n3 = n - this.m_lastX;
        int n4 = n2 - this.m_lastY;
        if (this.m_isBaseClicked) {
            TreeAt treeAt = new TreeAt();
            boolean bl = false;
            Object var8_11 = null;
            FontMetrics fontMetrics = this.getFontMetrics(this.m_font);
            int n5 = Math.max(fontMetrics.getMaxAdvance(), fontMetrics.getHeight()) / 2;
            java.awt.Rectangle rectangle = new java.awt.Rectangle(this.m_treeBox);
            rectangle.x += n5 + 1;
            rectangle.y += n5 + 1;
            Point point = dgGraphics.pinRect(rectangle, mouseEvent.getPoint());
            rectangle = null;
            n = point.x;
            n2 = point.y;
            java.awt.Rectangle rectangle2 = this.m_nodeShape.getBounds();
            rectangle2.x = n;
            rectangle2.y = n2;
            if (this.m_isPinXmove) {
                n3 = 0;
                rectangle2.x = this.m_treeBox.x;
                rectangle2.width = this.m_treeBox.width;
            } else {
                n3 = point.x - this.m_lastX;
            }
            if (this.m_isPinYmove) {
                n4 = 0;
                rectangle2.y = this.m_treeBox.y;
                rectangle2.height = this.m_treeBox.height;
            } else {
                n4 = point.y - this.m_lastY;
            }
            if (this.m_upperNode == null) {
                this.m_changeNode = null;
                if (!this.m_treeAt.getTree().isUnrooted()) {
                    TreeShape treeShape = this.m_treeAnchor.getTreeShape();
                    Node node = this.m_treeAt.getTree().nodeAt(this.m_treeAt.at());
                    int n6 = node.getH() + treeShape.getBounds().x;
                    int n7 = node.getV() + treeShape.getBounds().y;
                    if (this.m_treeAt.getTree().isVertical()) {
                        n6 = point.x;
                    } else {
                        n7 = point.y;
                    }
                    n3 = n6 - this.m_lastX;
                    n4 = n7 - this.m_lastY;
                    n = n6;
                    n2 = n7;
                }
            } else {
                TreeShape treeShape = this.m_treeAnchor.getTreeShape();
                int n8 = this.m_upperNode.getH() + treeShape.getBounds().x;
                int n9 = this.m_upperNode.getV() + treeShape.getBounds().y;
                Node node = this.m_treeAt.getTree().nodeAt(this.m_treeAt.at());
                int n10 = node.getH() + treeShape.getBounds().x;
                int n11 = node.getV() + treeShape.getBounds().y;
                if (this.m_treeAt.getTree().isUnrooted()) {
                    double d = Math.sqrt((n10 - n8) * (n10 - n8) + (n11 - n9) * (n11 - n9));
                    double d2 = Math.atan2(n2 - n9, n - n8);
                    double d3 = Math.round(Math.toDegrees(d2));
                    double d4 = d * Math.cos(d2);
                    double d5 = d * Math.sin(d2);
                    n10 = n8 + (int)d4;
                    n11 = n9 + (int)d5;
                    Graphics graphics = this.getGraphics();
                    graphics.setXORMode(this.getBackground());
                    graphics.setColor(Color.gray);
                    graphics.drawLine(n8, n9, n10, n11);
                    graphics.setPaintMode();
                    n3 = n10 - this.m_lastX;
                    n4 = n11 - this.m_lastY;
                } else {
                    int n12 = this.m_dragNode.getH() + treeShape.getBounds().x;
                    int n13 = this.m_dragNode.getV() + treeShape.getBounds().y;
                    if (this.m_treeAt.getTree().isVertical()) {
                        n10 = point.x;
                        if (this.m_childList.size() == 2) {
                            Object object;
                            this.m_changeNode = Math.abs(n12 - n10) > 30 ? ((object = (Node)this.m_childList.get(0)) == this.m_dragNode ? (Node)this.m_childList.get(1) : object) : null;
                            if (this.m_changeNode != null) {
                                int n14 = this.m_changeNode.getH() + treeShape.getBounds().x;
                                int n15 = this.m_changeNode.getV() + treeShape.getBounds().y;
                                Graphics graphics = this.getGraphics();
                                graphics.setColor(Color.red);
                                graphics.drawLine(n8, n9, n14, n9);
                                graphics.drawLine(n14, n9, n14, n11);
                                graphics.setPaintMode();
                                n10 = n14;
                            } else {
                                object = this.getGraphics();
                                ((Graphics)object).setColor(Color.red);
                                ((Graphics)object).drawLine(n12, n13, n10, n11);
                                ((Graphics)object).setPaintMode();
                            }
                        } else {
                            this.m_changeNode = Math.abs(n12 - n10) > 30 ? this.findChildNode(n10, n11) : null;
                            if (this.m_changeNode != null) {
                                int n16 = this.m_changeNode.getH() + treeShape.getBounds().x;
                                int n17 = this.m_changeNode.getV() + treeShape.getBounds().y;
                                Graphics graphics = this.getGraphics();
                                graphics.setColor(Color.red);
                                graphics.drawLine(n8, n9, n16, n9);
                                graphics.drawLine(n16, n9, n16, n11);
                                graphics.setPaintMode();
                                n10 = n16;
                            } else {
                                Graphics graphics = this.getGraphics();
                                graphics.setXORMode(this.getBackground());
                                graphics.setColor(Color.red);
                                graphics.drawLine(n12 - 30, n13, n12 + 30, n11);
                                graphics.setPaintMode();
                                if (n10 < n12 - 30) {
                                    n10 = n12 - 30;
                                } else if (n12 + 30 < n10) {
                                    n10 = n12 + 30;
                                }
                            }
                        }
                    } else {
                        n11 = point.y;
                        if (this.m_childList.size() == 2) {
                            Object object;
                            this.m_changeNode = Math.abs(n13 - n11) > 30 ? ((object = (Node)this.m_childList.get(0)) == this.m_dragNode ? (Node)this.m_childList.get(1) : object) : null;
                            if (this.m_changeNode != null) {
                                int n18 = this.m_changeNode.getH() + treeShape.getBounds().x;
                                int n19 = this.m_changeNode.getV() + treeShape.getBounds().y;
                                Graphics graphics = this.getGraphics();
                                graphics.setColor(Color.red);
                                graphics.drawLine(n8, n9, n8, n19);
                                graphics.drawLine(n8, n19, n10, n19);
                                graphics.setPaintMode();
                                n11 = n19;
                            } else {
                                object = this.getGraphics();
                                ((Graphics)object).setColor(Color.red);
                                ((Graphics)object).drawLine(n12, n13, n10, n11);
                                ((Graphics)object).setPaintMode();
                            }
                        } else {
                            this.m_changeNode = Math.abs(n13 - n11) > 30 ? this.findChildNode(n10, n11) : null;
                            if (this.m_changeNode != null) {
                                int n20 = this.m_changeNode.getH() + treeShape.getBounds().x;
                                int n21 = this.m_changeNode.getV() + treeShape.getBounds().y;
                                Graphics graphics = this.getGraphics();
                                graphics.setColor(Color.red);
                                graphics.drawLine(n8, n9, n8, n21);
                                graphics.drawLine(n8, n21, n10, n21);
                                graphics.setPaintMode();
                                n11 = n21;
                            } else {
                                Graphics graphics = this.getGraphics();
                                graphics.setXORMode(this.getBackground());
                                graphics.setColor(Color.red);
                                graphics.drawLine(n12, n13 - 30, n10, n13 + 30);
                                graphics.setPaintMode();
                                if (n11 < n13 - 30) {
                                    n11 = n13 - 30;
                                } else if (n13 + 30 < n11) {
                                    n11 = n13 + 30;
                                }
                            }
                        }
                    }
                    n3 = n10 - this.m_lastX;
                    n4 = n11 - this.m_lastY;
                }
                n = n10;
                n2 = n11;
            }
            this.moveShape(this.m_nodeShape, n3, n4, true, this.m_isOutlineShown, false);
        } else if (this.m_selectedShape != null && (Math.abs(n3) > 1 || Math.abs(n4) > 1)) {
            java.awt.Rectangle rectangle = this.m_selectedShape.getBounds();
            if (this.m_selectedShape instanceof ScaleShape) {
                java.awt.Rectangle rectangle3 = new java.awt.Rectangle(rectangle.width, rectangle.width, this.getSize().width - rectangle.width * 2, this.getSize().height - rectangle.height * 2);
                Point point = dgGraphics.pinRect(rectangle3, mouseEvent.getPoint());
                n = point.x;
                n2 = point.y;
                n3 = n - this.m_lastX;
                n4 = n2 - this.m_lastY;
                this.moveShape(this.m_selectedShape, n3, n4, true, this.m_isOutlineShown, false);
            } else if (this.m_selectedShape instanceof TextShape) {
                java.awt.Rectangle rectangle4 = new java.awt.Rectangle(0, 0, this.getSize().width, this.getSize().height);
                Point point = dgGraphics.pinRect(rectangle4, mouseEvent.getPoint());
                n = point.x;
                n2 = point.y;
                n3 = n - this.m_lastX;
                n4 = n2 - this.m_lastY;
                this.moveShape(this.m_selectedShape, n3, n4, true, this.m_isOutlineShown, false);
            } else if (this.m_selectedShape instanceof TreeShape || this.m_selectedShape instanceof NodeLabel) {
                // empty if block
            }
        }
        this.m_lastX = n;
        this.m_lastY = n2;
    }

    private Node findChildNode(int n, int n2) {
        boolean bl = false;
        Node node = null;
        TreeShape treeShape = this.m_treeAnchor.getTreeShape();
        Iterator iterator = this.m_childList.iterator();
        java.awt.Rectangle rectangle = new java.awt.Rectangle(0, 0, 10, 10);
        if (this.m_treeAt.getTree().isVertical()) {
            while (iterator.hasNext()) {
                node = (Node)iterator.next();
                if (node == this.m_dragNode) continue;
                rectangle.x = node.getH() - 5 + treeShape.getBounds().x;
                rectangle.y = n2;
                bl = rectangle.contains(n, n2);
                if (!bl) continue;
                break;
            }
        } else {
            while (iterator.hasNext()) {
                node = (Node)iterator.next();
                if (node == this.m_dragNode) continue;
                rectangle.x = n;
                rectangle.y = node.getV() - 5 + treeShape.getBounds().y;
                bl = rectangle.contains(n, n2);
                if (!bl) continue;
            }
        }
        rectangle = null;
        if (bl) {
            return node;
        }
        return null;
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.m_frame != null) {
            ShapeImpl shapeImpl = this.m_shapes.shapeAt(mouseEvent.getX(), mouseEvent.getY());
            if (this.isOnShape(mouseEvent, shapeImpl)) {
                this.m_frame.setCursor(this.m_curCursor);
            } else {
                this.m_frame.setCursor(this.m_defaultCursor);
            }
        }
    }

    protected boolean baseClick(MouseEvent mouseEvent, ShapeImpl shapeImpl) {
        if (shapeImpl != null) {
            Object object;
            Object object2;
            Point point = new Point();
            if (shapeImpl instanceof TreeShape) {
                point.x = mouseEvent.getPoint().x;
                point.y = mouseEvent.getPoint().y;
            } else if (shapeImpl instanceof NodeLabel) {
                object2 = ((NodeLabel)shapeImpl).getNode();
                object = this.m_tree.getDrawer().getBounds();
                int n = mouseEvent.getPoint().x - ((java.awt.Rectangle)object).x;
                int n2 = mouseEvent.getPoint().y - ((java.awt.Rectangle)object).y;
                point.x = (int)((Node)object2).getX();
                point.y = this.m_image.getHeight() - (int)((Node)object2).getY();
            }
            object2 = new TreeAt();
            object = new IsTreeNodeAt(point, (TreeAt)object2);
            shapeImpl = this.m_shapes.firstShapeThat((IsShapeImpl)object);
            if (shapeImpl != null) {
                Node node = ((TreeAt)object2).getTree().nodeAt(((TreeAt)object2).at());
                if (node.getBack() == null) {
                    if (((TreeAt)object2).getTree().isUnrooted()) {
                        shapeImpl = null;
                    } else {
                        this.m_treeAt = object2;
                        ((TreeAt)object2).getTreeShape().setGraphics(this.getGraphics());
                        ((TreeAt)object2).getTreeShape().selectNode(((TreeAt)object2).at(), true);
                        this.m_upperNode = null;
                        this.m_dragNode = this.m_treeAt.getTree().nodeAt(this.m_treeAt.at());
                    }
                } else {
                    this.m_upperNode = ((TreeAt)object2).getTree().findUpper(node);
                    this.m_treeAt = object2;
                    ((TreeAt)object2).getTreeShape().setGraphics(this.getGraphics());
                    ((TreeAt)object2).getTreeShape().selectNode(((TreeAt)object2).at(), true);
                    this.m_childList = this.getChildList(this.m_upperNode, node);
                    this.m_dragNode = this.m_treeAt.getTree().nodeAt(this.m_treeAt.at());
                }
            }
        }
        return shapeImpl != null;
    }

    private ArrayList getChildList(Node node, Node node2) {
        ArrayList arrayList = new ArrayList();
        this.getChildList(node, node, node2, arrayList);
        if (arrayList.isEmpty()) {
            return null;
        }
        for (Node node3 : arrayList) {
            Node node4 = this.m_treeAt.getTree().findUpper(node3);
        }
        return arrayList;
    }

    private void getChildList(Node node, Node node2, Node node3, ArrayList arrayList) {
        Node node4;
        if (node == null || node2 == node3) {
            return;
        }
        if (this.m_upperNode != null && node.getOrder() != this.m_upperNode.getOrder() && this.m_upperNode == (node4 = this.m_treeAt.getTree().findUpper(node))) {
            arrayList.add(node);
        }
        if (!node.isTip()) {
            for (node4 = node.getNext(); node4 != null && node4 != node; node4 = node4.getNext()) {
                this.getChildList(node4.getBack(), node, node3, arrayList);
            }
        }
    }

    protected boolean isOnShape(MouseEvent mouseEvent, ShapeImpl shapeImpl) {
        if (shapeImpl != null && shapeImpl instanceof TreeShape) {
            Node node;
            TreeAt treeAt = new TreeAt();
            IsTreeNodeAt isTreeNodeAt = new IsTreeNodeAt(mouseEvent.getPoint(), treeAt);
            shapeImpl = this.m_shapes.firstShapeThat(isTreeNodeAt);
            if (shapeImpl != null && (node = treeAt.getTree().nodeAt(treeAt.at())).getBack() == null && treeAt.getTree().isUnrooted()) {
                shapeImpl = null;
            }
        }
        return shapeImpl != null;
    }

    protected void startMoveNode(boolean bl) {
        this.m_isPinYmove = false;
        this.m_isPinXmove = false;
        Node node = this.m_treeAt.getTree().nodeAt(this.m_treeAt.at());
        this.m_treeBox = this.m_treeAt.getTreeShape().getBounds();
        java.awt.Rectangle rectangle = new java.awt.Rectangle(this.m_treeBox.x, this.m_treeBox.y, 1, 1);
        this.m_treeBox.grow(1, 1);
        if (bl || this.m_treeAt.getTree().isUnrooted()) {
            rectangle.translate(node.getH(), node.getV());
            rectangle.grow(4, 8);
            this.m_nodeShape = new BaseShape(rectangle);
            this.moveShape(this.m_nodeShape, 0, 0, true, this.m_isOutlineShown, false);
        } else if (!this.m_treeAt.getTree().isUnrooted()) {
            rectangle.translate(node.getH(), node.getV());
            rectangle.grow(4, 8);
            this.m_nodeShape = new BaseShape(rectangle);
            this.moveShape(this.m_nodeShape, 0, 0, true, this.m_isOutlineShown, false);
        }
    }

    protected final void moveShape(ShapeImpl shapeImpl, Point point, boolean bl, boolean bl2, boolean bl3) {
        this.moveShape(shapeImpl, point.x, point.y, bl, bl2, bl3);
    }

    protected void moveShape(ShapeImpl shapeImpl, int n, int n2, boolean bl, boolean bl2, boolean bl3) {
        if (shapeImpl != null && !shapeImpl.isLocked()) {
            Graphics graphics = this.getGraphics();
            graphics.setXORMode(this.getBackground());
            shapeImpl.setGraphics(graphics);
            if (bl2) {
                if (this.m_isFillShown) {
                    shapeImpl.draw();
                } else {
                    shapeImpl.drawOutline();
                }
                this.m_isOutlineShown = false;
                this.m_isFillShown = false;
            }
            if (bl) {
                this.m_isFillShown = bl3;
                if (n != 0 || n2 != 0) {
                    shapeImpl.translate(n, n2);
                }
                if (this.m_isFillShown) {
                    shapeImpl.draw();
                } else {
                    shapeImpl.drawOutline();
                }
                this.m_isOutlineShown = true;
            }
            graphics.setPaintMode();
        }
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        double d = pageFormat.getImageableWidth() / (double)this.m_image.getWidth();
        double d2 = pageFormat.getImageableHeight() / (double)this.m_image.getHeight();
        double d3 = (pageFormat.getWidth() - pageFormat.getImageableWidth()) / 2.0;
        double d4 = (pageFormat.getHeight() - pageFormat.getImageableHeight()) / 2.0;
        if (d < 1.0 || d2 < 1.0) {
            this.m_isMagnify = true;
        }
        this.m_magX = d < 1.0 ? d : 1.0;
        this.m_magY = d2 < 1.0 ? d2 : 1.0;
        graphics.drawImage(this.m_image, (int)d3, (int)d4, (int)pageFormat.getImageableWidth(), (int)pageFormat.getImageableHeight(), null);
        this.m_isMagnify = false;
        return 0;
    }

    public void print(PageFormat pageFormat) throws Exception {
        Book book = new Book();
        book.append(this, pageFormat, 1);
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        printerJob.setPageable(book);
        printerJob.print();
    }

    public void writePdf(String string, PageFormat pageFormat) throws Exception {
        this.m_pdfImage = new BufferedImage((int)pageFormat.getWidth(), (int)pageFormat.getHeight(), 1);
        this.m_pdfG = this.m_pdfImage.getGraphics();
        try {
            double d = pageFormat.getWidth() / (double)this.m_image.getWidth();
            double d2 = pageFormat.getHeight() / (double)this.m_image.getHeight();
            if (d < 1.0 || d2 < 1.0) {
                this.m_isMagnify = true;
            }
            this.m_magX = d < 1.0 ? d : 1.0;
            this.m_magY = d2 < 1.0 ? d2 : 1.0;
            Rectangle rectangle = new Rectangle(0.0f, 0.0f, (float)pageFormat.getWidth(), (float)pageFormat.getHeight());
            Document document = new Document(rectangle, 0.0f, 0.0f, 0.0f, 0.0f);
            document.addTitle("");
            document.addAuthor("Phylogenetic Window " + CommonProcess.getVersion());
            PdfWriter pdfWriter = PdfWriter.getInstance(document, new FileOutputStream(string));
            document.open();
            PdfContentByte pdfContentByte = pdfWriter.getDirectContent();
            Graphics2D graphics2D = pdfContentByte.createGraphics((float)pageFormat.getWidth(), (float)pageFormat.getHeight());
            graphics2D.setFont(this.m_font);
            this.m_pdfG.setColor(Color.white);
            this.m_pdfG.fillRect(0, 0, (int)pageFormat.getWidth(), (int)pageFormat.getHeight());
            this.drawTree(graphics2D);
            document.close();
            this.m_pdfImage = null;
            this.m_pdfG = null;
            this.m_isMagnify = false;
        }
        catch (Exception exception) {
            this.m_pdfImage = null;
            this.m_pdfG = null;
            throw exception;
        }
    }
}

