/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.ptree.bean;

import cgdp.recog.ptree.bean.BaseShape;
import cgdp.recog.ptree.bean.CalcTree;
import cgdp.recog.ptree.bean.MoveNode;
import cgdp.recog.ptree.bean.Node;
import cgdp.recog.ptree.bean.NodeLabel;
import cgdp.recog.ptree.bean.NodeStyle;
import cgdp.recog.ptree.bean.NodeVector;
import cgdp.recog.ptree.bean.Plotter;
import cgdp.recog.ptree.bean.ScaleShape;
import cgdp.recog.ptree.bean.TextShape;
import cgdp.recog.ptree.bean.TextStyle;
import cgdp.recog.ptree.bean.Tree;
import cgdp.recog.ptree.bean.TreeStyles;
import cgdp.recog.ptree.bean.dgGraphics;
import cgdp.recog.ptree.bean.interfaces.NodeStyleImpl;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Vector;

public class TreeShape
extends BaseShape
implements NodeStyleImpl {
    public static int OFF_X = 50;
    public static int OFF_Y = 50;
    protected Tree m_tree;
    protected Node m_root;
    protected NodeVector m_nodes;
    protected TreeStyles m_treeStyles;
    protected TextStyle m_ncStyle;
    protected Vector m_textStyles;
    protected Plotter m_plotter;
    protected int m_lastSt;
    protected int m_nodeNum;
    protected int m_cWide;
    protected int m_cHigh;
    protected int m_cDescent;
    protected int m_minDepth;
    protected int m_maxDepth;
    protected boolean m_isNeedToLocate = true;
    protected boolean m_isNeedVisible = true;
    protected double m_rooty;
    protected Component m_comp;
    protected CalcTree m_calc;
    protected Rectangle m_visibleRect;
    protected ScaleShape m_scalebar;
    protected int m_boxWidth = 5;
    protected NumberFormat m_decform;
    double x1;
    double x2;
    double y1;
    double y2;
    protected MoveNode m_moveNode;

    public TreeShape(Component component, Tree tree, CalcTree calcTree) {
        super(component.getBounds());
        this.m_comp = component;
        this.setGraphics(component.getGraphics());
        this.m_calc = calcTree;
        this.m_tree = tree;
        this.m_textStyles = this.m_tree.getTextStyles();
        this.m_treeStyles = this.m_tree.getStyles();
        this.m_nodes = this.m_tree.getNodes();
        this.m_g = component.getGraphics();
        this.m_plotter = new Plotter(this.m_g, this.m_dg);
        this.m_ncStyle = new TextStyle();
        this.m_decform = new DecimalFormat();
        this.m_decform.setMaximumFractionDigits(5);
        this.move(this.m_rect.x + OFF_X, this.m_rect.y + OFF_Y);
        this.setShapeRect();
    }

    @Override
    public Object clone() {
        TreeShape treeShape = (TreeShape)super.clone();
        treeShape.setTree((Tree)this.m_tree.clone());
        treeShape.getTree().setDrawer(treeShape);
        treeShape.setTextStyles(treeShape.getTree().getTextStyles());
        treeShape.setTreeStyles(treeShape.getTree().getStyles());
        treeShape.setNodes(treeShape.m_tree.getNodes());
        treeShape.setRoot(treeShape.m_tree.getRoot());
        treeShape.setNcStyle((TextStyle)this.m_ncStyle.clone());
        treeShape.setTreeStyles(new TreeStyles(this.m_treeStyles));
        treeShape.setGraphics(new dgGraphics(this.m_g));
        treeShape.setPlotter(new Plotter(treeShape.getGraphics(), treeShape.getDgGraphics()));
        CalcTree calcTree = new CalcTree(treeShape.m_tree, this.m_comp);
        calcTree.doCalc();
        treeShape.setCalcTree(calcTree);
        return treeShape;
    }

    public Graphics getGraphics() {
        return this.m_g;
    }

    public dgGraphics getDgGraphics() {
        return this.m_dg;
    }

    public final Tree getTree() {
        return this.m_tree;
    }

    public final void setTree(Tree tree) {
        this.m_tree = tree;
    }

    public void setTextStyles(Vector vector) {
        this.m_textStyles = vector;
    }

    public void setTreeStyles(TreeStyles treeStyles) {
        this.m_treeStyles = treeStyles;
    }

    public void setNodes(NodeVector nodeVector) {
        this.m_nodes = nodeVector;
    }

    public void setRoot(Node node) {
        this.m_root = node;
    }

    public void setNcStyle(TextStyle textStyle) {
        this.m_ncStyle = textStyle;
    }

    public void setPlotter(Plotter plotter) {
        this.m_plotter = plotter;
    }

    public void setCalcTree(CalcTree calcTree) {
        this.m_calc = calcTree;
    }

    public void setScalebar(ScaleShape scaleShape) {
        this.m_scalebar = scaleShape;
    }

    @Override
    public final NodeStyle getNodeStyle() {
        return this.m_tree.getNodeStyle();
    }

    public void recalcTree() {
        this.m_tree.clear();
        this.m_calc.doCalc();
        this.setShapeRect();
    }

    public void rescaleTree() {
        this.m_calc.doScale();
        this.setShapeRect();
    }

    @Override
    public boolean contains(int n, int n2) {
        return this.m_rect.contains(n, n2);
    }

    @Override
    public void setBounds(int n, int n2, int n3, int n4) {
        boolean bl = this.m_rect.width != n3 || this.m_rect.height != n4;
        super.setBounds(n, n2, n3, n4);
        if (bl) {
            this.recalcTree();
        }
    }

    @Override
    public void updateBounds() {
        super.updateBounds();
        if (this.m_oldRect != null) {
            this.m_tree.moveShapes(this.m_oldRect, this.getBounds());
        }
    }

    protected void plot(Node node, boolean bl, double d, double d2) {
        Point point = this.m_dg.map2port(d, d2);
        if (bl) {
            this.m_dg.lineto(point);
        } else {
            this.m_dg.moveto(point);
        }
    }

    protected void drawNodes(Node node, Node node2) {
        Cloneable cloneable;
        if (node == null || !this.m_tree.isVisible(node)) {
            return;
        }
        if (this.m_visibleRect != null && node.isHideTree()) {
            return;
        }
        boolean bl = true;
        if (this.m_visibleRect != null) {
            cloneable = new Rectangle(node.getH(), node.getV());
            if (node2 != null) {
                cloneable = ((Rectangle)cloneable).union(new Rectangle(node2.getH(), node2.getV()));
            }
            if (!node.isTip() && node.getNext() != null) {
                Node node3 = node.getNext();
                cloneable = ((Rectangle)cloneable).union(new Rectangle(node3.getH(), node3.getV()));
            }
            ((Rectangle)cloneable).grow(25, 25);
            bl = ((Rectangle)cloneable).intersects(this.m_visibleRect);
        }
        if (bl) {
            this.x2 = node.getX();
            this.y2 = node.getY();
            this.setStyle(node);
            if (!this.m_color.equals(this.m_ncStyle.getColor())) {
                this.m_g.setColor(this.m_ncStyle.getColor());
            }
            if (!node.equals(this.m_root)) {
                if (node2 == null) {
                    this.x1 = this.x2;
                    this.y1 = this.y2;
                } else {
                    this.x1 = node2.getX();
                    this.y1 = node2.getY();
                }
                this.plot(node2, false, this.x1, this.y1);
                switch (this.m_treeStyles.getStyle()) {
                    case 0: {
                        this.plot(null, true, this.x2, this.y1);
                        this.plot(node, true, this.x2, this.y2);
                        break;
                    }
                    case 1: {
                        this.plot(null, true, this.x1, this.y2);
                        this.plot(node, true, this.x2, this.y2);
                        break;
                    }
                    case 2: {
                        this.plot(node, true, this.x2, this.y2);
                    }
                }
                this.drawNode(node);
                this.drawNodeLength(node, this.x1, this.y1, this.x2, this.y2);
            } else if (!this.m_tree.isUnrooted()) {
                if (this.m_treeStyles.isVertical()) {
                    this.x1 = node.getX();
                    this.y1 = this.m_rooty;
                } else {
                    this.x1 = this.m_rooty;
                    this.y1 = node.getY();
                }
                this.plot(node2, false, this.x1, this.y1);
                this.plot(node, true, this.x2, this.y2);
                this.drawNode(node);
                this.drawNodeLength(node, this.x1, this.y1, this.x2, this.y2);
            }
            if (!this.m_color.equals(this.m_ncStyle.getColor())) {
                this.m_g.setColor(this.m_color);
            }
            if (!node.isTip()) {
                for (cloneable = node.getNext(); cloneable != null && cloneable != node; cloneable = ((Node)cloneable).getNext()) {
                    this.drawNodes(((Node)cloneable).getBack(), node);
                }
            }
        }
    }

    protected void setStyle(Node node) {
        if (this.m_lastSt != node.getNodeStyle().getTextStyle()) {
            this.m_lastSt = node.getNodeStyle().getTextStyle();
            if (0 < this.m_textStyles.size()) {
                this.m_ncStyle = (TextStyle)this.m_textStyles.elementAt(this.m_lastSt);
            }
            this.m_g.setFont(this.m_ncStyle.getFont());
            FontMetrics fontMetrics = this.m_g.getFontMetrics();
            this.m_cWide = (fontMetrics.charWidth('G') + 2) / 2;
            this.m_cHigh = fontMetrics.getAscent() / 2;
            this.m_cDescent = fontMetrics.getDescent();
            this.m_boxWidth = Math.max(fontMetrics.getMaxAdvance(), fontMetrics.getHeight()) / 2;
            node.setStringWidths(fontMetrics);
        } else if (node.isNeedStringWidths()) {
            node.setStringWidths(this.m_g.getFontMetrics());
        }
    }

    protected final void drawLabel(String string, int n, double d, double d2) {
        this.drawLabel(string, n, d, d2, 0, 0);
    }

    protected void drawLabel(String string, int n, double d, double d2, int n2, int n3) {
        Point point = this.m_dg.map2port(d, d2);
        if (this.m_treeStyles.isVertical()) {
            point.x = n == 0 ? (point.x -= string.length() * this.m_cWide / 2) : (point.x -= n / 2);
        } else {
            point.y += this.m_cDescent;
            point.x += this.m_cWide;
        }
        point.x += n2;
        point.y += n3;
        this.m_dg.moveto(point);
        this.m_dg.drawString(string);
    }

    protected void drawLeafSymbol(Node node, Rectangle rectangle) {
        int n = 4;
        int n2 = rectangle.x + this.m_dg.offsetX() + rectangle.width / 2 + n / 2;
        int n3 = rectangle.y + this.m_dg.offsetY() + rectangle.height / 2 + n / 2;
        if (node.getNodeStyle().isDoCircle()) {
            if (node.getNodeStyle().isDoOutline()) {
                this.m_g.drawOval(n2, n3, rectangle.width - n, rectangle.height - n);
            } else {
                this.m_g.fillOval(n2, n3, rectangle.width - n, rectangle.height - n);
            }
        }
        if (node.getNodeStyle().isDoBox()) {
            if (node.getNodeStyle().isDoOutline()) {
                this.m_g.drawRect(n2, n3, rectangle.width - n, rectangle.height - n);
            } else {
                this.m_g.fillRect(n2, n3, rectangle.width - n, rectangle.height - n);
            }
        }
    }

    protected void drawNodeLength(Node node, double d, double d2, double d3, double d4) {
        if (node.getNodeStyle().isShowLength()) {
            double d5 = node.getUserLength();
            String string = this.m_decform.format(d5);
            if (!Node.isNoValue(node.getBootstrapValue())) {
                string = string + "[" + node.getBootstrapValue() + "]";
            }
            d = (d + d3) / 2.0 + 10.0;
            d2 = this.m_tree.isUnrooted() ? (d2 + d4) / 2.0 : d4 + (double)this.m_dg.getGraphics().getFontMetrics().getHeight() / 2.0;
            Point point = this.m_dg.map2port(d, d2);
            point.x -= string.length() * this.m_cWide / 2;
            if (this.m_treeStyles.isVertical()) {
                point.y += this.m_cDescent;
            }
            this.m_dg.moveto(point);
            this.m_dg.drawString(string);
        }
    }

    protected void drawNode(Node node) {
        this.setStyle(node);
        this.m_dg.moveto(node.getH(), node.getV());
        Rectangle rectangle = new Rectangle(node.getH() - this.m_boxWidth, node.getV() - this.m_boxWidth, this.m_boxWidth, this.m_boxWidth + 1);
        if (!node.getNodeStyle().isNoLabel()) {
            boolean bl = false;
            if (node.isMoved() && node.getTextShape() instanceof TextShape) {
                TextShape textShape = node.getTextShape();
                textShape.setGraphics(this.m_g);
                textShape.drawShape();
            } else if (node.getLabel() instanceof NodeLabel) {
                NodeLabel nodeLabel = node.getLabel();
                String string = nodeLabel.getText();
                this.drawLabel(string, 0, node.getX(), node.getY());
                nodeLabel.setGraphics(this.m_g);
                nodeLabel.move(this.m_dg.atX() + this.m_dg.offsetX(), this.m_dg.atY() + this.m_dg.offsetY() - this.m_cHigh);
                Rectangle rectangle2 = nodeLabel.getBounds();
                rectangle2.y -= this.m_cHigh;
                TextShape textShape = node.getTextShape();
                textShape.setBounds(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                textShape.setGraphics(this.m_g);
                textShape.setExtent();
                textShape.drawShape();
            } else if (node.getLabel() != null) {
                node.getLabel().setGraphics(this.m_g);
                node.getLabel().drawShape();
            } else if (this.m_treeStyles.isPlotNodeNum()) {
                ++this.m_nodeNum;
                int n = this.m_nodeNum;
                this.drawLabel(Integer.toString(n), 0, node.getX(), node.getY());
            }
        }
        this.drawLeafSymbol(node, rectangle);
        this.m_dg.moveto(node.getH(), node.getV());
    }

    public void highlightNodes(boolean bl, boolean bl2) {
        int n = this.m_nodes.size();
        for (int i = 0; i < n; ++i) {
            Node node = this.m_nodes.nodeAt(i);
            if (!node.isSelect()) continue;
            this.nodeOnOff(i, bl, bl2);
        }
    }

    public final void deselect() {
        this.selectAll(0);
    }

    public final void selectAll() {
        this.selectAll(1);
    }

    public void selectAll(int n) {
        boolean bl = false;
        boolean bl2 = true;
        switch (n) {
            case 0: {
                bl = true;
                bl2 = false;
                break;
            }
            case 1: {
                bl = false;
                bl2 = true;
                break;
            }
            case -1: {
                bl = false;
                bl2 = true;
            }
        }
        int n2 = this.m_nodes.size();
        for (int i = 0; i < n2; ++i) {
            Node node = this.m_nodes.nodeAt(i);
            if (n == -1) {
                bl = node.isSelect();
                boolean bl3 = bl2 = !node.isSelect();
            }
            if (node.isSelect() != bl) continue;
            this.nodeOnOff(i, bl, bl2);
            node.setSelect(bl2);
        }
    }

    public void selectLeafs() {
        int n = this.m_nodes.size();
        for (int i = 0; i < n; ++i) {
            Node node = this.m_nodes.nodeAt(i);
            if (!node.isTip() || node.isSelect()) continue;
            this.nodeOnOff(i, false, true);
            node.setSelect(true);
        }
    }

    public void selectNode(int n, boolean bl) {
        Node node = this.m_nodes.nodeAt(n);
        if (!node.isSelect() && !bl) {
            this.deselect();
        }
        node.setSelect(!node.isSelect());
        if (node.isSelect()) {
            this.nodeOnOff(n, false, true);
        } else {
            this.nodeOnOff(n, true, false);
        }
    }

    @Override
    public void highlight(int n, int n2) {
        super.highlight(n, n2);
        this.highlightNodes(n != 0, n2 != 0);
    }

    protected void nodeOnOff(int n, boolean bl, boolean bl2) {
        Node node = this.m_nodes.nodeAt(n);
        Rectangle rectangle = new Rectangle(node.getH(), node.getV(), 1, 1);
        rectangle.grow(this.m_cWide, this.m_cHigh);
        this.highlightOnOff(rectangle, bl, bl2);
    }

    public boolean canMoveNode(int n, int n2) {
        if (n != n2) {
            Node node;
            Node node2;
            Node node3 = this.m_nodes.nodeAt(n);
            Node node4 = this.m_nodes.nodeAt(n2);
            if (node3 != null && node4 != null && (node2 = (node = node3.getBack())) != null) {
                while ((node2 = node2.getNext()) != null && node2 != node && node4 != node2.getBack()) {
                }
                if (node.getBack() == node3 && node2.getBack() == node4) {
                    this.m_moveNode = new MoveNode(node3, node4, node, node2);
                    return true;
                }
            }
        }
        return false;
    }

    public int findSwapNode(int n) {
        Node node = this.m_nodes.nodeAt(n);
        if (node == null) {
            return -1;
        }
        Node node2 = node.getBack();
        if (node2 == null) {
            return -1;
        }
        if (node2.getBack() != node) {
            return -1;
        }
        Node node3 = node2.getNext();
        if (node3 == null) {
            return -1;
        }
        Node node4 = node3.getBack();
        if (node4 == null) {
            return -1;
        }
        this.m_moveNode = new MoveNode(node, node4, node2, node3);
        return node4.getOrder();
    }

    public boolean moveNode(int n, int n2) {
        if (this.canMoveNode(n, n2)) {
            this.m_moveNode.getBackSource().setBack(this.m_moveNode.getTarget());
            this.m_moveNode.getTarget().setBack(this.m_moveNode.getBackSource());
            this.m_moveNode.getBackTarget().setBack(this.m_moveNode.getSource());
            this.m_moveNode.getSource().setBack(this.m_moveNode.getBackTarget());
            return true;
        }
        return false;
    }

    protected void relocate() {
        int n = this.m_nodes.size();
        for (int i = 0; i < n; ++i) {
            Node node = this.m_nodes.nodeAt(i);
            node.setHV(this.m_dg.map2port(node.getX(), node.getY()));
            node.setHideTree(false);
        }
        this.m_isNeedToLocate = false;
    }

    protected void locateVistree() {
        this.m_isNeedVisible = false;
        int n = this.m_nodes.size();
        for (int i = 0; i < n; ++i) {
            Node node = this.m_nodes.nodeAt(i);
            if (this.m_visibleRect != null) {
                if (!node.isTip() && node.getTipsAbove() == 0) {
                    node.setHideTree(false);
                    continue;
                }
                Rectangle rectangle = new Rectangle(node.getH(), node.getV(), 1, 1);
                rectangle.grow(25, 25);
                node.setHideTree(!rectangle.intersects(this.m_visibleRect));
                continue;
            }
            node.setHideTree(false);
        }
        this.locateVistreeWalk(this.m_root);
    }

    protected void locateVistreeWalk(Node node) {
        if (node != null) {
            for (Node node2 = node.getNext(); node2 != null && node2 != node; node2 = node2.getNext()) {
                this.locateVistreeWalk(node2.getBack());
            }
            if (node.isHideTree() && node.getChildren().size() > 0) {
                int n = node.getChildren().size();
                for (int i = 0; i < n; ++i) {
                    Node node3 = node.child(i);
                    if (node3.isHideTree()) continue;
                    node.setHideTree(false);
                    break;
                }
            }
        }
    }

    protected boolean checkVisibleSubtree(Node node) {
        if (this.m_visibleRect != null && (node.isTip() || node.getNext() != null && node.getNext().getBack() != null && node.getNext().getBack().isHideTree()) && (node.getH() != 0 || node.getV() != 0)) {
            Rectangle rectangle = new Rectangle(node.getH(), node.getV(), 1, 1);
            rectangle.grow(25, 25);
            boolean bl = !rectangle.intersects(this.m_visibleRect);
            node.setHideTree(!rectangle.intersects(this.m_visibleRect));
        } else {
            node.setHideTree(false);
        }
        return node.isHideTree();
    }

    @Override
    public void drawShape() {
        FontMetrics fontMetrics = this.m_g.getFontMetrics();
        this.m_cHigh = this.m_cWide = fontMetrics.charWidth('M') / 2;
        this.m_lastSt = -1;
        this.m_nodeNum = 0;
        if (this.m_isNeedToLocate) {
            this.relocate();
        }
        if (!this.m_tree.isShapesArePinned()) {
            this.m_tree.setShapeRects(this.m_plotter);
        }
        this.drawNodes(this.m_root, this.m_root);
    }

    public void redrawShape() {
        if (!this.m_tree.isShapesArePinned()) {
            this.m_tree.setShapeRects(this.m_plotter);
        }
        this.drawNodes(this.m_root, this.m_root);
    }

    protected void setShapeRect() {
        this.m_root = this.m_tree.getRoot();
        this.m_rooty = this.m_tree.getRooty();
        double d = this.m_tree.getTmax().x - this.m_tree.getTmin().x;
        double d2 = this.m_tree.getTmax().y - this.m_tree.getTmin().y;
        this.m_dg.setGrXmin(this.m_tree.getTmin().x);
        this.m_dg.setGrYmax(this.m_tree.getTmax().y);
        this.m_dg.setDrawScale(this.m_tree.getScale());
        this.m_minDepth = this.m_tree.getMinDepth();
        this.m_maxDepth = this.m_tree.getMaxDepth();
        if (this.m_scalebar != null) {
            this.m_scalebar.rescaleTree();
        }
        this.updateBounds();
        this.relocate();
        this.m_tree.setShapesArePinned(false);
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "[" + this.m_tree.toString() + ", " + super.toString() + "]";
    }
}

