/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.ptree.bean;

import cgdp.recog.ptree.bean.Const;
import cgdp.recog.ptree.bean.Utils;

public class TreeStyles {
    protected boolean m_isUseLengths;
    protected boolean m_isPlotNodeNum;
    protected boolean m_isVertical;
    protected boolean m_isNdScaley;
    protected boolean m_isNdScale;
    protected int m_style;
    protected int m_nodePosition;
    protected double m_labelRotation;
    protected double m_nodeSpace;
    protected double m_stemLength;
    protected double m_treeDepth;
    protected boolean m_isRegular;
    protected int m_labelDirec;
    protected double m_angle;
    protected double m_arc;

    public TreeStyles() {
        this.init();
    }

    public TreeStyles(TreeStyles treeStyles) {
        this.init();
        this.set(treeStyles);
    }

    protected void init() {
        this.m_style = Const.DEFAULT_TREE_STYLE;
        this.m_isUseLengths = true;
        this.m_isPlotNodeNum = false;
        this.m_isVertical = true;
        this.m_isNdScaley = true;
        this.m_isNdScale = false;
        this.m_nodePosition = 1;
        this.m_labelRotation = 0.0;
        this.m_nodeSpace = 3.0;
        this.m_stemLength = 0.05;
        this.m_treeDepth = 0.5263157894736842;
        this.m_isRegular = false;
        this.m_labelDirec = 3;
        this.m_angle = 1.5707963267948966;
        this.m_arc = Math.PI * 2;
    }

    public boolean isUseLengths() {
        return this.m_isUseLengths;
    }

    public boolean isPlotNodeNum() {
        return this.m_isPlotNodeNum;
    }

    public boolean isVertical() {
        return this.m_isVertical;
    }

    public boolean isNodeScaley() {
        return this.m_isNdScaley;
    }

    public boolean isNodeScale() {
        return this.m_isNdScale;
    }

    public int getStyle() {
        return this.m_style;
    }

    public int getNodePosition() {
        return this.m_nodePosition;
    }

    public double getLabelRotation() {
        return this.m_labelRotation;
    }

    public double getNodeSpace() {
        return this.m_nodeSpace;
    }

    public double getStemLength() {
        return this.m_stemLength;
    }

    public double getTreeDepth() {
        return this.m_treeDepth;
    }

    public boolean isRegular() {
        return this.m_isRegular;
    }

    public int getLabelDirec() {
        return this.m_labelDirec;
    }

    public double getAngle() {
        return this.m_angle;
    }

    public double getArc() {
        return this.m_arc;
    }

    public void setUseLengths(boolean bl) {
        this.m_isUseLengths = bl;
    }

    public void setPlotNodeNum(boolean bl) {
        this.m_isPlotNodeNum = bl;
    }

    public void setVertical(boolean bl) {
        this.m_isVertical = bl;
    }

    public void setNodeScaley(boolean bl) {
        this.m_isNdScaley = bl;
    }

    public void setNodeScale(boolean bl) {
        this.m_isNdScale = bl;
    }

    public void setStyle(int n) {
        this.m_style = n;
    }

    public void setNodePosition(int n) {
        this.m_nodePosition = n;
    }

    public void setLabelRotation(double d) {
        this.m_labelRotation = d;
    }

    public void setNodeSpace(double d) {
        this.m_nodeSpace = d;
    }

    public void setStemLength(double d) {
        this.m_stemLength = d;
    }

    public void setTreeDepth(double d) {
        this.m_treeDepth = d;
    }

    public void setRegular(boolean bl) {
        this.m_isRegular = bl;
    }

    public void setLabelDirec(int n) {
        this.m_labelDirec = n;
    }

    public void setAngle(double d) {
        this.m_angle = d;
    }

    public void setArc(double d) {
        this.m_arc = d;
    }

    public void set(TreeStyles treeStyles) {
        this.m_style = treeStyles.getStyle();
        this.m_isUseLengths = treeStyles.isUseLengths();
        this.m_isVertical = treeStyles.isVertical();
        this.m_isPlotNodeNum = treeStyles.isPlotNodeNum();
        this.m_nodeSpace = treeStyles.getNodeSpace();
        this.m_stemLength = treeStyles.getStemLength();
        this.m_treeDepth = treeStyles.getTreeDepth();
        this.m_isRegular = treeStyles.isRegular();
        this.m_labelDirec = treeStyles.getLabelDirec();
        this.m_angle = treeStyles.getAngle();
        this.m_arc = treeStyles.getArc();
        this.m_labelRotation = treeStyles.getLabelRotation();
    }

    public String toString() {
        return this.getClass().getName() + "[style=" + this.m_style + ",isUseLengths=" + this.m_isUseLengths + ",isVertical=" + this.m_isVertical + ",isRegular=" + this.m_isRegular + ",isPlotNodeNum=" + this.m_isPlotNodeNum + ",stemLength=" + this.m_stemLength + ",treeDepth=" + this.m_treeDepth + ",nodeSpace=" + this.m_nodeSpace + ",labelDirec=" + this.m_labelDirec + "]";
    }

    private final String val(String string, String string2) {
        int n;
        int n2 = string2.lastIndexOf(string);
        if (n2 < 0) {
            return "";
        }
        int n3 = string2.indexOf(61, n2);
        if (n3 < 0) {
            return "1";
        }
        int n4 = string2.length();
        for (n = ++n3; n < n4 && ", \t\n[]".indexOf(string2.charAt(n)) < 0; ++n) {
        }
        return string2.substring(n3, n);
    }

    final boolean isTrue(String string, boolean bl) {
        if (Utils.isNull(string)) {
            return bl;
        }
        return "1".equals(string) || "true".equalsIgnoreCase(string);
    }

    private final int getInt(String string, int n) {
        if (Utils.isNull(string)) {
            return n;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            return n;
        }
    }

    private final double getDouble(String string, double d) {
        if (Utils.isNull(string)) {
            return d;
        }
        try {
            return new Double(string);
        }
        catch (Exception exception) {
            return d;
        }
    }

    public void fromString(String string) {
        if (Utils.isNull(string)) {
            this.setStyle(this.getInt(this.val("style=", string), this.m_style));
            this.setUseLengths(this.isTrue(this.val("isUseLengths=", string), this.m_isUseLengths));
            this.setVertical(this.isTrue(this.val("isVertical=", string), this.m_isVertical));
            this.setRegular(this.isTrue(this.val("isRegular=", string), this.m_isRegular));
            this.setPlotNodeNum(this.isTrue(this.val("isPlotNodeNum=", string), this.m_isPlotNodeNum));
            this.setStemLength(this.getDouble(this.val("stemLength=", string), this.m_stemLength));
            this.setTreeDepth(this.getDouble(this.val("treedepth=", string), this.m_treeDepth));
            this.setNodeSpace(this.getDouble(this.val("nodespace=", string), this.m_nodeSpace));
            this.setNodePosition(this.getInt(this.val("nodePosition=", string), this.m_nodePosition));
            this.setLabelRotation(this.getDouble(this.val("labelRotation=", string), this.m_labelRotation));
            this.setLabelDirec(this.getInt(this.val("labeldirec=", string), this.m_labelDirec));
        }
    }
}

