/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.ptree.bean;

import java.awt.Component;
import java.awt.Point;
import java.net.URL;

public final class Utils {
    public static final double epsilon = 1.0E-5;
    public static final double missing = Double.MIN_VALUE;

    public static final double sqr(double d) {
        return d * d;
    }

    public static boolean isMissing(double d) {
        int n = Float.floatToIntBits(Float.MIN_VALUE);
        return Float.floatToIntBits((float)d) == n;
    }

    public static boolean isNull(String string) {
        return string == null || string.length() == 0;
    }

    public static Point localToGlobal(Component component, int n, int n2) {
        int n3 = n;
        int n4 = n2;
        while (component != null) {
            n3 += component.getLocation().x;
            n4 += component.getLocation().y;
            component = component.getParent();
        }
        return new Point(n3, n4);
    }

    public static final Point localToGlobal(Component component, Point point) {
        return Utils.localToGlobal(component, point.x, point.y);
    }

    public static Point globalToLocal(Component component, int n, int n2) {
        int n3 = n;
        int n4 = n2;
        while (component != null) {
            n3 -= component.getLocation().x;
            n4 -= component.getLocation().y;
            component = component.getParent();
        }
        return new Point(n3, n4);
    }

    public static final Point globalToLocal(Component component, Point point) {
        return Utils.globalToLocal(component, point.x, point.y);
    }

    public static URL getResource(String string, String string2) throws ClassNotFoundException {
        URL uRL = ClassLoader.getSystemResource(string2);
        if (uRL == null) {
            Class<?> clazz = Class.forName(string);
            uRL = clazz.getClassLoader().getResource(string2);
        }
        return uRL;
    }

    public static String getSuffix(String string) {
        if (Utils.isNull(string)) {
            return null;
        }
        int n = string.lastIndexOf(".");
        if (n > 0 && n < string.length() - 1) {
            return string.substring(n + 1);
        }
        return null;
    }
}

