/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.ptree.bean;

import cgdp.recog.ptree.bean.CommonProcess;
import cgdp.recog.ptree.bean.Utils;
import cgdp.recog.ptree.bean.interfaces.MediatorImpl;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.net.URL;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JWindow;

public class VersionWindow
extends JWindow {
    MediatorImpl m_mediatorImpl;
    Font m_font;
    JLabel m_label;

    public VersionWindow(MediatorImpl mediatorImpl) {
        Object object;
        this.m_mediatorImpl = mediatorImpl;
        this.clear();
        Box box = Box.createVerticalBox();
        this.getContentPane().add((Component)box, "Center");
        for (int i = 1; i <= 2; ++i) {
            try {
                object = this.m_mediatorImpl == null ? this.getToolkit().getImage(VersionWindow.getResource("jp.co.isb.project.ptree.startup.Startup", "images/ptree_logo" + i + ".png")) : this.getToolkit().getImage(Utils.getResource("jp.co.isb.project.ptree.startup.Startup", "images/ptree_logo" + i + ".png"));
            }
            catch (Exception exception) {
                object = new BufferedImage(400, 200, 1);
                Graphics graphics = ((BufferedImage)object).getGraphics();
                graphics.setColor(Color.white);
                graphics.fillRect(0, 0, 400, 200);
            }
            JLabel jLabel = new JLabel(new ImageIcon((Image)object));
            jLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    if (VersionWindow.this.m_mediatorImpl != null) {
                        VersionWindow.this.m_mediatorImpl.closeVersionWindow();
                    } else {
                        VersionWindow.this.dispose();
                    }
                }
            });
            box.add(jLabel);
            if (i != 1) continue;
            this.m_label = jLabel;
        }
        this.pack();
        Dimension dimension = this.getToolkit().getScreenSize();
        object = this.getPreferredSize();
        this.setLocation(dimension.width / 2 - ((Dimension)object).width / 2, dimension.height / 2 - ((Dimension)object).height / 2);
        this.setVisible(true);
    }

    private void clear() {
        this.m_font = new Font("Monospaced", 0, 16);
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        graphics.setFont(this.m_font);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = this.m_label.getSize().height - 1;
        String string = "version" + CommonProcess.getVersion();
        int n2 = this.getSize().width - fontMetrics.stringWidth(string) - 10;
        graphics.drawString(string, n2, n);
        string = CommonProcess.getPtreeTitle();
        n2 = this.getSize().width - fontMetrics.stringWidth(string) - 10;
        graphics.drawString(string, n2, n -= fontMetrics.getHeight());
    }

    private static URL getResource(String string, String string2) throws ClassNotFoundException {
        URL uRL = ClassLoader.getSystemResource(string2);
        if (uRL == null) {
            Class<?> clazz = Class.forName(string);
            uRL = clazz.getClassLoader().getResource(string2);
        }
        return uRL;
    }
}

