/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.ptree.bean.data;

import cgdp.recog.ptree.bean.CommonProcess;
import cgdp.recog.ptree.bean.Const;
import cgdp.recog.ptree.bean.Utils;
import cgdp.recog.ptree.bean.data.OptionValues;
import java.awt.Font;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.StringTokenizer;

public class OptionTbl {
    String m_header;
    String m_optionDat;
    OptionValues m_optionValues;
    Font m_font;
    private static final String OPTION_VALUES = "OPTION VALUES:";
    private static final String MAIN_WINDOW_X = "mainWindowX";
    private static final String MAIN_WINDOW_Y = "mainWindowY";
    private static final String MAIN_WINDOW_W = "mainWindowW";
    private static final String MAIN_WINDOW_H = "mainWindowH";
    private static final String DND_OPEN_DIR = "dndOpenDir";
    private static final String PDF_SAVE_DIR = "pdfSaveDir";
    private static final String TREE_STYLE = "treeStyle";
    private static final String SHOW_LENGTH = "showLength";
    private static final String NODE_SYMBOL = "nodeSymbol";
    private static final String FONT_TYPE = "fontType";
    private static final String COLOR_TYPE = "colorType";
    private static final String IN_GROUP_COLOR = "inGroupColor";
    private static final String OUT_GROUP_COLOR = "outGroupColor";

    public OptionTbl() {
        this(null);
    }

    public OptionTbl(String string) {
        this.clear();
        if (!Utils.isNull(string)) {
            this.m_optionDat = string;
        }
        try {
            this.readOption();
            this.createFont();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void clear() {
        this.m_header = "# " + CommonProcess.getPtreeTitle();
        this.m_optionDat = Const.OPTION_DAT;
        this.m_optionValues = new OptionValues();
        this.m_font = new Font("Monospaced", 0, 14);
    }

    private void readOptionValues() throws IOException {
        String string;
        this.m_optionValues = new OptionValues();
        FileInputStream fileInputStream = new FileInputStream(this.m_optionDat);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
        while ((string = bufferedReader.readLine()) != null) {
            if (!string.equals(OPTION_VALUES)) continue;
            while ((string = bufferedReader.readLine()) != null && !Utils.isNull(string)) {
                String string2;
                StringTokenizer stringTokenizer = new StringTokenizer(string, "=");
                String string3 = stringTokenizer.nextToken();
                String string4 = string2 = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : "";
                if (string3.equals(MAIN_WINDOW_X)) {
                    this.m_optionValues.setMainWindowX(Integer.parseInt(string2));
                    continue;
                }
                if (string3.equals(MAIN_WINDOW_Y)) {
                    this.m_optionValues.setMainWindowY(Integer.parseInt(string2));
                    continue;
                }
                if (string3.equals(MAIN_WINDOW_W)) {
                    this.m_optionValues.setMainWindowW(Integer.parseInt(string2));
                    continue;
                }
                if (string3.equals(MAIN_WINDOW_H)) {
                    this.m_optionValues.setMainWindowH(Integer.parseInt(string2));
                    continue;
                }
                if (string3.equals(DND_OPEN_DIR)) {
                    this.m_optionValues.setDndOpenDir(string2);
                    continue;
                }
                if (string3.equals(PDF_SAVE_DIR)) {
                    this.m_optionValues.setPdfSaveDir(string2);
                    continue;
                }
                if (string3.equals(TREE_STYLE)) {
                    this.m_optionValues.setTreeStyle(Integer.parseInt(string2));
                    continue;
                }
                if (string3.equals(SHOW_LENGTH)) {
                    this.m_optionValues.setShowLength(Boolean.valueOf(string2));
                    continue;
                }
                if (string3.equals(NODE_SYMBOL)) {
                    this.m_optionValues.setNodeSymbol(Integer.parseInt(string2));
                    continue;
                }
                if (string3.equals(FONT_TYPE)) {
                    this.m_optionValues.setFontType(Integer.parseInt(string2));
                    continue;
                }
                if (string3.equals(COLOR_TYPE)) {
                    this.m_optionValues.setColorType(Integer.parseInt(string2));
                    continue;
                }
                if (string3.equals(IN_GROUP_COLOR)) {
                    this.m_optionValues.setInGroupColor(string2);
                    continue;
                }
                if (!string3.equals(OUT_GROUP_COLOR)) continue;
                this.m_optionValues.setOutGroupColor(string2);
            }
        }
        fileInputStream.close();
    }

    public OptionValues getOptionValues() {
        return this.m_optionValues;
    }

    public void readOption() throws IOException {
        this.checkOption();
        this.readOptionValues();
        this.createFont();
    }

    public void createFont() {
        int n;
        switch (this.m_optionValues.getFontType()) {
            case 0: {
                n = 14;
                break;
            }
            case 1: {
                n = 12;
                break;
            }
            case 2: {
                n = 16;
                break;
            }
            default: {
                n = 14;
            }
        }
        this.m_font = new Font("Monospaced", 0, n);
    }

    public Font getFont() {
        return this.m_font;
    }

    public void writeOption() throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(this.m_optionDat);
        PrintWriter printWriter = new PrintWriter(fileOutputStream);
        printWriter.println(this.m_header);
        printWriter.println("");
        printWriter.println(OPTION_VALUES);
        printWriter.println("mainWindowX=" + this.m_optionValues.getMainWindowX());
        printWriter.println("mainWindowY=" + this.m_optionValues.getMainWindowY());
        printWriter.println("mainWindowW=" + this.m_optionValues.getMainWindowW());
        printWriter.println("mainWindowH=" + this.m_optionValues.getMainWindowH());
        printWriter.println("dndOpenDir=" + this.m_optionValues.getDndOpenDir());
        printWriter.println("pdfSaveDir=" + this.m_optionValues.getPdfSaveDir());
        printWriter.println("treeStyle=" + this.m_optionValues.getTreeStyle());
        printWriter.println("showLength=" + this.m_optionValues.isShowLength());
        printWriter.println("nodeSymbol=" + this.m_optionValues.getNodeSymbol());
        printWriter.println("fontType=" + this.m_optionValues.getFontType());
        printWriter.println("colorType=" + this.m_optionValues.getColorType());
        printWriter.println("inGroupColor=" + this.m_optionValues.getInGroupColor());
        printWriter.println("outGroupColor=" + this.m_optionValues.getOutGroupColor());
        printWriter.flush();
        fileOutputStream.close();
    }

    private void checkOption() throws IOException {
        FileInputStream fileInputStream = new FileInputStream(this.m_optionDat);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
        String string = bufferedReader.readLine();
        fileInputStream.close();
        if (!string.startsWith(this.m_header)) {
            throw new IOException("It is not an option file of " + CommonProcess.getPtreeTitle() + ".");
        }
    }
}

