/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.search;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.data.Cluster;
import cgdp.recog.funccat.FunctionCategoryColorCellRenderer;
import cgdp.recog.search.ClusterResultTableModel;
import cgdp.recog.search.KeywordSearchResult;
import cgdp.recog.search.SearchResultDisplayOptionPanel;
import cgdp.recog.search.SearchResultGroup;
import cgdp.recog.search.SearchResultHolder;
import cgdp.recog.search.SetRegisterPanel;
import cgdp.recog.util.ApplicationFrame;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumn;

public class ClusterSearchResultDialog
extends ApplicationFrame
implements MouseListener,
ActionListener,
SearchResultHolder {
    private static ClusterSearchResultDialog RESULT_DIALOG;
    private static final Dimension DIALOG_SIZE;
    private static final String TITLE = "Keyword Search Result";
    private MediatorImpl mediator;
    private SearchResultGroup searchResultGroup;
    private JTable searchResultTable;
    private SearchResultDisplayOptionPanel searchResultDisplayOptionPanel;
    private SetRegisterPanel setRegisterPanel;
    private JButton closeButton;

    private ClusterSearchResultDialog(Frame frame, MediatorImpl mediatorImpl) {
        this.mediator = mediatorImpl;
        this.createComponent();
    }

    public static void createInstance(Frame frame, MediatorImpl mediatorImpl) {
        RESULT_DIALOG = new ClusterSearchResultDialog(frame, mediatorImpl);
    }

    public static ClusterSearchResultDialog getInstance() {
        return RESULT_DIALOG;
    }

    private void createComponent() {
        this.setTitle(TITLE);
        this.setSize(DIALOG_SIZE);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                ClusterSearchResultDialog.this.close();
            }
        });
        JPanel jPanel = this.createTablePanel();
        this.searchResultDisplayOptionPanel = new SearchResultDisplayOptionPanel(this.mediator);
        this.setRegisterPanel = new SetRegisterPanel(this, this.mediator, this, 1);
        this.closeButton = new JButton("Close");
        this.closeButton.addActionListener(this);
        this.getRootPane().setDefaultButton(this.closeButton);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        jPanel2.add((Component)this.setRegisterPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel2.add((Component)this.closeButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 10, 0, 0), 0, 0));
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)jPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.getContentPane().add((Component)this.searchResultDisplayOptionPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.getContentPane().add((Component)jPanel2, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 0, new Insets(10, 0, 10, 0), 0, 0));
        this.setLocationRelativeTo(this.getParent());
    }

    private JPanel createTablePanel() {
        this.searchResultTable = new JTable(new ClusterResultTableModel());
        this.searchResultTable.addMouseListener(this);
        this.searchResultTable.setSelectionMode(0);
        this.searchResultTable.setRowHeight(20);
        FunctionCategoryColorCellRenderer functionCategoryColorCellRenderer = new FunctionCategoryColorCellRenderer(true);
        TableColumn tableColumn = this.searchResultTable.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(30);
        TableColumn tableColumn2 = this.searchResultTable.getColumnModel().getColumn(1);
        tableColumn2.setPreferredWidth(60);
        TableColumn tableColumn3 = this.searchResultTable.getColumnModel().getColumn(2);
        tableColumn3.setPreferredWidth(60);
        TableColumn tableColumn4 = this.searchResultTable.getColumnModel().getColumn(3);
        tableColumn4.setPreferredWidth(350);
        tableColumn4.setCellRenderer(functionCategoryColorCellRenderer);
        TableColumn tableColumn5 = this.searchResultTable.getColumnModel().getColumn(4);
        tableColumn5.setPreferredWidth(300);
        tableColumn5.setCellRenderer(functionCategoryColorCellRenderer);
        JScrollPane jScrollPane = new JScrollPane(this.searchResultTable);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(this.searchResultTable.getRowHeight());
        jScrollPane.setHorizontalScrollBarPolicy(31);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)jScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return jPanel;
    }

    public void updateValue(boolean bl, SearchResultGroup searchResultGroup) {
        this.searchResultGroup = searchResultGroup;
        this.getClusterResultTableModel().setSearchResultList(this.searchResultGroup.getSearchResultList(), bl);
        this.setFilterHighlightSearchResult(this.searchResultGroup.isFilterActive(), this.searchResultGroup.isColorActive());
        this.searchResultDisplayOptionPanel.notifyUpdateStatus();
    }

    public void setFilterHighlightSearchResult(boolean bl, boolean bl2) {
        this.searchResultDisplayOptionPanel.setSelectedFilterHighlight(bl, bl2);
    }

    public void setHighlightSearchResult(boolean bl) {
        this.searchResultDisplayOptionPanel.setSelectedHighlight(bl);
    }

    public void setFilterSearchResult(boolean bl) {
        this.searchResultDisplayOptionPanel.setSelectedFilter(bl);
    }

    private ClusterResultTableModel getClusterResultTableModel() {
        return (ClusterResultTableModel)this.searchResultTable.getModel();
    }

    private void close() {
        this.dispose();
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        int n = this.searchResultTable.rowAtPoint(mouseEvent.getPoint());
        if (n == -1) {
            return;
        }
        if (!this.searchResultTable.isRowSelected(n)) {
            return;
        }
        KeywordSearchResult keywordSearchResult = this.searchResultGroup.getSearchResult(n);
        Cluster cluster = keywordSearchResult.getCluster();
        String string = keywordSearchResult.getOrganismCode();
        this.mediator.selectClusterOnPPM(string, null, cluster);
        this.mediator.setSelectClusterOnGenomeMap(cluster);
        this.mediator.selectOrthologGroupOnCoreGenome(cluster);
        this.mediator.selectOrthologGroupOnGlobalAlign(cluster);
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.closeButton) {
            this.close();
        }
    }

    @Override
    public List getSelectedSearchResultList() {
        return this.getClusterResultTableModel().getSelectedSearchResultList();
    }

    static {
        DIALOG_SIZE = new Dimension(900, 500);
    }
}

