/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.search;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.data.Cluster;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.data.GeneInformation;
import cgdp.recog.info.AbstractInfo;
import cgdp.recog.info.AbstractInfoTitle;
import cgdp.recog.info.cell.CellInfoFacade;
import cgdp.recog.info.cluster.ClusterInfoFacade;
import cgdp.recog.info.gene.GeneInfo;
import cgdp.recog.info.gene.GeneInfoFacade;
import cgdp.recog.info.gene.GeneInfoTitle;
import cgdp.recog.process.ProgressImpl;
import cgdp.recog.search.KeywordSearch;
import cgdp.recog.search.KeywordSearchResult;
import cgdp.recog.search.SearchCondType;
import cgdp.recog.search.SearchConditionItem;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.CollectionUtil;
import cgdp.recog.util.MapUtil;
import cgdp.recog.util.StringTool;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GeneLocalSearchExecuter
extends KeywordSearch {
    private static final ApplicationLogger logger = new ApplicationLogger(GeneLocalSearchExecuter.class);
    private List clusterList;
    private Set organismCodeSet;
    private List conditionOrSplitList;
    private Map organismLocusTagMap;

    GeneLocalSearchExecuter(Component component, MediatorImpl mediatorImpl, ClusterTbl clusterTbl, Set set, List list) {
        this.setParent(component);
        this.setMediator(mediatorImpl);
        this.setClusterTbl(clusterTbl);
        this.clusterList = clusterTbl.getViewClusterList();
        this.organismCodeSet = set;
        this.conditionOrSplitList = list;
    }

    public GeneLocalSearchExecuter(Component component, MediatorImpl mediatorImpl, ClusterTbl clusterTbl, List list, Set set, List list2) {
        this.setParent(component);
        this.setMediator(mediatorImpl);
        this.setClusterTbl(clusterTbl);
        this.clusterList = list;
        this.organismCodeSet = set;
        this.conditionOrSplitList = list2;
    }

    @Override
    public void execute(ProgressImpl progressImpl) {
        try {
            ArrayList arrayList = new ArrayList();
            Set set = this.getGeneInfoTitleSet();
            set.add(GeneInfoTitle.TITLE_GENE_NAME);
            set.add(GeneInfoTitle.TITLE_DESCRIPTION);
            Set set2 = this.getClusterInfoTitleSet();
            Set set3 = this.getCellInfoTitleSet();
            Map map = null;
            if (!CollectionUtil.isNull(set2)) {
                map = ClusterInfoFacade.createClusterInfoMap(this.clusterList, set2, ClusterInfoFacade.createClusterInfoCalcCondition(this.getClusterTbl()));
            }
            for (String string : this.organismCodeSet) {
                Map map2 = GeneInfoFacade.createGeneInfoMap(this.clusterList, string, set, true);
                map2 = this.retainTargetLocusTag(string, map2);
                Map map3 = null;
                if (!CollectionUtil.isNull(set3)) {
                    map3 = CellInfoFacade.createClusterCellInfoMap(string, this.clusterList, set3);
                }
                progressImpl.increment();
                if (!MapUtil.isNull(map)) {
                    map2 = this.addInfoToGeneInfoMap(string, map, map2);
                }
                if (!MapUtil.isNull(map3)) {
                    map2 = this.addInfoToGeneInfoMap(string, map3, map2);
                }
                if (MapUtil.isNull(map2)) {
                    progressImpl.increment();
                    continue;
                }
                Set set4 = this.getMatchLocusTagSet(map2);
                if (set4.isEmpty()) {
                    progressImpl.increment();
                    continue;
                }
                arrayList.addAll(this.createSearchResultList(string, set4, map2));
                progressImpl.increment();
                if (!progressImpl.isCanceled()) continue;
                this.setCancel(true);
                return;
            }
            if (!progressImpl.isCanceled()) {
                this.setSearchResultList(arrayList);
            }
        }
        catch (Exception exception) {
            String string = "Fail to search genes.";
            logger.warn(string, exception);
            this.setError(true);
            this.setErrorMessage(string);
        }
    }

    private Map addInfoToGeneInfoMap(String string, Map map, Map map2) {
        HashMap<String, GeneInfo> hashMap = new HashMap<String, GeneInfo>();
        for (Cluster cluster : map.keySet()) {
            AbstractInfo abstractInfo = (AbstractInfo)map.get(cluster);
            List list = cluster.getLocusTagList(string);
            if (CollectionUtil.isNull(list)) continue;
            for (String string2 : list) {
                GeneInfo geneInfo = new GeneInfo();
                geneInfo.putAllInfo(abstractInfo);
                AbstractInfo abstractInfo2 = (AbstractInfo)map2.get(string2);
                if (abstractInfo2 != null) {
                    geneInfo.putAllInfo(abstractInfo2);
                }
                hashMap.put(string2, geneInfo);
            }
        }
        return hashMap;
    }

    public void setTargetSearchResult(List list) {
        this.organismLocusTagMap = new HashMap();
        for (KeywordSearchResult keywordSearchResult : list) {
            HashSet<String> hashSet = (HashSet<String>)this.organismLocusTagMap.get(keywordSearchResult.getOrganismCode());
            if (hashSet == null) {
                hashSet = new HashSet<String>();
                this.organismLocusTagMap.put(keywordSearchResult.getOrganismCode(), hashSet);
            }
            hashSet.add(keywordSearchResult.getLocusTag());
        }
    }

    private Map retainTargetLocusTag(String string, Map map) {
        if (MapUtil.isNull(this.organismLocusTagMap)) {
            return map;
        }
        Set set = (Set)this.organismLocusTagMap.get(string);
        if (CollectionUtil.isNull(set)) {
            return null;
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (String string2 : map.keySet()) {
            if (set.contains(string2)) continue;
            hashSet.add(string2);
        }
        for (String string2 : hashSet) {
            map.remove(string2);
        }
        return map;
    }

    private Set getGeneInfoTitleSet() {
        return this.getInfoTitleSet(1);
    }

    private Set getClusterInfoTitleSet() {
        return this.getInfoTitleSet(2);
    }

    private Set getCellInfoTitleSet() {
        return this.getInfoTitleSet(3);
    }

    private Set getInfoTitleSet(int n) {
        HashSet<AbstractInfoTitle> hashSet = new HashSet<AbstractInfoTitle>();
        for (List list : this.conditionOrSplitList) {
            for (SearchConditionItem searchConditionItem : list) {
                AbstractInfoTitle abstractInfoTitle = searchConditionItem.getInfoTitle();
                if (abstractInfoTitle.getCls() != n) continue;
                hashSet.add(abstractInfoTitle);
            }
        }
        return hashSet;
    }

    static int getMaxProgress(int n) {
        return n * 2 + 1;
    }

    private List createSearchResultList(String string, Set set, Map map) {
        ArrayList<KeywordSearchResult> arrayList = new ArrayList<KeywordSearchResult>();
        for (Cluster cluster : this.clusterList) {
            List list = cluster.getGeneInformationList(string);
            if (list == null) continue;
            for (GeneInformation geneInformation : list) {
                String string2 = geneInformation.getLocusTag();
                if (!set.contains(string2)) continue;
                KeywordSearchResult keywordSearchResult = new KeywordSearchResult();
                keywordSearchResult.setCluster(cluster);
                keywordSearchResult.setGeneInformation(geneInformation);
                keywordSearchResult.setOrganismCode(string);
                GeneInfo geneInfo = (GeneInfo)map.get(string2);
                String string3 = String.valueOf(geneInfo.getInfo(GeneInfoTitle.TITLE_GENE_NAME));
                String string4 = String.valueOf(geneInfo.getInfo(GeneInfoTitle.TITLE_DESCRIPTION));
                if (!StringTool.isNull(string4)) {
                    keywordSearchResult.setGeneName(string3);
                    keywordSearchResult.setDescription(string4);
                }
                arrayList.add(keywordSearchResult);
            }
        }
        return arrayList;
    }

    private Set getMatchLocusTagSet(Map map) {
        HashSet hashSet = new HashSet();
        for (List list : this.conditionOrSplitList) {
            hashSet.addAll(this.getMatchLocusTagSet(map, list));
        }
        return hashSet;
    }

    private Set getMatchLocusTagSet(Map map, List list) {
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : map.keySet()) {
            AbstractInfo abstractInfo = (AbstractInfo)map.get(string);
            boolean bl = true;
            for (SearchConditionItem searchConditionItem : list) {
                Object object;
                if (!abstractInfo.containsTitle(searchConditionItem.getInfoTitle())) {
                    bl = false;
                    break;
                }
                if (searchConditionItem.getInfoTitle().isMulti()) {
                    object = abstractInfo.getMultiInfo(searchConditionItem.getInfoTitle());
                    if (searchConditionItem.isMultiInfoAve() && searchConditionItem.getInfoTitle().isNumeric()) {
                        if (GeneLocalSearchExecuter.isMatchAve(searchConditionItem, (List)object)) continue;
                        bl = false;
                        break;
                    }
                    if (searchConditionItem.isMultiInfoAll()) {
                        if (GeneLocalSearchExecuter.isMatchAll(searchConditionItem, (List)object)) continue;
                        bl = false;
                        break;
                    }
                    if (GeneLocalSearchExecuter.isMatchOnlyOne(searchConditionItem, (List)object)) continue;
                    bl = false;
                    break;
                }
                object = abstractInfo.getInfo(searchConditionItem.getInfoTitle());
                if (GeneLocalSearchExecuter.isMatch(object, searchConditionItem)) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            hashSet.add(string);
        }
        return hashSet;
    }

    private static boolean isMatchAve(SearchConditionItem searchConditionItem, List list) {
        double d = CollectionUtil.average(list);
        return GeneLocalSearchExecuter.isMatch(new Double(d), searchConditionItem);
    }

    private static boolean isMatchAll(SearchConditionItem searchConditionItem, List list) {
        for (Object e : list) {
            if (GeneLocalSearchExecuter.isMatch(e, searchConditionItem)) continue;
            return false;
        }
        return true;
    }

    private static boolean isMatchOnlyOne(SearchConditionItem searchConditionItem, List list) {
        for (Object e : list) {
            if (!GeneLocalSearchExecuter.isMatch(e, searchConditionItem)) continue;
            return true;
        }
        return false;
    }

    private static boolean isMatch(Object object, SearchConditionItem searchConditionItem) {
        List list = searchConditionItem.getKeyWordList();
        boolean bl = false;
        for (String string : list) {
            if (SearchCondType.isNeed(string)) {
                if (!GeneLocalSearchExecuter.isMatchInclude(object, string.substring(1))) {
                    return false;
                }
                bl = true;
                continue;
            }
            if (SearchCondType.isUnneed(string)) {
                if (GeneLocalSearchExecuter.isMatchInclude(object, string.substring(1))) {
                    return false;
                }
                bl = true;
                continue;
            }
            if (!GeneLocalSearchExecuter.isMatch(object, string.toLowerCase(), searchConditionItem.getSearchEqualType())) continue;
            bl = true;
        }
        return bl;
    }

    protected static boolean isMatch(Object object, String string, int n) {
        if (object == null || StringTool.isNull(String.valueOf(object)) || StringTool.isNull(string)) {
            return false;
        }
        String string2 = String.valueOf(object).trim().toLowerCase();
        if (SearchCondType.isLikeSearch(string)) {
            return GeneLocalSearchExecuter.isMatchInclude(object, string);
        }
        if (SearchCondType.isPrefixSearch(string)) {
            return GeneLocalSearchExecuter.isMatchInclude(object, string);
        }
        if (SearchCondType.isSuffixSearch(string)) {
            return GeneLocalSearchExecuter.isMatchInclude(object, string);
        }
        if (SearchCondType.isGreater(string)) {
            try {
                double d = Double.parseDouble(string2);
                double d2 = Double.parseDouble(string.substring(1));
                return d > d2;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
        if (SearchCondType.isGreaterEqual(string)) {
            try {
                double d = Double.parseDouble(string2);
                double d3 = Double.parseDouble(string.substring(2));
                return d >= d3;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
        if (SearchCondType.isLess(string)) {
            try {
                double d = Double.parseDouble(string2);
                double d4 = Double.parseDouble(string.substring(1));
                return d < d4;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
        if (SearchCondType.isLessEqual(string)) {
            try {
                double d = Double.parseDouble(string2);
                double d5 = Double.parseDouble(string.substring(2));
                return d <= d5;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
        if (SearchCondType.isEqualTypeEqual(n)) {
            return GeneLocalSearchExecuter.isMatchEqual(object, string);
        }
        String string3 = GeneLocalSearchExecuter.adjustKeywordForLikeSearch(string);
        return GeneLocalSearchExecuter.isMatchInclude(object, string3);
    }

    private static String adjustKeywordForLikeSearch(String string) {
        String string2 = string.startsWith("\"") ? "\"*" + string.substring(1) : "*" + string;
        string2 = string.endsWith(".\"") ? string2.substring(0, string2.length() - 2) + "*" + "\"" : (string.endsWith("\"") ? string2.substring(0, string2.length() - 1) + "*" + "\"" : (string.endsWith(".") ? string2.substring(0, string2.length() - 1) + "*" : string2 + "*"));
        return string2;
    }

    public static boolean isMatchEqual(Object object, String string) {
        if (object == null || StringTool.isNull(String.valueOf(object)) || StringTool.isNull(string)) {
            return false;
        }
        if (object instanceof Number) {
            try {
                return object.equals(new Float(string));
            }
            catch (NumberFormatException numberFormatException) {
                logger.warn("Fail to convert double. " + string);
                return false;
            }
        }
        String string2 = String.valueOf(object).toLowerCase();
        return string2.equals(string);
    }

    public static boolean isMatchInclude(Object object, String string) {
        if (object == null || StringTool.isNull(String.valueOf(object)) || StringTool.isNull(string)) {
            return false;
        }
        List list = StringTool.extractWords(string);
        String string2 = String.valueOf(object).toLowerCase();
        List list2 = StringTool.extractWords(string2);
        if (list.size() > list2.size()) {
            return false;
        }
        int n = 0;
        int n2 = 0;
        if (SearchCondType.isSuffixSearch(string)) {
            n2 = list2.size() - list.size();
        }
        boolean bl = false;
        for (int i = n2; i < list2.size(); ++i) {
            String string3 = (String)list2.get(i);
            String string4 = (String)list.get(n);
            bl = SearchCondType.isLikeSearch(string4) ? string3.indexOf(string4.substring(1, string4.length() - 1)) != -1 : (SearchCondType.isPrefixSearch(string4) ? string3.startsWith(string4.substring(0, string4.length() - 1)) : (SearchCondType.isSuffixSearch(string4) ? string3.endsWith(string4.substring(1)) : string3.equals(string4)));
            if (bl) {
                ++n;
            } else {
                if (SearchCondType.isPrefixSearch(string)) {
                    return false;
                }
                n = 0;
            }
            if (n == list.size()) {
                return true;
            }
            if (bl || n <= list2.size() - list.size()) continue;
            return false;
        }
        return false;
    }
}

