/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.search;

import cgdp.recog.data.Cluster;
import cgdp.recog.domclust.DomClustReExecuter;
import cgdp.recog.process.AbstractThreadProcess;
import cgdp.recog.process.ProgressImpl;
import cgdp.recog.search.ClusterSearchResultDialog;
import cgdp.recog.search.GeneLocalSearchExecuter;
import cgdp.recog.search.GeneSearchCondition;
import cgdp.recog.search.GeneSearchResultDialog;
import cgdp.recog.search.GeneServerSearchExecuter;
import cgdp.recog.search.KeywordSearch;
import cgdp.recog.search.KeywordSearchResult;
import cgdp.recog.search.SearchConditionAnalyzer;
import cgdp.recog.server.AccessServer;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.CollectionUtil;
import cgdp.recog.util.GeneUtil;
import cgdp.recog.util.MessageManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class GeneSearchExecuter
extends KeywordSearch {
    private static final ApplicationLogger logger = new ApplicationLogger(GeneSearchExecuter.class);
    private GeneSearchCondition condition;

    public GeneSearchExecuter(GeneSearchCondition geneSearchCondition) {
        this.condition = geneSearchCondition;
    }

    private Set getOrganismCodeSet() {
        return this.condition.getOrganismCodeSet();
    }

    private int getOrganismSize() {
        return this.getOrganismCodeSet().size();
    }

    private List getConditionItemList() {
        return this.condition.getConditionItemList();
    }

    private boolean isExecServer() {
        return this.condition.isExecServer();
    }

    @Override
    public void execute(ProgressImpl progressImpl) {
        SearchConditionAnalyzer searchConditionAnalyzer = new SearchConditionAnalyzer(this.getConditionItemList(), this.isExecServer());
        searchConditionAnalyzer.execute();
        KeywordSearch keywordSearch = null;
        if (searchConditionAnalyzer.isServerOnly()) {
            if (!AccessServer.getInstance().isEnableAccess()) {
                this.setError(true);
                this.setErrorMessages(AccessServer.getAccessErrorMessage());
                return;
            }
            progressImpl.setTotal(GeneServerSearchExecuter.getDefaultMaxProgress());
            keywordSearch = new GeneServerSearchExecuter(this.getParent(), this.getMediator(), this.getClusterTbl(), this.getOrganismCodeSet(), this.getConditionItemList());
            keywordSearch.execute(progressImpl);
            this.setSearchResultList(keywordSearch.getSearchResultList());
            this.setCancel(keywordSearch.isCancel());
            this.setError(keywordSearch.isError());
            this.setErrorCode(keywordSearch.getErrorCode());
            this.setErrorMessages(keywordSearch.getErrorMessages());
            this.setErrorNo(keywordSearch.getErrorCode());
        } else if (searchConditionAnalyzer.isLocalOnly()) {
            System.err.println("local");
            progressImpl.setTotal(GeneLocalSearchExecuter.getMaxProgress(this.getOrganismSize()));
            keywordSearch = new GeneLocalSearchExecuter(this.getParent(), this.getMediator(), this.getClusterTbl(), this.getOrganismCodeSet(), searchConditionAnalyzer.getLocalOnlyConditionList());
            keywordSearch.execute(progressImpl);
            this.setSearchResultList(keywordSearch.getSearchResultList());
            this.setCancel(keywordSearch.isCancel());
            this.setError(keywordSearch.isError());
            this.setErrorCode(keywordSearch.getErrorCode());
            this.setErrorMessages(keywordSearch.getErrorMessages());
            this.setErrorNo(keywordSearch.getErrorCode());
        } else {
            this.searchBoth(progressImpl, searchConditionAnalyzer);
        }
    }

    private void searchBoth(ProgressImpl progressImpl, SearchConditionAnalyzer searchConditionAnalyzer) {
        List list;
        int n;
        if (!AccessServer.getInstance().isEnableAccess()) {
            this.setError(true);
            this.setErrorMessages(AccessServer.getAccessErrorMessage());
            return;
        }
        List list2 = new ArrayList();
        List list3 = searchConditionAnalyzer.getServerConditionList();
        List list4 = searchConditionAnalyzer.getBothServerConditionList();
        List list5 = searchConditionAnalyzer.getBothLocalConditionList();
        List list6 = searchConditionAnalyzer.getLocalOnlyConditionList();
        int n2 = 0;
        if (!CollectionUtil.isNull(list3)) {
            n2 += GeneServerSearchExecuter.getDefaultMaxProgress();
        }
        if (!CollectionUtil.isNull(list4)) {
            n = list4.size();
            n2 += GeneServerSearchExecuter.getDefaultMaxProgress() * n + GeneLocalSearchExecuter.getMaxProgress(this.getOrganismSize()) * n;
        }
        if (!CollectionUtil.isNull(list6)) {
            n = list6.size();
            n2 += GeneLocalSearchExecuter.getMaxProgress(this.getOrganismSize()) * n;
        }
        progressImpl.setTotal(n2);
        n = 0;
        if (!CollectionUtil.isNull(list3)) {
            GeneServerSearchExecuter geneServerSearchExecuter = new GeneServerSearchExecuter(this.getParent(), this.getMediator(), this.getClusterTbl(), this.getOrganismCodeSet(), list3);
            geneServerSearchExecuter.execute(progressImpl);
            this.setErrorCancelStatus(geneServerSearchExecuter);
            if (geneServerSearchExecuter.isError() || geneServerSearchExecuter.isCancel()) {
                return;
            }
            list2.addAll(geneServerSearchExecuter.getSearchResultList());
            progressImpl.setCount(n += GeneServerSearchExecuter.getDefaultMaxProgress());
        }
        for (int i = 0; i < list5.size(); ++i) {
            list = (List)list4.get(i);
            GeneServerSearchExecuter geneServerSearchExecuter = new GeneServerSearchExecuter(this.getParent(), this.getMediator(), this.getClusterTbl(), this.getOrganismCodeSet(), list);
            geneServerSearchExecuter.execute(progressImpl);
            this.setErrorCancelStatus(geneServerSearchExecuter);
            if (geneServerSearchExecuter.isError() || geneServerSearchExecuter.isCancel()) {
                return;
            }
            progressImpl.setCount(n += GeneServerSearchExecuter.getDefaultMaxProgress());
            List list7 = geneServerSearchExecuter.getSearchResultList();
            if (CollectionUtil.isNull(list7)) {
                progressImpl.setCount(n += GeneLocalSearchExecuter.getMaxProgress(this.getOrganismSize()));
                continue;
            }
            List list8 = (List)list5.get(i);
            GeneLocalSearchExecuter geneLocalSearchExecuter = new GeneLocalSearchExecuter(this.getParent(), this.getMediator(), this.getClusterTbl(), this.getOrganismCodeSet(), list8);
            geneLocalSearchExecuter.setTargetSearchResult(list7);
            geneLocalSearchExecuter.execute(progressImpl);
            this.setErrorCancelStatus(geneLocalSearchExecuter);
            if (geneLocalSearchExecuter.isError() || geneLocalSearchExecuter.isCancel()) {
                return;
            }
            progressImpl.setCount(n += GeneLocalSearchExecuter.getMaxProgress(this.getOrganismSize()));
            List list9 = geneLocalSearchExecuter.getSearchResultList();
            List list10 = this.margeSearchResultByAnd(list7, list9);
            list2 = this.margeSearchResultByOr(list2, list10);
        }
        if (!CollectionUtil.isNull(list6)) {
            GeneLocalSearchExecuter geneLocalSearchExecuter = new GeneLocalSearchExecuter(this.getParent(), this.getMediator(), this.getClusterTbl(), this.getOrganismCodeSet(), list6);
            geneLocalSearchExecuter.execute(progressImpl);
            this.setErrorCancelStatus(geneLocalSearchExecuter);
            if (geneLocalSearchExecuter.isError() || geneLocalSearchExecuter.isCancel()) {
                return;
            }
            progressImpl.setCount(n += GeneLocalSearchExecuter.getMaxProgress(this.getOrganismSize()));
            list = geneLocalSearchExecuter.getSearchResultList();
            list2 = this.margeSearchResultByOr(list2, list);
        }
        this.setSearchResultList(list2);
        progressImpl.setCount(n2 - 1);
        progressImpl.increment();
    }

    private void searchBothServer(ProgressImpl progressImpl, SearchConditionAnalyzer searchConditionAnalyzer) {
        List list = searchConditionAnalyzer.getServerConditionList();
        GeneServerSearchExecuter geneServerSearchExecuter = new GeneServerSearchExecuter(this.getParent(), this.getMediator(), this.getClusterTbl(), this.getOrganismCodeSet(), list);
        geneServerSearchExecuter.execute(progressImpl);
        this.setErrorCancelStatus(geneServerSearchExecuter);
        if (geneServerSearchExecuter.isError() || geneServerSearchExecuter.isCancel()) {
            return;
        }
        List list2 = geneServerSearchExecuter.getSearchResultList();
        List list3 = searchConditionAnalyzer.getLocalOnlyConditionList();
        GeneLocalSearchExecuter geneLocalSearchExecuter = new GeneLocalSearchExecuter(this.getParent(), this.getMediator(), this.getClusterTbl(), this.getOrganismCodeSet(), list3);
        geneLocalSearchExecuter.execute(progressImpl);
        this.setErrorCancelStatus(geneLocalSearchExecuter);
        if (geneLocalSearchExecuter.isError() || geneLocalSearchExecuter.isCancel()) {
            return;
        }
        List list4 = geneLocalSearchExecuter.getSearchResultList();
        Set set = this.createOrganismLocusTagKeySet(list2);
        ArrayList<KeywordSearchResult> arrayList = new ArrayList<KeywordSearchResult>(list2);
        for (KeywordSearchResult keywordSearchResult : list4) {
            String string = GeneUtil.createOrganismLocusTagKey(keywordSearchResult.getOrganismCode(), keywordSearchResult.getLocusTag());
            if (set.contains(string)) continue;
            arrayList.add(keywordSearchResult);
        }
        this.setSearchResultList(arrayList);
        progressImpl.setCount(99);
        progressImpl.increment();
    }

    private void searchBothServerLocal(ProgressImpl progressImpl, SearchConditionAnalyzer searchConditionAnalyzer) {
        Object object3;
        Object object2;
        List list = searchConditionAnalyzer.getBothServerConditionList();
        GeneServerSearchExecuter geneServerSearchExecuter = new GeneServerSearchExecuter(this.getParent(), this.getMediator(), this.getClusterTbl(), this.getOrganismCodeSet(), list);
        geneServerSearchExecuter.setMaxProgress(40);
        geneServerSearchExecuter.execute(progressImpl);
        this.setErrorCancelStatus(geneServerSearchExecuter);
        if (geneServerSearchExecuter.isError() || geneServerSearchExecuter.isCancel()) {
            return;
        }
        List list2 = geneServerSearchExecuter.getSearchResultList();
        progressImpl.setCount(40);
        progressImpl.increment();
        List list3 = searchConditionAnalyzer.getBothLocalConditionList();
        GeneLocalSearchExecuter geneLocalSearchExecuter = new GeneLocalSearchExecuter(this.getParent(), this.getMediator(), this.getClusterTbl(), this.getOrganismCodeSet(), list3);
        geneLocalSearchExecuter.execute(progressImpl);
        this.setErrorCancelStatus(geneLocalSearchExecuter);
        if (geneLocalSearchExecuter.isError() || geneLocalSearchExecuter.isCancel()) {
            return;
        }
        List list4 = geneLocalSearchExecuter.getSearchResultList();
        progressImpl.setCount(80);
        progressImpl.increment();
        List list5 = new ArrayList();
        List list6 = searchConditionAnalyzer.getLocalOnlyConditionList();
        if (!CollectionUtil.isNull(list6)) {
            object2 = new GeneLocalSearchExecuter(this.getParent(), this.getMediator(), this.getClusterTbl(), this.getOrganismCodeSet(), list6);
            object2.execute(progressImpl);
            this.setErrorCancelStatus((KeywordSearch)object2);
            if (((AbstractThreadProcess)object2).isError() || ((AbstractThreadProcess)object2).isCancel()) {
                return;
            }
            list5 = ((KeywordSearch)object2).getSearchResultList();
        }
        progressImpl.setCount(90);
        progressImpl.increment();
        object2 = this.createOrganismLocusTagKeySet(list2);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Object object3 : list4) {
            String string = GeneUtil.createOrganismLocusTagKey(((KeywordSearchResult)object3).getOrganismCode(), ((KeywordSearchResult)object3).getLocusTag());
            if (!object2.contains(string)) continue;
            arrayList.add(object3);
        }
        Set set = this.createOrganismLocusTagKeySet(arrayList);
        object3 = new ArrayList(arrayList);
        for (KeywordSearchResult keywordSearchResult : list5) {
            String string = GeneUtil.createOrganismLocusTagKey(keywordSearchResult.getOrganismCode(), keywordSearchResult.getLocusTag());
            if (set.contains(string)) continue;
            object3.add(keywordSearchResult);
        }
        progressImpl.setCount(99);
        progressImpl.increment();
        this.setSearchResultList((List)object3);
    }

    private List margeSearchResultByAnd(List list, List list2) {
        Set set = this.createOrganismLocusTagKeySet(list);
        ArrayList<KeywordSearchResult> arrayList = new ArrayList<KeywordSearchResult>();
        for (KeywordSearchResult keywordSearchResult : list2) {
            String string = GeneUtil.createOrganismLocusTagKey(keywordSearchResult.getOrganismCode(), keywordSearchResult.getLocusTag());
            if (!set.contains(string)) continue;
            arrayList.add(keywordSearchResult);
        }
        return arrayList;
    }

    private List margeSearchResultByOr(List list, List list2) {
        Set set = this.createOrganismLocusTagKeySet(list);
        ArrayList<KeywordSearchResult> arrayList = new ArrayList<KeywordSearchResult>(list);
        for (KeywordSearchResult keywordSearchResult : list2) {
            String string = GeneUtil.createOrganismLocusTagKey(keywordSearchResult.getOrganismCode(), keywordSearchResult.getLocusTag());
            if (set.contains(string)) continue;
            arrayList.add(keywordSearchResult);
        }
        return arrayList;
    }

    private void setErrorCancelStatus(KeywordSearch keywordSearch) {
        this.setCancel(keywordSearch.isCancel());
        this.setError(keywordSearch.isError());
        this.setErrorCode(keywordSearch.getErrorCode());
        this.setErrorMessages(keywordSearch.getErrorMessages());
        this.setErrorNo(keywordSearch.getErrorCode());
    }

    private Set createOrganismLocusTagKeySet(List list) {
        HashSet<String> hashSet = new HashSet<String>();
        for (KeywordSearchResult keywordSearchResult : list) {
            String string = GeneUtil.createOrganismLocusTagKey(keywordSearchResult.getOrganismCode(), keywordSearchResult.getLocusTag());
            hashSet.add(string);
        }
        return hashSet;
    }

    @Override
    public void done() {
        if (this.isCancel()) {
            return;
        }
        if (this.isError()) {
            if (DomClustReExecuter.isNoClusterTable(this.getErrorNo())) {
                try {
                    DomClustReExecuter domClustReExecuter = new DomClustReExecuter(this.getParent(), this.getMediator(), this.getClusterTbl().getFilepath());
                    domClustReExecuter.setErrorMessage("Fail to execute keyword search.");
                    domClustReExecuter.execute();
                }
                catch (Exception exception) {
                    String string = "Fail to execute keyword search.";
                    logger.warn(string, exception);
                    MessageManager.showErrorMessage(this.getParent(), string);
                }
            } else {
                MessageManager.showErrorMessage(this.getParent(), this.getErrorMessages());
            }
            return;
        }
        if (!this.isExistSearchResult()) {
            MessageManager.showMessage(this.getParent(), "Cluster data is not found.");
            return;
        }
        this.getMediator().setSearchResult(this.condition, this.getSearchResultList());
        this.getMediator().showHighlightFilterSearchResult();
        ClusterSearchResultDialog.getInstance().setVisible(false);
        GeneSearchResultDialog geneSearchResultDialog = GeneSearchResultDialog.getInstance();
        geneSearchResultDialog.updateValue(this.getClusterTbl().isOutgroup(), this.getClusterTbl().getSearchResultGroup());
        geneSearchResultDialog.setVisible(true);
        this.getMediator().updateMemory();
    }

    private Set createClusterIdSpSet(List list) {
        HashSet<String> hashSet = new HashSet<String>();
        for (KeywordSearchResult keywordSearchResult : list) {
            Cluster cluster = keywordSearchResult.getCluster();
            String string = keywordSearchResult.getOrganismCode();
            hashSet.add(cluster.getConbinedClusterId() + string);
        }
        return hashSet;
    }
}

