/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.search;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.info.AbstractInfoTitle;
import cgdp.recog.info.InfoTitleComboBox;
import cgdp.recog.info.cell.CellInfoFacade;
import cgdp.recog.info.cluster.ClusterInfoFacade;
import cgdp.recog.info.gene.GeneInfoFacade;
import cgdp.recog.info.gene.GeneInfoFilterMultiOptionPanel;
import cgdp.recog.info.gene.GeneInfoTitle;
import cgdp.recog.organism.MultiOrganism;
import cgdp.recog.organism.Organism;
import cgdp.recog.organism.OrganismComboBox;
import cgdp.recog.organism.OrganismFactory;
import cgdp.recog.organism.OrganismUtil;
import cgdp.recog.search.GeneSearchCondition;
import cgdp.recog.search.GeneSearchExecuter;
import cgdp.recog.search.KeywordSearchOptionPanel;
import cgdp.recog.search.SearchCondType;
import cgdp.recog.search.SearchConditionItem;
import cgdp.recog.search.SearchJoinType;
import cgdp.recog.util.FocusTextField;
import cgdp.recog.util.KeyName;
import cgdp.recog.util.MessageManager;
import cgdp.recog.util.StringTool;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class GeneSearchPanel
extends KeywordSearchOptionPanel
implements ActionListener,
ItemListener {
    private static final String ITEM_SP_NAME_ALL = "All species";
    private static final int DEFAULT_CONDITION_COUNT = 3;
    private static final String NAME_OPTION_BUTTON_OPEN = ">>Option";
    private static final String NAME_OPTION_BUTTON_CLOSE = "<<Option";
    private static final String NO_COND_KEY = "#NONE#";
    private static final GeneInfoTitle NO_COND = new GeneInfoTitle("#NONE#", "", -1);
    private Container parent;
    private MediatorImpl mediator;
    private OrganismComboBox organismComboBox;
    private JButton addConditionButton;
    private JButton clearConditionButton;
    private GeneInfoFilterMultiOptionPanel multiValuePanel;
    private JButton optionButton;
    private JPanel optionPanel;
    private boolean showOption;
    private JCheckBox locationCheckBox;
    private List searchConditionComponentList;
    private List infoTitleList;
    private String organismCode;

    public GeneSearchPanel(Container container, MediatorImpl mediatorImpl) {
        this.parent = container;
        this.mediator = mediatorImpl;
        this.init();
    }

    protected void init() {
        this.searchConditionComponentList = new ArrayList();
        this.setLayout(new GridBagLayout());
        if (!this.isFixOrganism()) {
            this.organismComboBox = new OrganismComboBox();
            this.organismComboBox.addItemListener(this);
            this.add((Component)this.organismComboBox, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(10, 10, 5, 10), 0, 0));
        }
        for (int i = 0; i < 3; ++i) {
            SearchConditionComponent searchConditionComponent = new SearchConditionComponent(i != 0);
            this.searchConditionComponentList.add(searchConditionComponent);
            this.add((Component)searchConditionComponent, new GridBagConstraints(0, i + 1, 1, 1, 1.0, 1.0, 17, 2, new Insets(5, 10, 5, 10), 0, 0));
        }
        this.addConditionButton = new JButton("Add Condition");
        this.addConditionButton.addActionListener(this);
        this.clearConditionButton = new JButton("Clear Condition");
        this.clearConditionButton.addActionListener(this);
        this.optionPanel = this.createOptionPanel();
        this.optionPanel.setVisible(false);
        this.optionButton = new JButton(NAME_OPTION_BUTTON_OPEN);
        this.optionButton.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this.addConditionButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 10, 5, 10), 0, 0));
        jPanel.add((Component)this.clearConditionButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 10, 5, 10), 0, 0));
        jPanel.add((Component)this.optionButton, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 10, 5, 10), 0, 0));
        this.add((Component)jPanel, new GridBagConstraints(0, 5, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 10, 5, 10), 0, 0));
        this.add((Component)this.optionPanel, new GridBagConstraints(0, 6, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 10, 5, 10), 0, 0));
    }

    private void initSearchConditionComponentList() {
        if (this.searchConditionComponentList.size() <= 3) {
            return;
        }
        HashSet<SearchConditionComponent> hashSet = new HashSet<SearchConditionComponent>();
        for (int i = this.searchConditionComponentList.size() - 1; i >= 0; --i) {
            SearchConditionComponent searchConditionComponent = (SearchConditionComponent)this.searchConditionComponentList.get(i);
            if (searchConditionComponent.isEmpty()) {
                hashSet.add(searchConditionComponent);
            }
            if (hashSet.size() >= this.searchConditionComponentList.size() - 3) break;
        }
        this.searchConditionComponentList.removeAll(hashSet);
    }

    private void updateComponents() {
        this.removeAll();
        if (!this.isFixOrganism()) {
            this.add((Component)this.organismComboBox, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(10, 10, 5, 10), 0, 0));
        }
        for (int i = 0; i < this.searchConditionComponentList.size(); ++i) {
            SearchConditionComponent searchConditionComponent = (SearchConditionComponent)this.searchConditionComponentList.get(i);
            this.add((Component)searchConditionComponent, new GridBagConstraints(0, i + 1, 1, 1, 1.0, 1.0, 17, 2, new Insets(5, 10, 5, 10), 0, 0));
        }
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this.addConditionButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 10, 5, 10), 0, 0));
        jPanel.add((Component)this.clearConditionButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 10, 5, 10), 0, 0));
        jPanel.add((Component)this.optionButton, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 10, 5, 10), 0, 0));
        this.add((Component)jPanel, new GridBagConstraints(0, this.searchConditionComponentList.size() + 2, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 10, 5, 10), 0, 0));
        this.add((Component)this.optionPanel, new GridBagConstraints(0, this.searchConditionComponentList.size() + 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 10, 5, 10), 0, 0));
        this.revalidate();
        ((JDialog)this.parent).pack();
    }

    private JPanel createOptionPanel() {
        this.locationCheckBox = new JCheckBox("Search on the server.");
        this.locationCheckBox.setSelected(true);
        this.multiValuePanel = new GeneInfoFilterMultiOptionPanel();
        this.multiValuePanel.setBorder(BorderFactory.createTitledBorder("Representative value of multiple gene's property value"));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this.locationCheckBox, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.multiValuePanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        return jPanel;
    }

    void updateValue(String string, List list) {
        List list2 = OrganismUtil.getOrganismList(list);
        MultiOrganism multiOrganism = OrganismFactory.createSetOrganism();
        multiOrganism.setOrganismList(list2);
        multiOrganism.setDisplayLabel(ITEM_SP_NAME_ALL);
        list2.add(0, multiOrganism);
        this.organismComboBox.removeItemListener(this);
        this.organismComboBox.updateValueByOrganism(list2);
        if (StringTool.isNull(string)) {
            this.organismComboBox.setSelectedIndex(0);
        } else {
            this.organismComboBox.setSelectedOrganismCode(string);
        }
        this.organismComboBox.addItemListener(this);
        this.updateGeneInfoTitleItems();
        this.initSearchConditionComponentList();
        this.updateComponents();
    }

    public void updateValue(String string, GeneSearchCondition geneSearchCondition) {
        this.organismCode = string;
        this.updateGeneInfoTitleItems();
        if (geneSearchCondition != null) {
            this.updateCondition(geneSearchCondition);
        } else {
            this.initSearchConditionComponentList();
            this.updateComponents();
        }
    }

    public void setDefaultLocalSearch(boolean bl) {
        this.locationCheckBox.setSelected(!bl);
    }

    private boolean isFixOrganism() {
        return !StringTool.isNull(this.organismCode);
    }

    @Override
    protected boolean check() {
        boolean bl = false;
        for (SearchConditionComponent searchConditionComponent : this.searchConditionComponentList) {
            if (searchConditionComponent.isEmpty()) continue;
            bl = true;
            break;
        }
        if (!bl) {
            MessageManager.showErrorMessage((Component)this.parent, "Input keywords.");
            return false;
        }
        for (SearchConditionComponent searchConditionComponent : this.searchConditionComponentList) {
            if (searchConditionComponent.isEmpty() || searchConditionComponent.checkValueAsNumeric()) continue;
            MessageManager.showErrorMessage((Component)this.parent, "Input numerical value at " + searchConditionComponent.getInfoTitle());
            return false;
        }
        return true;
    }

    private Set getOrganismCodeSet() {
        HashSet<String> hashSet = new HashSet<String>();
        if (this.isFixOrganism()) {
            hashSet.add(this.organismCode);
        } else {
            Organism organism = this.organismComboBox.getSelectedOrganism();
            if (organism.getDisplayOrganismName().equals(ITEM_SP_NAME_ALL)) {
                hashSet.addAll(((MultiOrganism)organism).getOrganismCodeList());
            } else {
                hashSet.add(organism.getOrganismCode());
            }
        }
        return hashSet;
    }

    private boolean isExecuteServer() {
        return this.locationCheckBox.isSelected();
    }

    private List getSearchConditionList() {
        ArrayList<SearchConditionItem> arrayList = new ArrayList<SearchConditionItem>();
        for (SearchConditionComponent searchConditionComponent : this.searchConditionComponentList) {
            if (searchConditionComponent.isEmpty()) continue;
            SearchConditionItem searchConditionItem = searchConditionComponent.getSearchCondition();
            if (this.multiValuePanel.isAve() && searchConditionItem.getInfoTitle().isNumeric()) {
                searchConditionItem.setMultiInfoType(4);
            } else {
                searchConditionItem.setMultiInfoType(this.multiValuePanel.getMultiType());
            }
            arrayList.add(searchConditionItem);
        }
        return arrayList;
    }

    public GeneSearchCondition getCondition() {
        GeneSearchCondition geneSearchCondition = new GeneSearchCondition();
        geneSearchCondition.setOrganismCodeSet(this.getOrganismCodeSet());
        geneSearchCondition.setConditionItemList(this.getSearchConditionList());
        geneSearchCondition.setExecServer(this.isExecuteServer());
        return geneSearchCondition;
    }

    private void clearCondition() {
        this.searchConditionComponentList.clear();
        for (int i = 0; i < 3; ++i) {
            SearchConditionComponent searchConditionComponent = new SearchConditionComponent(i != 0);
            searchConditionComponent.updateSortKeyItem(this.infoTitleList);
            this.searchConditionComponentList.add(searchConditionComponent);
        }
        this.updateComponents();
    }

    private void updateCondition(GeneSearchCondition geneSearchCondition) {
        Object object;
        int n;
        this.searchConditionComponentList.clear();
        List list = geneSearchCondition.getConditionItemList();
        for (n = 0; n < list.size(); ++n) {
            object = (SearchConditionItem)list.get(n);
            SearchConditionComponent searchConditionComponent = new SearchConditionComponent(n != 0);
            searchConditionComponent.updateValue((SearchConditionItem)object, this.infoTitleList);
            this.searchConditionComponentList.add(searchConditionComponent);
        }
        for (n = list.size(); n < 3; ++n) {
            object = new SearchConditionComponent(n != 0);
            ((SearchConditionComponent)object).updateSortKeyItem(this.infoTitleList);
            this.searchConditionComponentList.add(object);
        }
        this.updateComponents();
    }

    @Override
    protected boolean apply() {
        if (this.mediator != null) {
            this.mediator.clearHighlightFilterSearchResult();
            GeneSearchExecuter geneSearchExecuter = new GeneSearchExecuter(this.getCondition());
            this.mediator.executeKeywordSearch(geneSearchExecuter);
        }
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.addConditionButton) {
            SearchConditionComponent searchConditionComponent = new SearchConditionComponent(true);
            searchConditionComponent.updateSortKeyItem(this.infoTitleList);
            this.searchConditionComponentList.add(searchConditionComponent);
            this.updateComponents();
        } else if (actionEvent.getSource() == this.clearConditionButton) {
            this.clearCondition();
        } else if (actionEvent.getSource() == this.optionButton) {
            this.showOptionPanel();
        }
    }

    private void updateGeneInfoTitleItems() {
        Set set = this.getOrganismCodeSet();
        this.infoTitleList = GeneInfoFacade.getGeneInfoTitleList(set);
        this.infoTitleList.addAll(ClusterInfoFacade.getInfoTitleListByAnalysisKey("UseSearch", this.getClusterTbl()));
        this.infoTitleList.addAll(CellInfoFacade.getInfoTitleListByAnalysisKey("UseSearch", this.getClusterTbl()));
        this.infoTitleList.add(0, NO_COND);
        this.infoTitleList.remove(GeneInfoTitle.TITLE_DESCRIPTION);
        this.infoTitleList.add(1, GeneInfoTitle.TITLE_DESCRIPTION);
        for (SearchConditionComponent searchConditionComponent : this.searchConditionComponentList) {
            searchConditionComponent.updateSortKeyItem(this.infoTitleList);
        }
        ((JDialog)this.parent).pack();
    }

    private void showOptionPanel() {
        this.optionPanel.setVisible(!this.optionPanel.isVisible());
        if (this.showOption) {
            this.optionButton.setText(NAME_OPTION_BUTTON_OPEN);
            this.showOption = false;
        } else {
            this.optionButton.setText(NAME_OPTION_BUTTON_CLOSE);
            this.showOption = true;
        }
        ((JDialog)this.parent).pack();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.organismComboBox) {
            this.updateGeneInfoTitleItems();
        }
    }

    private class SearchConditionComponent
    extends JPanel {
        private static final int TEXT_FIELD_WIDTH = 300;
        private static final int JOIN_COMBOBOX_WIDTH = 80;
        private JComboBox joinComboBox;
        private InfoTitleComboBox itemComboBox;
        private FocusTextField textFiled;
        private boolean showJoin = true;

        private SearchConditionComponent(boolean bl) {
            this.showJoin = bl;
            this.init();
        }

        private void init() {
            this.joinComboBox = new JComboBox<KeyName>(this.createJoins());
            this.joinComboBox.setVisible(this.showJoin);
            this.joinComboBox.setPreferredSize(new Dimension(80, this.joinComboBox.getPreferredSize().height));
            this.itemComboBox = new InfoTitleComboBox();
            this.textFiled = new FocusTextField();
            this.textFiled.setPreferredSize(new Dimension(300, this.textFiled.getPreferredSize().height));
            this.setLayout(new GridBagLayout());
            if (this.showJoin) {
                this.add((Component)this.joinComboBox, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            } else {
                JPanel jPanel = new JPanel();
                jPanel.setPreferredSize(new Dimension(80, this.joinComboBox.getPreferredSize().height));
                this.add((Component)jPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            }
            this.add((Component)this.itemComboBox, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
            this.add((Component)this.textFiled, new GridBagConstraints(2, 0, 1, 1, 2.0, 1.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
        }

        private KeyName[] createJoins() {
            KeyName[] keyNameArray = new KeyName[]{new KeyName("AND", "and"), new KeyName("OR", "or")};
            return keyNameArray;
        }

        public void updateValue(SearchConditionItem searchConditionItem, List list) {
            this.updateSortKeyItem(list);
            this.itemComboBox.setSelectedInfoTitle(searchConditionItem.getInfoTitle());
            this.textFiled.setText(searchConditionItem.getValue());
            int n = 0;
            if (SearchJoinType.isOr(searchConditionItem.getJoinKey())) {
                n = 1;
            }
            this.joinComboBox.setSelectedIndex(n);
        }

        public void updateSortKeyItem(List list) {
            this.itemComboBox.updateInfoTitleItems(list);
        }

        boolean isEmpty() {
            return this.getInfoTitle() == null || this.textFiled.getText().equals("");
        }

        private AbstractInfoTitle getInfoTitle() {
            return this.itemComboBox.getSelectedInfoTitle();
        }

        private String getValue() {
            return this.textFiled.getText();
        }

        SearchConditionItem getSearchCondition() {
            SearchConditionItem searchConditionItem = new SearchConditionItem();
            searchConditionItem.setJoinKey(((KeyName)this.joinComboBox.getSelectedItem()).getKey());
            searchConditionItem.setInfoTitle(this.getInfoTitle());
            searchConditionItem.setValue(this.getModifiedValue(this.textFiled.getText(), this.getInfoTitle()));
            return searchConditionItem;
        }

        private String getModifiedValue(String string, AbstractInfoTitle abstractInfoTitle) {
            if (StringTool.isNull(string)) {
                return string;
            }
            if (abstractInfoTitle.isCluster() && abstractInfoTitle.equalsKey("combine_clusterid")) {
                StringBuffer stringBuffer = new StringBuffer();
                List list = SearchConditionItem.getKeyWordList(string);
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    String string2 = ((String)iterator.next()).trim();
                    if (string2.startsWith("O")) {
                        string2 = string2.substring(1);
                    }
                    if (string2.indexOf(".") == -1) {
                        string2 = string2 + ".1";
                    }
                    stringBuffer.append(string2);
                    stringBuffer.append(" ");
                }
                return stringBuffer.toString().trim();
            }
            return string;
        }

        boolean checkValueAsNumeric() {
            AbstractInfoTitle abstractInfoTitle = this.getInfoTitle();
            if (abstractInfoTitle.isNumeric()) {
                String string = this.getValue();
                if (SearchCondType.isGreater(string) || SearchCondType.isLess(string)) {
                    string = string.substring(1);
                } else if (SearchCondType.isGreaterEqual(string) || SearchCondType.isLessEqual(string)) {
                    string = string.substring(2);
                }
                try {
                    Double.parseDouble(string);
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
            }
            return true;
        }
    }
}

