/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.search;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.data.Cluster;
import cgdp.recog.search.ClusterTreeNode;
import cgdp.recog.search.FunctionCategoryTableCellRenderer;
import cgdp.recog.search.GeneSearchTreeTableModel;
import cgdp.recog.search.GeneTreeNode;
import cgdp.recog.search.KeywordSearchResult;
import cgdp.recog.search.SearchResultDisplayOptionPanel;
import cgdp.recog.search.SearchResultGroup;
import cgdp.recog.search.SearchResultHolder;
import cgdp.recog.search.SetRegisterPanel;
import cgdp.recog.util.ApplicationFrame;
import cgdp.recog.util.treetable.AbstractTreeTableModel;
import cgdp.recog.util.treetable.JTreeTable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;

public class GeneSearchResultDialog
extends ApplicationFrame
implements ActionListener,
MouseListener,
SearchResultHolder {
    private static GeneSearchResultDialog RESULT_DIALOG;
    private static final Dimension DIALOG_SIZE;
    private MediatorImpl mediator;
    private boolean outgroupFlag;
    private static final String TITLE = "Keyword Search Result";
    private JTreeTable treeTable;
    private SearchResultGroup searchResultGroup;
    private SearchResultDisplayOptionPanel searchResultDisplayOptionPanel;
    private AbstractTreeTableModel treeTableModel;
    private SetRegisterPanel setRegisterPanel;
    private JButton closeButton;

    private GeneSearchResultDialog(Frame frame, MediatorImpl mediatorImpl) {
        this.mediator = mediatorImpl;
        this.init();
    }

    public static void createInstance(Frame frame, MediatorImpl mediatorImpl) {
        RESULT_DIALOG = new GeneSearchResultDialog(frame, mediatorImpl);
    }

    public static GeneSearchResultDialog getInstance() {
        return RESULT_DIALOG;
    }

    private void init() {
        this.setTitle(TITLE);
        this.setSize(DIALOG_SIZE);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                GeneSearchResultDialog.this.close();
            }
        });
        JPanel jPanel = this.createTreeTablePanel();
        this.searchResultDisplayOptionPanel = new SearchResultDisplayOptionPanel(this.mediator);
        this.searchResultDisplayOptionPanel.setFilterCheckBoxLabel("Display only matched genes.");
        this.searchResultDisplayOptionPanel.setHighlightCheckBoxLabel("Highlight matched genes.");
        this.setRegisterPanel = new SetRegisterPanel(this, this.mediator, this, 2);
        this.closeButton = new JButton("Close");
        this.closeButton.addActionListener(this);
        this.getRootPane().setDefaultButton(this.closeButton);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        jPanel2.add((Component)this.setRegisterPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel2.add((Component)this.closeButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 10, 0, 0), 0, 0));
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)jPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.getContentPane().add((Component)this.searchResultDisplayOptionPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.getContentPane().add((Component)jPanel2, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 0, new Insets(10, 0, 10, 0), 0, 0));
        this.setLocationRelativeTo(this.getParent());
    }

    private JPanel createTreeTablePanel() {
        this.treeTableModel = new GeneSearchTreeTableModel();
        this.treeTable = new JTreeTable(this.treeTableModel);
        this.treeTable.getTree().setRootVisible(false);
        this.treeTable.addMouseListener(this);
        this.treeTable.setRowHeight(20);
        TableColumn tableColumn = this.treeTable.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(50);
        TableColumn tableColumn2 = this.treeTable.getColumnModel().getColumn(1);
        tableColumn2.setPreferredWidth(130);
        TableColumn tableColumn3 = this.treeTable.getColumnModel().getColumn(2);
        tableColumn3.setPreferredWidth(100);
        TableColumn tableColumn4 = this.treeTable.getColumnModel().getColumn(3);
        tableColumn4.setPreferredWidth(80);
        TableColumn tableColumn5 = this.treeTable.getColumnModel().getColumn(4);
        tableColumn5.setPreferredWidth(290);
        tableColumn5.setCellRenderer(new FunctionCategoryTableCellRenderer(this.outgroupFlag));
        JScrollPane jScrollPane = new JScrollPane(this.treeTable, 20, 30);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)jScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return jPanel;
    }

    private MutableTreeNode createRoot() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("root");
        if (this.searchResultGroup == null || !this.searchResultGroup.isExistSearchResult()) {
            return defaultMutableTreeNode;
        }
        Map map = this.searchResultGroup.getClusterResultMap();
        List list = this.searchResultGroup.getSearchResultClusterList();
        for (Cluster cluster : list) {
            List list2 = (List)map.get(cluster);
            ClusterTreeNode clusterTreeNode = new ClusterTreeNode(cluster, list2.size());
            defaultMutableTreeNode.add(clusterTreeNode);
            for (KeywordSearchResult keywordSearchResult : list2) {
                GeneTreeNode geneTreeNode = new GeneTreeNode(keywordSearchResult);
                clusterTreeNode.add(geneTreeNode);
            }
        }
        return defaultMutableTreeNode;
    }

    public void updateValue(boolean bl, SearchResultGroup searchResultGroup) {
        this.outgroupFlag = bl;
        this.searchResultGroup = searchResultGroup;
        MutableTreeNode mutableTreeNode = this.createRoot();
        this.treeTableModel.setRoot(mutableTreeNode);
        this.setFilterHighlightSearchResult(this.searchResultGroup.isFilterActive(), this.searchResultGroup.isColorActive());
        this.searchResultDisplayOptionPanel.notifyUpdateStatus();
    }

    public void setFilterHighlightSearchResult(boolean bl, boolean bl2) {
        this.searchResultDisplayOptionPanel.setSelectedFilterHighlight(bl, bl2);
    }

    public void setHighlightSearchResult(boolean bl) {
        this.searchResultDisplayOptionPanel.setSelectedHighlight(bl);
    }

    public void setFilterSearchResult(boolean bl) {
        this.searchResultDisplayOptionPanel.setSelectedFilter(bl);
    }

    private void exit() {
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.closeButton) {
            this.close();
        }
    }

    private void close() {
        this.exit();
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() != this.treeTable) {
            return;
        }
        if (mouseEvent.getClickCount() == 1) {
            int n = this.treeTable.getSelectedRow();
            if (n == -1) {
                return;
            }
            MutableTreeNode mutableTreeNode = (MutableTreeNode)this.treeTable.getTree().getPathForRow(n).getLastPathComponent();
            Cluster cluster = null;
            String string = null;
            String string2 = null;
            if (mutableTreeNode instanceof ClusterTreeNode) {
                cluster = ((ClusterTreeNode)mutableTreeNode).getCluster();
            } else if (mutableTreeNode instanceof GeneTreeNode) {
                cluster = ((ClusterTreeNode)mutableTreeNode.getParent()).getCluster();
                GeneTreeNode geneTreeNode = (GeneTreeNode)mutableTreeNode;
                string = geneTreeNode.getOrganismCode();
                string2 = geneTreeNode.getGeneInformation().getLocusTag();
            }
            this.mediator.selectClusterOnPPM(string, string2, cluster);
            this.mediator.setSelectClusterOnGenomeMap(cluster);
            this.mediator.selectOrthologGroupOnCoreGenome(cluster);
            this.mediator.selectOrthologGroupOnGlobalAlign(cluster);
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public List getSelectedSearchResultList() {
        return ((GeneSearchTreeTableModel)this.treeTableModel).getSelectedSearchResultList();
    }

    static {
        DIALOG_SIZE = new Dimension(600, 500);
    }
}

