/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.search;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.process.ProgressImpl;
import cgdp.recog.search.KeywordSearch;
import cgdp.recog.search.ServerKeywordSearchExecuter;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.ProgressTask;
import java.awt.Component;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;

class GeneServerSearchExecuter
extends KeywordSearch {
    private static final ApplicationLogger logger = new ApplicationLogger(GeneServerSearchExecuter.class);
    private static final int PROGRESS_DEGREE_FOR_SEARCH = 3;
    private static final int MAX_PROGRESS_FOR_SEARCH = 90;
    private static final int MAX_PROGRESS = 100;
    private static final int PROGRESS_UPDATE_INTERVAL_FOR_SEARCH = 2000;
    private Set organismCodeSet;
    private List conditionList;
    private int maxProgress = 100;

    GeneServerSearchExecuter(Component component, MediatorImpl mediatorImpl, ClusterTbl clusterTbl, Set set, List list) {
        this.setParent(component);
        this.setMediator(mediatorImpl);
        this.setClusterTbl(clusterTbl);
        this.organismCodeSet = set;
        this.conditionList = list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(ProgressImpl progressImpl) {
        ProgressTask progressTask = new ProgressTask(progressImpl, 3, this.getMaxProgress());
        progressTask.setMaxProgress(this.getMaxProgress());
        Timer timer = new Timer();
        timer.schedule((TimerTask)progressTask, 0L, 2000L);
        ServerKeywordSearchExecuter serverKeywordSearchExecuter = null;
        try {
            serverKeywordSearchExecuter = new ServerKeywordSearchExecuter(progressImpl);
            serverKeywordSearchExecuter.setClusterTbl(this.getClusterTbl());
            serverKeywordSearchExecuter.setSearchCondition(this.getClusterTbl().getClusterId(), this.organismCodeSet, this.conditionList);
            serverKeywordSearchExecuter.execute();
            if (serverKeywordSearchExecuter.isError()) {
                this.setError(true);
                this.setErrorMessage(serverKeywordSearchExecuter.getMessage());
                this.setErrorNo(serverKeywordSearchExecuter.getErrorNo());
                this.setErrorCode(serverKeywordSearchExecuter.getErrorCode());
                return;
            }
            if (progressImpl.isCanceled()) {
                this.setCancel(true);
                return;
            }
            this.setSearchResultList(serverKeywordSearchExecuter.getSearchResultList());
        }
        catch (Exception exception) {
            String string = "Fail to search genes.";
            logger.warn(string, exception);
            this.setError(true);
            if (serverKeywordSearchExecuter != null) {
                this.setErrorMessage(serverKeywordSearchExecuter.getMessage());
                this.setErrorNo(serverKeywordSearchExecuter.getErrorNo());
                this.setErrorCode(serverKeywordSearchExecuter.getErrorCode());
            } else {
                this.setErrorMessage(string);
            }
        }
        finally {
            timer.cancel();
        }
    }

    static int getDefaultMaxProgress() {
        return 100;
    }

    int getMaxProgress() {
        return this.maxProgress;
    }

    public void setMaxProgress(int n) {
        this.maxProgress = n;
    }
}

