/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.search;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.search.ClusterSearchPanel;
import cgdp.recog.search.GeneSearchPanel;
import cgdp.recog.search.KeywordSearchOptionPanel;
import cgdp.recog.util.AbstractApplyDialog;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class KeywordSearchDialog
extends AbstractApplyDialog {
    private static KeywordSearchDialog KEYWORD_SEARCH_DIALOG;
    private static final String TITLE = "Keyword Search";
    private static final String LABEL_SEARCH_BUTTON = "Search";
    private static final String LABEL_CLOSE_BUTTON = "Close";
    private static final String TAB_NAME_GENE = "Gene";
    private static final String TAB_NAME_CLUSTER = "Cluster";
    private JTabbedPane tabbedPane;
    private MediatorImpl mediator;
    private JButton showResultButton;

    private KeywordSearchDialog(Frame frame, MediatorImpl mediatorImpl) {
        super(frame);
        this.mediator = mediatorImpl;
        this.createComponents();
    }

    public static void createInstance(Frame frame, MediatorImpl mediatorImpl) {
        KEYWORD_SEARCH_DIALOG = new KeywordSearchDialog(frame, mediatorImpl);
    }

    public static KeywordSearchDialog getInstance() {
        return KEYWORD_SEARCH_DIALOG;
    }

    private void createComponents() {
        this.setTitle(TITLE);
        this.setModal(false);
        this.setApplyButtonName(LABEL_SEARCH_BUTTON);
        this.setCloseButtonName(LABEL_CLOSE_BUTTON);
        this.tabbedPane = new JTabbedPane(1);
        this.tabbedPane.add(TAB_NAME_CLUSTER, new ClusterSearchPanel(this, this.mediator));
        this.tabbedPane.add(TAB_NAME_GENE, new GeneSearchPanel(this, this.mediator));
        this.showResultButton = new JButton("Show search results");
        this.showResultButton.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this.showResultButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 10), 0, 0));
        jPanel.add((Component)this.getButtonPanel(), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.tabbedPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.getContentPane().add((Component)jPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    protected boolean check() {
        KeywordSearchOptionPanel keywordSearchOptionPanel = (KeywordSearchOptionPanel)this.tabbedPane.getSelectedComponent();
        return keywordSearchOptionPanel.check();
    }

    @Override
    protected boolean apply() {
        KeywordSearchOptionPanel keywordSearchOptionPanel = (KeywordSearchOptionPanel)this.tabbedPane.getSelectedComponent();
        return keywordSearchOptionPanel.apply();
    }

    public void updateValue(ClusterTbl clusterTbl, String string, List list) {
        ClusterSearchPanel clusterSearchPanel = (ClusterSearchPanel)this.tabbedPane.getComponentAt(0);
        clusterSearchPanel.setClusterTbl(clusterTbl);
        GeneSearchPanel geneSearchPanel = (GeneSearchPanel)this.tabbedPane.getComponentAt(1);
        geneSearchPanel.setClusterTbl(clusterTbl);
        geneSearchPanel.updateValue(string, list);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        if (actionEvent.getSource() == this.showResultButton) {
            this.mediator.showSearchResult();
        }
    }
}

