/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.search;

import cgdp.recog.data.Cluster;
import cgdp.recog.data.GeneInformation;
import cgdp.recog.info.gene.GeneInfo;
import cgdp.recog.info.gene.GeneInfoTitle;
import cgdp.recog.util.GeneUtil;
import cgdp.recog.util.StringTool;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class KeywordSearchResult {
    private boolean selected = true;
    private Cluster cluster;
    private GeneInformation geneInformation = new GeneInformation();
    private String organismCode;
    private String description;
    private String geneName;
    private String functionCategory;

    public void setCluster(Cluster cluster) {
        this.cluster = cluster;
    }

    public Cluster getCluster() {
        return this.cluster;
    }

    public GeneInformation getGeneInformation() {
        return this.geneInformation;
    }

    public GeneInfo createGeneInfoWithoutDomainNo() {
        GeneInfo geneInfo = new GeneInfo();
        geneInfo.putInfo(GeneInfoTitle.TITLE_ORGANISM_CODE, this.getOrganismCode());
        geneInfo.putInfo(GeneInfoTitle.TITLE_LOCUSTAG_SERVER, GeneUtil.removeDomainNo(this.getLocusTag()));
        return geneInfo;
    }

    public GeneInfo createGeneInfo() {
        GeneInfo geneInfo = new GeneInfo();
        geneInfo.putInfo(GeneInfoTitle.TITLE_ORGANISM_CODE, this.getOrganismCode());
        geneInfo.putInfo(GeneInfoTitle.TITLE_LOCUSTAG_SERVER, this.getLocusTag());
        return geneInfo;
    }

    public String getLocusTag() {
        return this.geneInformation.getLocusTag();
    }

    public String getLocusTagWithoutDomain() {
        return this.geneInformation.getLocusTagWithoutDomain();
    }

    public void setGeneInformation(GeneInformation geneInformation) {
        this.geneInformation = geneInformation;
    }

    public boolean equalsOrganismCode(String string) {
        if (StringTool.isNull(this.getOrganismCode()) || StringTool.isNull(string)) {
            return false;
        }
        return this.organismCode.equals(string);
    }

    public boolean equalsLocusTagWithoutDomain(String string) {
        return this.geneInformation.equalsLocusTagWithoutDomain(string);
    }

    public String getOrganismCode() {
        return this.organismCode;
    }

    public void setOrganismCode(String string) {
        this.organismCode = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getGeneName() {
        return this.geneName;
    }

    public void setGeneName(String string) {
        this.geneName = string;
    }

    public String getFunctionCategory() {
        return this.functionCategory;
    }

    public void setFunctionCategory(String string) {
        this.functionCategory = string;
    }

    public static List getClusterList(List list) {
        ArrayList<Cluster> arrayList = new ArrayList<Cluster>();
        for (KeywordSearchResult keywordSearchResult : list) {
            arrayList.add(keywordSearchResult.getCluster());
        }
        return arrayList;
    }

    public static Set getSpSet(List list) {
        HashSet<String> hashSet = new HashSet<String>();
        for (KeywordSearchResult keywordSearchResult : list) {
            hashSet.add(keywordSearchResult.getOrganismCode());
        }
        return hashSet;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
    }
}

