/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.search;

import cgdp.recog.data.Cluster;
import cgdp.recog.info.gene.GeneInfo;
import cgdp.recog.search.KeywordSearchResult;
import cgdp.recog.util.GeneUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class KeywordSearchUtil {
    private KeywordSearchUtil() {
    }

    static List getGeneInfoListWithoutDomain(List list) {
        HashSet<String> hashSet = new HashSet<String>();
        ArrayList<GeneInfo> arrayList = new ArrayList<GeneInfo>();
        for (KeywordSearchResult keywordSearchResult : list) {
            GeneInfo geneInfo = keywordSearchResult.createGeneInfoWithoutDomainNo();
            if (hashSet.contains(geneInfo.getLocusTag())) continue;
            arrayList.add(geneInfo);
            hashSet.add(geneInfo.getLocusTag());
        }
        return arrayList;
    }

    public static List getGeneInfoList(List list) {
        ArrayList<GeneInfo> arrayList = new ArrayList<GeneInfo>();
        for (KeywordSearchResult keywordSearchResult : list) {
            GeneInfo geneInfo = keywordSearchResult.createGeneInfo();
            arrayList.add(geneInfo);
        }
        return arrayList;
    }

    public static List getOrganismLocusTagList(List list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (KeywordSearchResult keywordSearchResult : list) {
            String string = keywordSearchResult.getOrganismCode();
            String string2 = keywordSearchResult.getLocusTag();
            String string3 = GeneUtil.createOrganismLocusTagKey(string, string2);
            arrayList.add(string3);
        }
        return arrayList;
    }

    public static List getOrganismLocusTagWithoutDomainList(List list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (KeywordSearchResult keywordSearchResult : list) {
            String string = keywordSearchResult.getOrganismCode();
            String string2 = keywordSearchResult.getLocusTagWithoutDomain();
            String string3 = GeneUtil.createOrganismLocusTagKey(string, string2);
            arrayList.add(string3);
        }
        return arrayList;
    }

    static List getGeneInfoListByCluster(List list) {
        ArrayList<GeneInfo> arrayList = new ArrayList<GeneInfo>();
        HashSet<String> hashSet = new HashSet<String>();
        for (KeywordSearchResult keywordSearchResult : list) {
            Cluster cluster = keywordSearchResult.getCluster();
            List list2 = cluster.getGeneInfoListWithoutDomainNo();
            for (GeneInfo geneInfo : list2) {
                String string = geneInfo.getKey();
                if (hashSet.contains(string)) continue;
                arrayList.add(geneInfo);
                hashSet.add(string);
            }
        }
        return arrayList;
    }

    static List getClusterList(List list) {
        ArrayList<Cluster> arrayList = new ArrayList<Cluster>();
        HashSet<String> hashSet = new HashSet<String>();
        for (KeywordSearchResult keywordSearchResult : list) {
            Cluster cluster = keywordSearchResult.getCluster();
            String string = cluster.getConbinedClusterId();
            if (hashSet.contains(string)) continue;
            arrayList.add(cluster);
            hashSet.add(string);
        }
        return arrayList;
    }
}

