/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.search;

import cgdp.recog.info.gene.GeneInfoFacade;
import cgdp.recog.search.SearchConditionItem;
import cgdp.recog.search.SearchJoinType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class SearchConditionAnalyzer {
    private static final int NO_SELECT = -1;
    private static final int SERVER_ONLY = 1;
    private static final int LOCAL_ONLY = 2;
    private static final int BOTH_SERVER = 3;
    private static final int BOTH_SERVER_LOCAL = 4;
    private static final int BOTH = 99;
    private List conditionList;
    private boolean executeServer = true;
    private List serverConditionList = new ArrayList();
    private List localConditionList = new ArrayList();
    private List bothServerConditionList = new ArrayList();
    private List bothLocalConditionList = new ArrayList();
    private int searchType = -1;

    public SearchConditionAnalyzer(List list, boolean bl) {
        this.conditionList = list;
        this.executeServer = bl;
    }

    public void execute() {
        if (!this.isExecuteServer()) {
            this.searchType = 2;
            this.localConditionList = this.splitOr(this.conditionList);
            return;
        }
        HashSet hashSet = new HashSet(GeneInfoFacade.getServerSearchGeneInfoTitleList());
        System.out.println("SRCHCOND:" + GeneInfoFacade.getServerSearchGeneInfoTitleList());
        this.searchType = this.getSearchLocation(this.conditionList, hashSet);
        System.err.println("srchtype=" + this.searchType);
        if (SearchConditionAnalyzer.isServerOnly(this.searchType)) {
            this.serverConditionList.add(this.conditionList);
            return;
        }
        if (SearchConditionAnalyzer.isLocalOnly(this.searchType)) {
            this.localConditionList = this.splitOr(this.conditionList);
            return;
        }
        this.analyzeBothCondition(hashSet);
    }

    private void analyzeBothCondition(Set set) {
        ArrayList<SearchConditionItem> arrayList = new ArrayList<SearchConditionItem>();
        ArrayList<SearchConditionItem> arrayList2 = new ArrayList<SearchConditionItem>();
        ArrayList<ArrayList<SearchConditionItem>> arrayList3 = new ArrayList<ArrayList<SearchConditionItem>>();
        ArrayList<ArrayList<SearchConditionItem>> arrayList4 = new ArrayList<ArrayList<SearchConditionItem>>();
        for (SearchConditionItem searchConditionItem : this.conditionList) {
            if (arrayList.isEmpty()) {
                arrayList.add(searchConditionItem);
                continue;
            }
            if (SearchJoinType.isOr(searchConditionItem.getJoinKey())) {
                int n = this.getSearchLocation(arrayList, set);
                if (SearchConditionAnalyzer.isServerOnly(n)) {
                    arrayList2.addAll(arrayList);
                } else if (SearchConditionAnalyzer.isLocalOnly(n)) {
                    arrayList3.add(arrayList);
                } else {
                    arrayList4.add(arrayList);
                }
                arrayList = new ArrayList();
            }
            arrayList.add(searchConditionItem);
        }
        if (!arrayList.isEmpty()) {
            int n = this.getSearchLocation(arrayList, set);
            if (SearchConditionAnalyzer.isServerOnly(n)) {
                arrayList2.addAll(arrayList);
            } else if (SearchConditionAnalyzer.isLocalOnly(n)) {
                arrayList3.add(arrayList);
            } else {
                arrayList4.add(arrayList);
            }
        }
        this.searchType = 3;
        this.serverConditionList.addAll(arrayList2);
        this.localConditionList.addAll(arrayList3);
        List[] listArray = this.splitBothConditionFromBoth(arrayList4, set);
        this.bothServerConditionList = listArray[0];
        this.bothLocalConditionList = listArray[1];
    }

    private List[] splitBothConditionFromBoth(List list, Set set) {
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        for (List list2 : list) {
            ArrayList<SearchConditionItem> arrayList3 = new ArrayList<SearchConditionItem>();
            ArrayList arrayList4 = new ArrayList();
            ArrayList<SearchConditionItem> arrayList5 = new ArrayList<SearchConditionItem>();
            arrayList4.add(arrayList5);
            for (SearchConditionItem searchConditionItem : list2) {
                if (set.contains(searchConditionItem.getInfoTitle())) {
                    arrayList3.add(searchConditionItem);
                    continue;
                }
                arrayList5.add(searchConditionItem);
            }
            arrayList.add(arrayList3);
            arrayList2.add(arrayList4);
        }
        return new List[]{arrayList, arrayList2};
    }

    private List splitOr(List list) {
        ArrayList arrayList = new ArrayList();
        ArrayList<SearchConditionItem> arrayList2 = new ArrayList<SearchConditionItem>();
        for (SearchConditionItem searchConditionItem : list) {
            if (arrayList2.isEmpty()) {
                arrayList2.add(searchConditionItem);
                continue;
            }
            if (SearchJoinType.isOr(searchConditionItem.getJoinKey())) {
                arrayList.add(arrayList2);
                arrayList2 = new ArrayList();
            }
            arrayList2.add(searchConditionItem);
        }
        if (!arrayList2.isEmpty()) {
            arrayList.add(arrayList2);
        }
        return arrayList;
    }

    private boolean isExecuteServer() {
        return this.executeServer;
    }

    private int getSearchLocation(List list, Set set) {
        int n = -1;
        for (SearchConditionItem searchConditionItem : list) {
            int n2;
            int n3 = n2 = set.contains(searchConditionItem.getInfoTitle()) ? 1 : 2;
            if (n == -1) {
                n = n2;
                continue;
            }
            if (n == n2) continue;
            n = 99;
            break;
        }
        return n;
    }

    public List getServerConditionList() {
        return this.serverConditionList;
    }

    public List getLocalOnlyConditionList() {
        return this.localConditionList;
    }

    public List getBothServerConditionList() {
        return this.bothServerConditionList;
    }

    public List getBothLocalConditionList() {
        return this.bothLocalConditionList;
    }

    public static boolean isServerOnly(int n) {
        return n == 1;
    }

    public static boolean isLocalOnly(int n) {
        return n == 2;
    }

    public static boolean isBothServer(int n) {
        return n == 3;
    }

    public static boolean isBothServerLocal(int n) {
        return n == 4;
    }

    public int getSearchType() {
        return this.searchType;
    }

    public boolean isServerOnly() {
        return SearchConditionAnalyzer.isServerOnly(this.getSearchType());
    }

    public boolean isLocalOnly() {
        return SearchConditionAnalyzer.isLocalOnly(this.getSearchType());
    }

    public boolean isBothServer() {
        return SearchConditionAnalyzer.isBothServer(this.getSearchType());
    }

    public boolean isBothServerLocal() {
        return SearchConditionAnalyzer.isBothServerLocal(this.getSearchType());
    }
}

