/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.search;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.option.OptionTbl;
import cgdp.recog.option.OptionValues;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.ColorLegendPanel;
import cgdp.recog.util.ColorUtil;
import cgdp.recog.util.MessageManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

class SearchResultDisplayOptionPanel
extends JPanel
implements ActionListener {
    private static final ApplicationLogger logger = new ApplicationLogger(SearchResultDisplayOptionPanel.class);
    private MediatorImpl mediator;
    private JCheckBox filterCheckBox;
    private JCheckBox highlightCheckBox;
    private ColorLegendPanel highlightColorPanel;

    SearchResultDisplayOptionPanel(MediatorImpl mediatorImpl) {
        this.mediator = mediatorImpl;
        this.init();
    }

    private void init() {
        this.filterCheckBox = new JCheckBox("Display only matched clusters.");
        this.filterCheckBox.addActionListener(this);
        this.highlightCheckBox = new JCheckBox("Highlight matched clusters.");
        this.highlightCheckBox.addActionListener(this);
        final OptionValues optionValues = OptionTbl.getInstance().getOptionValues();
        Color color = ColorUtil.str2Color(optionValues.getSearchResultColorString());
        this.highlightColorPanel = new ColorLegendPanel(color){

            @Override
            protected void afterAction() {
                String string = ColorUtil.color2Str(SearchResultDisplayOptionPanel.this.highlightColorPanel.getBackground());
                optionValues.setSearchResultColorString(string);
                SearchResultDisplayOptionPanel.this.mediator.highlightBySearchResult();
                try {
                    OptionTbl.getInstance().writeOption();
                }
                catch (Exception exception) {
                    String string2 = "Fail to save option.";
                    logger.warn(string2, exception);
                    MessageManager.showErrorMessage((Component)this, string2);
                }
            }
        };
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this.highlightCheckBox, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.highlightColorPanel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.setLayout(new GridBagLayout());
        this.add((Component)this.filterCheckBox, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)jPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    void setFilterCheckBoxLabel(String string) {
        this.filterCheckBox.setText(string);
    }

    void setHighlightCheckBoxLabel(String string) {
        this.highlightCheckBox.setText(string);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.filterCheckBox) {
            this.filterBySearchResult();
        } else if (actionEvent.getSource() == this.highlightCheckBox) {
            this.highlightBySearchResult();
        }
    }

    private void filterBySearchResult() {
        if (this.filterCheckBox.isSelected()) {
            this.mediator.filterBySearchResult();
        } else {
            this.mediator.clearFilterBySearchResult();
        }
    }

    private void highlightBySearchResult() {
        if (this.highlightCheckBox.isSelected()) {
            this.mediator.highlightBySearchResult();
        } else {
            this.mediator.clearHighlightBySearchResult();
        }
    }

    void setSelectedHighlight(boolean bl) {
        this.highlightCheckBox.removeActionListener(this);
        this.highlightCheckBox.setSelected(bl);
        this.highlightCheckBox.addActionListener(this);
    }

    void setSelectedFilter(boolean bl) {
        this.filterCheckBox.removeActionListener(this);
        this.filterCheckBox.setSelected(bl);
        this.filterCheckBox.addActionListener(this);
    }

    private boolean isHighlight() {
        return this.highlightCheckBox.isSelected();
    }

    private boolean isFilter() {
        return this.filterCheckBox.isSelected();
    }

    void setSelectedFilterHighlight(boolean bl, boolean bl2) {
        this.setSelectedHighlight(bl2);
        this.setSelectedFilter(bl);
    }

    void notifyUpdateStatus() {
        if (this.isFilter() && this.isHighlight()) {
            this.mediator.showHighlightFilterSearchResult();
        } else if (this.isFilter()) {
            this.mediator.filterBySearchResult();
        } else if (this.isHighlight()) {
            this.mediator.highlightBySearchResult();
        }
    }
}

