/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.search;

import cgdp.recog.active.ColorActivation;
import cgdp.recog.active.FilterActivation;
import cgdp.recog.data.Cluster;
import cgdp.recog.data.SuperCluster;
import cgdp.recog.info.AbstractInfoTitle;
import cgdp.recog.search.KeywordSearchResult;
import cgdp.recog.search.SearchCondition;
import cgdp.recog.util.CollectionUtil;
import cgdp.recog.util.MapUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SearchResultGroup
implements FilterActivation,
ColorActivation {
    private SearchCondition condition;
    private List searchResultList;
    private Map clusterResultMap = new HashMap();
    private boolean colorActive = false;
    private boolean filterActive = false;

    public void setSearchResultList(List list) {
        this.searchResultList = list;
        this.initClusterResultMap();
    }

    private void initClusterResultMap() {
        this.clusterResultMap.clear();
        for (KeywordSearchResult keywordSearchResult : this.searchResultList) {
            Cluster cluster = keywordSearchResult.getCluster();
            ArrayList<KeywordSearchResult> arrayList = (ArrayList<KeywordSearchResult>)this.clusterResultMap.get(cluster);
            if (arrayList == null) {
                arrayList = new ArrayList<KeywordSearchResult>();
                this.clusterResultMap.put(cluster, arrayList);
            }
            arrayList.add(keywordSearchResult);
        }
    }

    public List getSearchResultList() {
        return this.searchResultList;
    }

    public Map getClusterResultMap() {
        return this.clusterResultMap;
    }

    public List getSearchResultList(Cluster cluster) {
        if (cluster instanceof SuperCluster) {
            ArrayList arrayList = new ArrayList();
            SuperCluster superCluster = (SuperCluster)cluster;
            for (Cluster cluster2 : superCluster.getSubClusterList()) {
                List list = this.getSearchResultList(cluster2);
                if (CollectionUtil.isNull(list)) continue;
                arrayList.addAll(list);
            }
            return arrayList;
        }
        return (List)this.clusterResultMap.get(cluster);
    }

    public List getSearchResultClusterList() {
        ArrayList<Cluster> arrayList = new ArrayList<Cluster>();
        List list = this.getSearchResultList();
        for (KeywordSearchResult keywordSearchResult : list) {
            Cluster cluster = keywordSearchResult.getCluster();
            if (arrayList.contains(cluster)) continue;
            arrayList.add(cluster);
        }
        return arrayList;
    }

    public KeywordSearchResult getSearchResult(int n) {
        return (KeywordSearchResult)this.searchResultList.get(n);
    }

    public boolean isExistSearchResult() {
        return !MapUtil.isNull(this.clusterResultMap);
    }

    public void clearSearchResult() {
        this.condition = null;
        this.clusterResultMap.clear();
    }

    public boolean containsSearchResult(Cluster cluster) {
        if (cluster instanceof SuperCluster) {
            SuperCluster superCluster = (SuperCluster)cluster;
            for (Cluster cluster2 : superCluster.getSubClusterList()) {
                if (!this.containsSearchResult(cluster2)) continue;
                return true;
            }
            return false;
        }
        return this.clusterResultMap.containsKey(cluster);
    }

    public boolean containsSearchResultOrganism(Cluster cluster, String string) {
        if (cluster instanceof SuperCluster) {
            SuperCluster superCluster = (SuperCluster)cluster;
            for (Cluster cluster2 : superCluster.getSubClusterList()) {
                if (!this.containsSearchResultOrganism(cluster2, string)) continue;
                return true;
            }
            return false;
        }
        List list = (List)this.clusterResultMap.get(cluster);
        if (list == null) {
            return false;
        }
        for (KeywordSearchResult keywordSearchResult : list) {
            if (!keywordSearchResult.equalsOrganismCode(string)) continue;
            return true;
        }
        return false;
    }

    public boolean containsSearchResultGene(Cluster cluster, String string) {
        List list = (List)this.clusterResultMap.get(cluster);
        if (list == null) {
            return false;
        }
        for (KeywordSearchResult keywordSearchResult : list) {
            if (!keywordSearchResult.equalsLocusTagWithoutDomain(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isColorActive() {
        return this.colorActive;
    }

    @Override
    public void setColorActive(boolean bl) {
        this.colorActive = bl;
    }

    @Override
    public boolean isFilterActive() {
        return this.filterActive;
    }

    @Override
    public void setFilterActive(boolean bl) {
        this.filterActive = bl;
    }

    public boolean isEnableHighlightSearchResult() {
        return this.isExistSearchResult() && this.isColorActive();
    }

    public boolean isEnableFilterSearchResult() {
        return this.isExistSearchResult() && this.isFilterActive();
    }

    public boolean isShowSearchResult() {
        return this.isColorActive() || this.isFilterActive();
    }

    public boolean isCluster() {
        return this.condition.isCluster();
    }

    public boolean isGene() {
        return this.condition.isGene();
    }

    public void setCondition(SearchCondition searchCondition) {
        this.condition = searchCondition;
    }

    public SearchCondition getCondition() {
        return this.condition;
    }

    public boolean containsInfoTitle(AbstractInfoTitle abstractInfoTitle) {
        if (this.getCondition() == null) {
            return false;
        }
        return this.getCondition().containsInfoTitle(abstractInfoTitle);
    }

    @Override
    public void flipFilterActive() {
        this.setFilterActive(!this.isFilterActive());
    }

    @Override
    public void flipColorActive() {
        this.setColorActive(!this.isColorActive());
    }

    @Override
    public boolean isSyncEnable() {
        return false;
    }
}

