/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.search;

import cgdp.recog.data.Cluster;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.data.GeneInformation;
import cgdp.recog.data.GeneTbl;
import cgdp.recog.info.AbstractInfoTitle;
import cgdp.recog.info.gene.GeneInfoTitle;
import cgdp.recog.option.OptionTbl;
import cgdp.recog.process.ProgressImpl;
import cgdp.recog.search.KeywordSearchResult;
import cgdp.recog.search.KeywordSearchResultComparator;
import cgdp.recog.search.SearchConditionItem;
import cgdp.recog.system.Codec;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.GeneUtil;
import cgdp.recog.util.ServerStatus;
import cgdp.recog.util.SimpleServerConnection;
import cgdp.recog.util.StringTool;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class ServerKeywordSearchExecuter
extends SimpleServerConnection {
    private static final ApplicationLogger logger = new ApplicationLogger(ServerKeywordSearchExecuter.class);
    private ClusterTbl clusterTbl;
    private static final int COLUMN_INDEX_CLUSTID = 0;
    private static final int COLUMN_INDEX_SUBCLUSTID = 1;
    private static final int COLUMN_INDEX_DOMAIN = 2;
    private static final int COLUMN_INDEX_SP = 3;
    private static final int COLUMN_INDEX_NAME = 4;
    private static final int COLUMN_INDEX_GENE = 5;
    private static final int COLUMN_INDEX_DESCR = 6;
    private Map clusterMap;
    private List searchResultList = new ArrayList();

    public ServerKeywordSearchExecuter(ProgressImpl progressImpl) {
        this.setContextPath(OptionTbl.getInstance().getOptionValues().getGetDataUrl());
        this.setProgressImpl(progressImpl);
    }

    @Override
    public void parseOutputString(int n, String string) {
        Object object;
        if (StringTool.isNull(string)) {
            return;
        }
        if (this.isError()) {
            return;
        }
        Vector vector = StringTool.splitString(string, "\t");
        int n2 = Integer.parseInt((String)vector.get(0));
        int n3 = Integer.parseInt((String)vector.get(1));
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (n3 == 0) {
            Cluster cluster;
            int n4 = 1;
            while ((cluster = (Cluster)this.clusterMap.get(object = Cluster.conbineClusterId(n2, n4))) != null) {
                arrayList.add(cluster);
                ++n4;
            }
        } else {
            String string2 = Cluster.conbineClusterId(n2, n3);
            object = (Cluster)this.clusterMap.get(string2);
            if (object == null) {
                return;
            }
            arrayList.add(object);
        }
        String string3 = (String)vector.get(3);
        object = (String)vector.get(4);
        int n5 = Integer.parseInt((String)vector.get(2));
        String string4 = (String)vector.get(5);
        String string5 = (String)vector.get(6);
        GeneInformation geneInformation = this.getGeneInformation(arrayList, string3, (String)object, n5);
        for (Cluster cluster : arrayList) {
            KeywordSearchResult keywordSearchResult = new KeywordSearchResult();
            keywordSearchResult.setCluster(cluster);
            keywordSearchResult.setOrganismCode(string3);
            keywordSearchResult.setGeneName(string4);
            keywordSearchResult.setDescription(string5);
            keywordSearchResult.setGeneInformation(geneInformation);
            this.searchResultList.add(keywordSearchResult);
        }
    }

    private GeneInformation getGeneInformation(List list, String string, String string2, int n) {
        if (list.isEmpty()) {
            return null;
        }
        Cluster cluster = (Cluster)list.get(0);
        String string3 = string2;
        if (n != 0) {
            string3 = GeneUtil.combineLocusTagDomainNo(string2, n);
        }
        return cluster.getGeneInformation(string, string3);
    }

    public void setSearchCondition(String string, Collection collection, List list) throws UnsupportedEncodingException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("table=gene_keyword&no_header=1");
        stringBuffer.append("&fields=sp,name,gene,descr");
        if (collection != null) {
            stringBuffer.append("&key=");
            stringBuffer.append(StringTool.conbineStrList(collection, ","));
        }
        stringBuffer.append("&clust_tab_id=");
        stringBuffer.append(string);
        for (int i = 0; i < list.size(); ++i) {
            int n = i + 1;
            SearchConditionItem searchConditionItem = (SearchConditionItem)list.get(i);
            if (i != 0) {
                stringBuffer.append("&fcond");
                stringBuffer.append(n);
                stringBuffer.append("=");
                stringBuffer.append(searchConditionItem.getJoinKey());
            }
            stringBuffer.append("&field");
            stringBuffer.append(n);
            stringBuffer.append("=");
            stringBuffer.append(this.getKey(searchConditionItem.getInfoTitle()));
            stringBuffer.append("&keyword");
            stringBuffer.append(n);
            stringBuffer.append("=");
            stringBuffer.append(Codec.encode(searchConditionItem.getAdjustValue()));
        }
        logger.info("Keyword Search Options: " + stringBuffer.toString());
        this.setOptions(stringBuffer.toString());
    }

    private String getKey(AbstractInfoTitle abstractInfoTitle) {
        if (abstractInfoTitle.equals(GeneInfoTitle.TITLE_LOCUSTAG_SERVER) || abstractInfoTitle.equals(GeneInfoTitle.TITLE_LOCUS_TAG_USER)) {
            return "orf";
        }
        return abstractInfoTitle.getKey();
    }

    public void setClusterTbl(ClusterTbl clusterTbl) {
        this.clusterTbl = clusterTbl;
        this.clusterMap = this.clusterTbl.createFilteredClusterMap();
    }

    public List getSearchResultList() {
        if (this.debug) {
            this.searchResultList = this.createTestData();
        }
        if (this.isError()) {
            return new ArrayList();
        }
        Collections.sort(this.searchResultList, new KeywordSearchResultComparator());
        return this.searchResultList;
    }

    private List createTestData() {
        ArrayList<KeywordSearchResult> arrayList = new ArrayList<KeywordSearchResult>();
        try {
            ArrayList arrayList2 = new ArrayList(this.clusterTbl.getClusterList().subList(0, 20));
            HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
            for (Object object : this.clusterTbl.getViewOrganismCodeList()) {
                Object object2 = new GeneTbl((String)object);
                ((GeneTbl)object2).read();
                hashMap.put(object, object2);
            }
            int n = 0;
            for (Object object2 : arrayList2) {
                int n2 = 0;
                for (String string : ((Cluster)object2).getSpSet()) {
                    GeneTbl geneTbl = (GeneTbl)hashMap.get(string);
                    for (String string2 : ((Cluster)object2).getLocusTagList(string)) {
                        GeneInformation geneInformation = ((Cluster)object2).getGeneInformation(string, string2);
                        KeywordSearchResult keywordSearchResult = new KeywordSearchResult();
                        keywordSearchResult.setCluster((Cluster)object2);
                        keywordSearchResult.setGeneInformation(geneInformation);
                        keywordSearchResult.setOrganismCode(string);
                        arrayList.add(keywordSearchResult);
                        ++n2;
                    }
                }
            }
            logger.info("Total Count:" + n);
        }
        catch (Exception exception) {
            logger.warn("Error", exception);
        }
        Collections.sort(arrayList, new KeywordSearchResultComparator());
        return arrayList;
    }

    @Override
    protected boolean setParameter(String string) {
        if (super.setParameter(string)) {
            return true;
        }
        return ServerStatus.isParameter(string);
    }
}

