/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.search;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.project.Project;
import cgdp.recog.project.ProjectAccesser;
import cgdp.recog.search.KeywordSearchUtil;
import cgdp.recog.search.SearchResultHolder;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;

class SetRegisterPanel
extends JPanel
implements ActionListener {
    static final int TYPE_CLUSTER = 1;
    static final int TYPE_GENE = 2;
    private MediatorImpl mediator;
    private Component parent;
    private JButton registerGeneSetButton;
    private JButton registerClusterSetButton;
    private SearchResultHolder holder;
    private int type;

    SetRegisterPanel(Component component, MediatorImpl mediatorImpl, SearchResultHolder searchResultHolder, int n) {
        this.parent = component;
        this.mediator = mediatorImpl;
        this.holder = searchResultHolder;
        this.type = n;
        this.createComponents();
    }

    private void createComponents() {
        this.registerGeneSetButton = new JButton("Register gene set");
        this.registerClusterSetButton = new JButton("Register cluster set");
        this.registerGeneSetButton.addActionListener(this);
        this.registerClusterSetButton.addActionListener(this);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.registerGeneSetButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.registerClusterSetButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
    }

    private void registerGeneSet() {
        List list = this.holder.getSelectedSearchResultList();
        List list2 = new ArrayList();
        list2 = this.isCluster() ? KeywordSearchUtil.getGeneInfoListByCluster(list) : KeywordSearchUtil.getGeneInfoListWithoutDomain(list);
        Project project = ProjectAccesser.getSelectedProject();
        this.mediator.registerSetByGeneInfo(this.parent, 14, project.getProjectName(), list2);
    }

    private void registerClusterSet() {
        List list = this.holder.getSelectedSearchResultList();
        List list2 = KeywordSearchUtil.getClusterList(list);
        Project project = ProjectAccesser.getSelectedProject();
        this.mediator.registerSetByClusterList(this.parent, 11, project.getProjectName(), list2);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.registerGeneSetButton) {
            this.registerGeneSet();
        } else if (actionEvent.getSource() == this.registerClusterSetButton) {
            this.registerClusterSet();
        }
    }

    private boolean isCluster() {
        return this.type == 1;
    }

    private boolean isGene() {
        return this.type == 2;
    }
}

