/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.seq;

import cgdp.recog.data.Cluster;
import cgdp.recog.info.gene.GeneInfoUtil;
import cgdp.recog.util.CollectionUtil;
import cgdp.recog.util.StringTool;
import java.util.Collection;
import java.util.HashSet;

public class SeqDownloadCondition {
    static final String SEQTYPE_AA = "aaseq";
    static final String SEQTYPE_NT = "ntseq";
    static final String TARGET_PPM = "ppm";
    static final String TARGET_SELECT = "select";
    private String domClustId;
    private Collection clusterC;
    private Collection geneInfoC;
    private String seqType;
    private int upstream;
    private int downstream;
    private String targetType;
    private boolean specDel = false;
    private String delStr;
    private String outputFilepath;

    public String getDomClustId() {
        return this.domClustId;
    }

    public void setDomClustId(String string) {
        this.domClustId = string;
    }

    public Collection getClusterC() {
        return this.clusterC;
    }

    public String getClusterIdString() {
        HashSet<String> hashSet = new HashSet<String>();
        for (Cluster cluster : this.getClusterC()) {
            String string = cluster.getCombinedClusterIdRegardSubCluster();
            hashSet.add(string);
        }
        return StringTool.conbineStrList(hashSet, ",");
    }

    public void setClusterC(Collection collection) {
        this.clusterC = collection;
    }

    public void setGeneInfoC(Collection collection) {
        this.geneInfoC = collection;
    }

    public String getOrganismLocusTagString() {
        return GeneInfoUtil.createOrganismLocusTagString(this.getGeneInfoC());
    }

    public Collection getGeneInfoC() {
        return this.geneInfoC;
    }

    public String getSeqType() {
        return this.seqType;
    }

    public void setSeqType(String string) {
        this.seqType = string;
    }

    public int getUpstream() {
        return this.upstream;
    }

    public void setUpstream(int n) {
        this.upstream = n;
    }

    public int getDownstream() {
        return this.downstream;
    }

    public void setDownstream(int n) {
        this.downstream = n;
    }

    public void setOutputFilepath(String string) {
        this.outputFilepath = string;
    }

    public String getOutputFilepath() {
        return this.outputFilepath;
    }

    public boolean isSpecDel() {
        return this.specDel;
    }

    public void setSpecDel(boolean bl) {
        this.specDel = bl;
    }

    public String getDelStr() {
        return this.delStr;
    }

    public void setDelStr(String string) {
        this.delStr = string;
    }

    public String getTargetType() {
        return this.targetType;
    }

    public void setTargetType(String string) {
        this.targetType = string;
    }

    public boolean isTargetPPM() {
        return this.getTargetType() == TARGET_PPM;
    }

    public boolean isTargetSelect() {
        return this.getTargetType() == TARGET_SELECT;
    }

    public boolean isEachGene() {
        return !CollectionUtil.isNull(this.getGeneInfoC());
    }
}

