/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.server;

import cgdp.recog.bean.Const;
import cgdp.recog.project.ProjectAccesser;
import cgdp.recog.server.Server;
import cgdp.recog.server.ServerAccessCheckTask;
import cgdp.recog.server.ServerTbl;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.MessageManager;
import java.awt.Component;
import java.io.File;
import java.net.URL;

public class AccessServer {
    private static final ApplicationLogger logger = new ApplicationLogger(AccessServer.class);
    private static final AccessServer ACCESSSERVER = new AccessServer();
    private String serverUrl = ServerTbl.getDefaultServerHost();
    private boolean enableAccess = true;

    private AccessServer() {
        this.setServerUrl(ProjectAccesser.getSelectProjectServerUrl());
    }

    public static AccessServer getInstance() {
        return ACCESSSERVER;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public String getServerUrlWithoutHttp() {
        String string = this.serverUrl.replaceAll("http://", "");
        string = string.replaceAll("https://", "");
        return string;
    }

    public String getHost() {
        return ServerTbl.splitUrlPort(this.getServerUrl())[0];
    }

    public int getPort() {
        return Server.getPort(this.getServerUrl());
    }

    public void setServerUrl(String string) {
        if (!this.equalsServerUrl(string)) {
            ServerAccessCheckTask.getInstance().checkAccessServer(string);
        }
        this.serverUrl = string;
    }

    public boolean equalsServerUrl(String string) {
        return ServerTbl.equalsServerUrl(this.serverUrl, string);
    }

    public boolean isGlobalServerOnSelectedProject() {
        String string = AccessServer.getInstance().getServerUrl();
        return ServerTbl.isDefaultServerHost(string);
    }

    public static String getDataDir() {
        return Const.USER_DATA_DIR + File.separator + AccessServer.getServerName() + File.separator;
    }

    public static String getServerName() {
        try {
            URL uRL = new URL(AccessServer.getInstance().getServerUrl());
            String string = uRL.getHost();
            if (uRL.getPort() != -1) {
                string = string + "_" + uRL.getPort();
            }
            return string;
        }
        catch (Exception exception) {
            logger.warn("Fail to create the server name.", exception);
            return "";
        }
    }

    public boolean isEnableAccess() {
        return this.enableAccess;
    }

    public void setEnableAccess(boolean bl) {
        this.enableAccess = bl;
    }

    public static void showAccessErrorMessage(Component component) {
        MessageManager.showErrorMessage(component, AccessServer.getAccessErrorMessage());
    }

    public static String[] getAccessErrorMessage() {
        String[] stringArray = new String[]{"Can't access the recog server ( " + AccessServer.getInstance().getServerUrl() + " ). "};
        return stringArray;
    }

    public static boolean showAccessErrorMessageRetry(Component component) {
        return MessageManager.showConfirmMessage(component, AccessServer.getAccessErrorRetryMessage());
    }

    public static String[] getAccessErrorRetryMessage() {
        String[] stringArray = new String[]{"Can't access the recog server ( " + AccessServer.getInstance().getServerUrl() + " ). ", "Reconnect this server?"};
        return stringArray;
    }
}

