/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.server;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.project.ProjectAccesser;
import cgdp.recog.project.ProjectUtil;
import cgdp.recog.server.Server;
import cgdp.recog.server.ServerEditDialog;
import cgdp.recog.server.ServerTableModel;
import cgdp.recog.util.AbstractApplyDialog;
import cgdp.recog.util.CollectionUtil;
import cgdp.recog.util.MessageManager;
import cgdp.recog.util.RadioButtonCellEditor;
import cgdp.recog.util.RadioButtonCellRenderer;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;

public class ServerListDialog
extends AbstractApplyDialog {
    private static final String TITLE = "Server List";
    private static final int COLUMN_WIDTH_SELECT = 50;
    private static final int DIALOG_HEIGHT = 200;
    private MediatorImpl mediator;
    private List serverList;
    private JTable serverTable;
    private JButton addButton;
    private JButton editButton;
    private JButton deleteButton;

    public ServerListDialog(Dialog dialog, MediatorImpl mediatorImpl, List list) {
        super(dialog);
        this.mediator = mediatorImpl;
        this.serverList = new ArrayList(list);
        this.createComponents();
    }

    public ServerListDialog(Frame frame, MediatorImpl mediatorImpl, List list) {
        super(frame);
        this.mediator = mediatorImpl;
        this.serverList = new ArrayList(list);
        this.createComponents();
    }

    private void createComponents() {
        this.setTitle(TITLE);
        this.setModal(true);
        this.setResizable(false);
        this.serverTable = new JTable(new ServerTableModel(this.mediator, this.serverList));
        this.serverTable.setRowHeight(20);
        this.serverTable.setSelectionMode(0);
        ListSelectionModel listSelectionModel = this.serverTable.getSelectionModel();
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ServerListDialog.this.updateButtonState();
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.serverTable, 20, 31);
        TableColumn tableColumn = this.serverTable.getColumnModel().getColumn(1);
        tableColumn.setCellRenderer(new RadioButtonCellRenderer());
        tableColumn.setCellEditor(new RadioButtonCellEditor());
        tableColumn.setMinWidth(50);
        tableColumn.setMaxWidth(50);
        this.addButton = new JButton("Add...");
        this.addButton.addActionListener(this);
        this.editButton = new JButton("Edit...");
        this.editButton.addActionListener(this);
        this.deleteButton = new JButton("Delete");
        this.deleteButton.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this.addButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 5), 0, 0));
        jPanel.add((Component)this.editButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 5), 0, 0));
        jPanel.add((Component)this.deleteButton, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 5), 0, 0));
        jPanel.add((Component)this.getButtonPanel(), new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)jScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.getContentPane().add((Component)jPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.updateButtonState();
        this.pack();
        this.setSize(new Dimension(this.getSize().width, 200));
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    protected boolean apply() {
        return true;
    }

    private ServerTableModel getServerTableModel() {
        return (ServerTableModel)this.serverTable.getModel();
    }

    private void updateButtonState() {
        if (this.serverTable.getSelectedRowCount() > 0) {
            this.deleteButton.setEnabled(true);
            this.editButton.setEnabled(true);
        } else {
            this.deleteButton.setEnabled(false);
            this.editButton.setEnabled(false);
        }
    }

    public Server getTargetServer() {
        Server server = null;
        for (Server server2 : this.serverList) {
            if (!server2.isSelect()) continue;
            server = server2;
            break;
        }
        return server;
    }

    public List getServerList() {
        return this.serverList;
    }

    private void add() {
        Server server = new Server();
        ServerEditDialog serverEditDialog = new ServerEditDialog((Dialog)this, server, true);
        serverEditDialog.setVisible(true);
        if (!serverEditDialog.isCanceled()) {
            server.setUrl(serverEditDialog.getUrlPort());
            this.getServerTableModel().addServer(server);
            this.updateButtonState();
        }
        serverEditDialog.dispose();
    }

    private void edit() {
        Server server = this.getSelectedServer();
        ServerEditDialog serverEditDialog = new ServerEditDialog((Dialog)this, server, false);
        serverEditDialog.setVisible(true);
        if (!serverEditDialog.isCanceled()) {
            String string = server.getUrl();
            server.setUrl(serverEditDialog.getUrlPort());
            if (ProjectAccesser.containsServer(string)) {
                Server server2 = new Server();
                server2.setUrl(string);
                this.getServerTableModel().addServer(server2);
            }
            this.updateButtonState();
        }
        serverEditDialog.dispose();
    }

    private void delete() {
        Server server = this.getSelectedServer();
        List list = ProjectAccesser.getProjectListUsedServer(server);
        if (!CollectionUtil.isNull(list)) {
            String[] stringArray = new String[]{"Can't delete the server URL because it is used by the following projects:", " " + ProjectUtil.getProjectNameString(list)};
            MessageManager.showMessage((Component)this, stringArray);
            return;
        }
        if (!MessageManager.showConfirmMessage((Component)this, "Delete server [" + server.getUrl() + "]?")) {
            return;
        }
        this.getServerTableModel().removeServer(server);
        if (server.isSelect()) {
            Server server2 = (Server)this.serverList.get(0);
            server2.setSelect(true);
        }
        this.updateButtonState();
    }

    Server getSelectedServer() {
        int n = this.serverTable.getSelectedRow();
        return this.getServerTableModel().getServer(n);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        if (actionEvent.getSource() == this.addButton) {
            this.add();
        } else if (actionEvent.getSource() == this.editButton) {
            this.edit();
        } else if (actionEvent.getSource() == this.deleteButton) {
            this.delete();
        }
    }
}

