/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.server;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.server.Server;
import cgdp.recog.server.ServerComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.table.AbstractTableModel;

class ServerTableModel
extends AbstractTableModel {
    private static String[] COLUMN_NAMES = new String[]{"Name", "Select"};
    private MediatorImpl mediator;
    private List serverList = new ArrayList();

    ServerTableModel(MediatorImpl mediatorImpl, List list) {
        this.mediator = mediatorImpl;
        this.serverList = list;
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    @Override
    public String getColumnName(int n) {
        return COLUMN_NAMES[n];
    }

    @Override
    public int getRowCount() {
        return this.serverList.size();
    }

    public Class getColumnClass(int n) {
        if (n == 1) {
            return Boolean.class;
        }
        return String.class;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        Server server = (Server)this.serverList.get(n);
        if (n2 == 0) {
            return server.getUrl();
        }
        if (n2 == 1) {
            return new Boolean(server.isSelect());
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (n2 == 1) {
            return !this.mediator.isExistDomClustResult();
        }
        return false;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        Server server = (Server)this.serverList.get(n);
        if (n2 == 1) {
            this.clearSelect();
            boolean bl = (Boolean)object;
            server.setSelect(bl);
            this.fireTableRowsUpdated(0, this.getRowCount());
        }
    }

    private void clearSelect() {
        for (Server server : this.serverList) {
            server.setSelect(false);
        }
    }

    List getServerList() {
        return this.serverList;
    }

    void addServer(Server server) {
        this.serverList.add(server);
        Collections.sort(this.serverList, new ServerComparator());
        this.fireTableRowsInserted(0, this.getRowCount() - 1);
    }

    void removeServer(Server server) {
        this.serverList.remove(server);
        this.fireTableDataChanged();
    }

    Server getServer(int n) {
        if (n < 0 || n >= this.getRowCount()) {
            return null;
        }
        return (Server)this.serverList.get(n);
    }
}

