/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.set;

import cgdp.recog.data.Cluster;
import cgdp.recog.info.LocationType;
import cgdp.recog.set.AbstractElementSetStatus;
import cgdp.recog.set.ElementSetComparator;
import cgdp.recog.set.SetType;
import cgdp.recog.util.CollectionUtil;
import cgdp.recog.util.FileUtil;
import cgdp.recog.util.StringTool;
import edu.emory.mathcs.backport.java.util.Collections;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractElementSet {
    private String id;
    private String name;
    private String listFilename;
    private int setType;
    private String location = "No Location";
    private int elementCount;
    private List elementList = new ArrayList();
    private Map elementMap = new HashMap();
    private int status = 0;

    public AbstractElementSet() {
        this.initId();
    }

    private void initId() {
        this.setId(String.valueOf(System.currentTimeMillis()));
        try {
            Thread.sleep(1L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getListFilename() {
        return this.listFilename;
    }

    public void setListFilename(String string) {
        this.listFilename = string;
    }

    public void newListFilename() {
        this.setListFilename(String.valueOf(System.currentTimeMillis()));
        try {
            Thread.sleep(1L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public boolean isExistListFilename() {
        return !StringTool.isNull(this.getListFilename());
    }

    public boolean isNewElement() {
        return !this.isExistListFilename();
    }

    public int getSetType() {
        return this.setType;
    }

    public boolean isGeneSet() {
        return SetType.isGeneSet(this.getSetType());
    }

    public boolean isClusterSet() {
        return SetType.isClusterSet(this.getSetType());
    }

    public void setSetType(int n) {
        this.setType = n;
    }

    public String getLocation() {
        return this.location;
    }

    public boolean isGlobalLocation() {
        return LocationType.isNameGlobal(this.getLocation());
    }

    public void setLocation(String string) {
        this.location = string;
    }

    public abstract String getFilepath();

    public String getKey() {
        return this.getName() + ":" + this.getLocation();
    }

    public boolean equalsElement(AbstractElementSet abstractElementSet) {
        return this.equalsName(abstractElementSet) && this.equalsLocation(abstractElementSet.getLocation()) && this.getSetType() == abstractElementSet.getSetType();
    }

    public int getHashCode() {
        int n = 1;
        n = n * 31 + this.getName().hashCode();
        if (this.getLocation() != null) {
            n = n * 31 + this.getLocation().hashCode();
        }
        n = n * 31 + new Integer(this.getSetType()).hashCode();
        return n;
    }

    public boolean equalsName(AbstractElementSet abstractElementSet) {
        if (abstractElementSet == null) {
            return false;
        }
        return this.equalsName(abstractElementSet.getName());
    }

    public boolean equalsName(String string) {
        if (StringTool.isNull(string) || StringTool.isNull(this.getName())) {
            return false;
        }
        return this.getName().equals(string);
    }

    public boolean equalsLocation(String string) {
        if (StringTool.isNull(string) || StringTool.isNull(this.getLocation())) {
            return false;
        }
        return this.getLocation().equals(string);
    }

    private AbstractElementSet getSameElementSet(List list) {
        AbstractElementSet abstractElementSet = null;
        for (AbstractElementSet abstractElementSet2 : list) {
            if (!abstractElementSet2.equalsElement(this)) continue;
            abstractElementSet = abstractElementSet2;
            break;
        }
        return abstractElementSet;
    }

    public void margeElementSet(List list) {
        AbstractElementSet abstractElementSet = this.getSameElementSet(list);
        if (abstractElementSet != null) {
            Collections.replaceAll(list, abstractElementSet, this);
            FileUtil.delete(abstractElementSet.getFilepath());
        } else {
            list.add(this);
            Collections.sort(list, new ElementSetComparator());
        }
    }

    public boolean isSameNameGlobal(AbstractElementSet abstractElementSet) {
        if (abstractElementSet == null) {
            return false;
        }
        if (abstractElementSet.equalsLocation(this.getLocation()) || LocationType.isNameGlobal(this.getLocation()) && !LocationType.isNameGlobal(abstractElementSet.getLocation()) || !LocationType.isNameGlobal(this.getLocation()) && LocationType.isNameGlobal(abstractElementSet.getLocation())) {
            if (StringTool.isNull(this.getLocation()) || StringTool.isNull(abstractElementSet.getLocation())) {
                return false;
            }
            return abstractElementSet.equalsName(this.getName());
        }
        return false;
    }

    public int getElementSize() {
        return this.elementCount;
    }

    public void setElementSize(int n) {
        this.elementCount = n;
    }

    public int getElementListSize() {
        return this.elementList.size();
    }

    public List getElementList() {
        return this.elementList;
    }

    public void setElementList(List list) {
        this.elementList = list;
        this.setElementSize(list.size());
        this.updateElementMap();
    }

    public abstract void addElementList(Collection var1);

    public void clearElementList() {
        this.elementList.clear();
        this.elementMap.clear();
        this.setElementSize(0);
    }

    public boolean isExistElement() {
        return !CollectionUtil.isNull(this.getElementList());
    }

    public abstract boolean contains(Cluster var1);

    public abstract boolean contains(Cluster var1, String var2);

    public abstract boolean contains(String var1, String var2);

    public abstract void updateElementList();

    protected Map getElementMap() {
        return this.elementMap;
    }

    protected void setElementMap(Map map) {
        this.elementMap = map;
    }

    protected Object getElement(String string) {
        return this.getElementMap().get(string);
    }

    protected abstract void updateElementMap();

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int n) {
        this.status = n;
    }

    public void addStatus(int n) {
        this.status |= n;
    }

    public boolean isNormal() {
        return AbstractElementSetStatus.isNormal(this.getStatus());
    }

    public boolean isNew() {
        return AbstractElementSetStatus.isNew(this.getStatus());
    }

    public boolean isEditName() {
        return AbstractElementSetStatus.isEditName(this.getStatus());
    }

    public boolean isEditLocation() {
        return AbstractElementSetStatus.isEditLocation(this.getStatus());
    }

    public boolean isEditList() {
        return AbstractElementSetStatus.isEditList(this.getStatus());
    }

    public boolean isAddList() {
        return AbstractElementSetStatus.isAddList(this.getStatus());
    }

    public void setNormal() {
        this.setStatus(0);
    }

    public void setNew() {
        this.setStatus(16);
    }

    public void addEditName() {
        this.addStatus(256);
    }

    public void addEditList() {
        this.addStatus(65536);
    }

    public void addEditLocation() {
        this.addStatus(4096);
    }

    public void addAddList() {
        this.addStatus(0x100000);
    }

    public abstract AbstractElementSet intersect(AbstractElementSet var1);

    public abstract AbstractElementSet subtract(AbstractElementSet var1);
}

