/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.set;

import cgdp.recog.set.ElementSetGroup;
import cgdp.recog.set.ElementSetGroupTableModel;
import cgdp.recog.util.AbstractApplyDialog;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class CombinationEditDialog
extends AbstractApplyDialog {
    private static final String TITLE = "Edit condition";
    private JTable elementSetTable;
    private JButton flipNotButton;
    private JButton deleteButton;
    private ElementSetGroup elementSetGroup;

    CombinationEditDialog(Dialog dialog) {
        super(dialog);
        this.createComponents();
    }

    private void createComponents() {
        this.setTitle(TITLE);
        this.setModal(true);
        this.setResizable(true);
        this.elementSetTable = new JTable(new ElementSetGroupTableModel());
        this.elementSetTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                CombinationEditDialog.this.setEnableButton();
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.elementSetTable, 20, 30);
        jScrollPane.getViewport().setPreferredSize(new Dimension(200, 150));
        this.flipNotButton = new JButton("Flip Not");
        this.deleteButton = new JButton("Delete");
        this.flipNotButton.addActionListener(this);
        this.deleteButton.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this.flipNotButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.deleteButton, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)jScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(10, 15, 0, 0), 0, 0));
        this.getContentPane().add((Component)jPanel, new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 17, 1, new Insets(10, 10, 0, 15), 0, 0));
        this.getContentPane().add((Component)this.getButtonPanel(), new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 0, new Insets(15, 15, 15, 15), 0, 0));
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    public void updateValue(ElementSetGroup elementSetGroup) {
        this.elementSetGroup = elementSetGroup;
        this.getElementSetGroupTableModel().setElementSetGroup((ElementSetGroup)elementSetGroup.clone());
        this.setEnableButton();
    }

    private ElementSetGroupTableModel getElementSetGroupTableModel() {
        return (ElementSetGroupTableModel)this.elementSetTable.getModel();
    }

    private void setEnableButton() {
        int n = this.elementSetTable.getSelectedRow();
        this.deleteButton.setEnabled(n != -1);
        this.flipNotButton.setEnabled(n != -1);
    }

    private void flipNot() {
        int[] nArray = this.elementSetTable.getSelectedRows();
        if (nArray == null || nArray.length == 0) {
            return;
        }
        this.getElementSetGroupTableModel().flipNot(nArray);
    }

    private void delete() {
        int[] nArray = this.elementSetTable.getSelectedRows();
        if (nArray == null || nArray.length == 0) {
            return;
        }
        this.getElementSetGroupTableModel().delete(nArray);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        if (actionEvent.getSource() == this.deleteButton) {
            this.delete();
        } else if (actionEvent.getSource() == this.flipNotButton) {
            this.flipNot();
        }
    }

    public ElementSetGroup getElementSetGroup() {
        return this.getElementSetGroupTableModel().getElementSetGroup();
    }

    @Override
    protected boolean apply() {
        return true;
    }
}

