/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.set;

import cgdp.recog.active.ColorActivation;
import cgdp.recog.active.FilterActivation;
import cgdp.recog.controltree.NodeLabel;
import cgdp.recog.data.Cluster;
import cgdp.recog.set.AbstractElementSet;
import cgdp.recog.set.SetCondition;
import cgdp.recog.util.CollectionUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ElementSetGroup
implements FilterActivation,
ColorActivation,
NodeLabel,
Cloneable {
    private List elementSetList = new ArrayList();
    private Map notMap = new HashMap();
    private Color color = Color.red;
    private boolean activeColor = true;
    private boolean activeFilter = true;
    private SetCondition setCondition;

    public ElementSetGroup() {
    }

    public ElementSetGroup(AbstractElementSet abstractElementSet) {
        this(abstractElementSet, false);
    }

    public ElementSetGroup(AbstractElementSet abstractElementSet, boolean bl) {
        this.addElementSet(abstractElementSet, bl);
    }

    public ElementSetGroup(List list) {
        this(list, false);
    }

    public ElementSetGroup(List list, boolean bl) {
        this.setElementSetList(list, bl);
    }

    @Override
    public String getLabel() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.elementSetList.size(); ++i) {
            AbstractElementSet abstractElementSet = (AbstractElementSet)this.elementSetList.get(i);
            if (this.isNot(abstractElementSet)) {
                stringBuffer.append("! ");
            }
            stringBuffer.append(abstractElementSet.getName());
            if (i == this.elementSetList.size() - 1) continue;
            stringBuffer.append(" & ");
        }
        return stringBuffer.toString();
    }

    public boolean isNot(AbstractElementSet abstractElementSet) {
        if (this.notMap.containsKey(abstractElementSet.getKey())) {
            return (Boolean)this.notMap.get(abstractElementSet.getKey());
        }
        return false;
    }

    public void addElementSet(AbstractElementSet abstractElementSet, boolean bl) {
        if (!this.elementSetList.contains(abstractElementSet)) {
            this.elementSetList.add(abstractElementSet);
            this.setNotMap(abstractElementSet, bl);
        }
    }

    public void setElementSetList(List list) {
        this.setElementSetList(list, false);
    }

    public void setElementSetList(List list, boolean bl) {
        this.elementSetList = new ArrayList(list);
        this.notMap.clear();
        this.setNotMap(list, bl);
    }

    public void flipNot() {
        Iterator iterator = this.getElementSetList().iterator();
        while (iterator.hasNext()) {
            AbstractElementSet abstractElementSet;
            this.setNotMap(abstractElementSet, !this.isNot(abstractElementSet = (AbstractElementSet)iterator.next()));
        }
    }

    public void setNotMap(AbstractElementSet abstractElementSet, boolean bl) {
        HashSet<AbstractElementSet> hashSet = new HashSet<AbstractElementSet>();
        hashSet.add(abstractElementSet);
        this.setNotMap(hashSet, bl);
    }

    public void setNotMap(Collection collection, boolean bl) {
        for (AbstractElementSet abstractElementSet : collection) {
            this.notMap.put(abstractElementSet.getKey(), new Boolean(bl));
        }
    }

    public List getElementSetList() {
        return this.elementSetList;
    }

    public List getPositiveElementSetList() {
        ArrayList<AbstractElementSet> arrayList = new ArrayList<AbstractElementSet>();
        for (AbstractElementSet abstractElementSet : this.elementSetList) {
            if (this.isNot(abstractElementSet)) continue;
            arrayList.add(abstractElementSet);
        }
        return arrayList;
    }

    public List getNegativeElementSetList() {
        ArrayList<AbstractElementSet> arrayList = new ArrayList<AbstractElementSet>();
        for (AbstractElementSet abstractElementSet : this.elementSetList) {
            if (!this.isNot(abstractElementSet)) continue;
            arrayList.add(abstractElementSet);
        }
        return arrayList;
    }

    public List getMatchElementList() {
        List list = this.getPositiveElementSetList();
        if (CollectionUtil.isNull(list)) {
            return null;
        }
        AbstractElementSet abstractElementSet = (AbstractElementSet)list.get(0);
        for (int i = 1; i < list.size(); ++i) {
            AbstractElementSet abstractElementSet2 = (AbstractElementSet)list.get(i);
            if ((abstractElementSet = abstractElementSet.intersect(abstractElementSet2)).isExistElement()) continue;
            return new ArrayList();
        }
        List list2 = this.getNegativeElementSetList();
        for (int i = 0; i < list2.size(); ++i) {
            AbstractElementSet abstractElementSet3 = (AbstractElementSet)list2.get(i);
            if ((abstractElementSet = abstractElementSet.subtract(abstractElementSet3)).isExistElement()) continue;
            return new ArrayList();
        }
        return abstractElementSet.getElementList();
    }

    public AbstractElementSet getElementSet(int n) {
        return (AbstractElementSet)this.elementSetList.get(n);
    }

    public int getElementSetCount() {
        return this.elementSetList.size();
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    @Override
    public void flipFilterActive() {
        this.setFilterActive(!this.isFilterActive());
        if (this.isSyncEnable()) {
            this.activeColor = this.isFilterActive();
        }
    }

    @Override
    public boolean isFilterActive() {
        return this.activeFilter;
    }

    @Override
    public void setFilterActive(boolean bl) {
        this.activeFilter = bl;
        if (this.isSyncEnable()) {
            this.activeColor = bl;
        }
    }

    @Override
    public void flipColorActive() {
        this.setColorActive(!this.isColorActive());
        if (this.isSyncEnable()) {
            this.activeFilter = this.isColorActive();
        }
    }

    @Override
    public boolean isColorActive() {
        return this.activeColor;
    }

    @Override
    public void setColorActive(boolean bl) {
        this.activeColor = bl;
        if (this.isSyncEnable()) {
            this.activeFilter = bl;
        }
    }

    private Map getNoMap() {
        return this.notMap;
    }

    public boolean equalsGroup(ElementSetGroup elementSetGroup) {
        if (this.getElementSetCount() != elementSetGroup.getElementSetCount()) {
            return false;
        }
        for (AbstractElementSet abstractElementSet : this.getElementSetList()) {
            boolean bl = false;
            for (AbstractElementSet abstractElementSet2 : elementSetGroup.getElementSetList()) {
                if (!abstractElementSet.equalsElement(abstractElementSet2)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    public boolean equalsGroupCondition(ElementSetGroup elementSetGroup) {
        if (!this.equalsGroup(elementSetGroup)) {
            return false;
        }
        return ((Object)this.getNoMap()).equals(elementSetGroup.getNoMap());
    }

    public int getHashCode() {
        int n = 1;
        for (AbstractElementSet abstractElementSet : this.getElementSetList()) {
            n = n * 31 + abstractElementSet.getHashCode();
        }
        return n;
    }

    public boolean isMatch(Cluster cluster) {
        for (AbstractElementSet abstractElementSet : this.getElementSetList()) {
            if (!abstractElementSet.contains(cluster) && !this.isNot(abstractElementSet)) {
                return false;
            }
            if (!abstractElementSet.contains(cluster) || !this.isNot(abstractElementSet)) continue;
            return false;
        }
        return true;
    }

    public boolean isMatch(Collection collection) {
        for (Cluster cluster : collection) {
            if (!this.isMatch(cluster)) continue;
            return true;
        }
        return false;
    }

    public boolean isMatch(Cluster cluster, String string) {
        for (AbstractElementSet abstractElementSet : this.getElementSetList()) {
            boolean bl = abstractElementSet.contains(cluster, string);
            if (!bl && !this.isNot(abstractElementSet)) {
                return false;
            }
            if (!bl || !this.isNot(abstractElementSet)) continue;
            return false;
        }
        return true;
    }

    public boolean isMatch(String string, String string2) {
        for (AbstractElementSet abstractElementSet : this.getElementSetList()) {
            boolean bl = abstractElementSet.contains(string, string2);
            if (bl && this.isNot(abstractElementSet)) {
                return false;
            }
            if (bl || this.isNot(abstractElementSet)) continue;
            return false;
        }
        return true;
    }

    public boolean containsElementSet(AbstractElementSet abstractElementSet) {
        AbstractElementSet abstractElementSet2 = this.find(abstractElementSet);
        return abstractElementSet2 != null;
    }

    public boolean containsElementSet(Collection collection) {
        for (AbstractElementSet abstractElementSet : collection) {
            if (!this.containsElementSet(abstractElementSet)) continue;
            return true;
        }
        return false;
    }

    public void updateElementList() {
        for (AbstractElementSet abstractElementSet : this.elementSetList) {
            abstractElementSet.updateElementList();
        }
    }

    private AbstractElementSet find(AbstractElementSet abstractElementSet) {
        for (AbstractElementSet abstractElementSet2 : this.getElementSetList()) {
            if (!abstractElementSet2.equalsElement(abstractElementSet)) continue;
            return abstractElementSet2;
        }
        return null;
    }

    public void removeElementSet(Collection collection) {
        HashSet<AbstractElementSet> hashSet = new HashSet<AbstractElementSet>();
        for (AbstractElementSet abstractElementSet : collection) {
            AbstractElementSet abstractElementSet2 = this.find(abstractElementSet);
            if (abstractElementSet2 == null) continue;
            hashSet.add(abstractElementSet2);
        }
        this.elementSetList.removeAll(hashSet);
        for (AbstractElementSet abstractElementSet : hashSet) {
            this.notMap.remove(abstractElementSet.getKey());
        }
    }

    public boolean isExistElemetSet() {
        return !CollectionUtil.isNull(this.getElementSetList());
    }

    public SetCondition getSetCondition() {
        return this.setCondition;
    }

    public void setSetCondition(SetCondition setCondition) {
        this.setCondition = setCondition;
    }

    public void clearSetCondition() {
        this.setCondition = null;
    }

    @Override
    public boolean isSyncEnable() {
        return this.setCondition != null && this.setCondition.isSyncEnable();
    }

    public Object clone() {
        ElementSetGroup elementSetGroup = new ElementSetGroup();
        elementSetGroup.elementSetList = new ArrayList(this.getElementSetList());
        elementSetGroup.color = this.getColor();
        elementSetGroup.notMap = new HashMap(this.notMap);
        elementSetGroup.activeFilter = this.isFilterActive();
        elementSetGroup.activeColor = this.isColorActive();
        return elementSetGroup;
    }
}

