/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.set;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.project.Project;
import cgdp.recog.project.ProjectAccesser;
import cgdp.recog.set.AbstractElementSet;
import cgdp.recog.set.AbstractElementSetFacade;
import cgdp.recog.set.AbstractSetCombinationModel;
import cgdp.recog.set.SetType;
import cgdp.recog.set.cluster.ClusterSet;
import cgdp.recog.set.gene.GeneSet;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JPanel;

public class SetCombinationControlButtonPanel
extends JPanel
implements ActionListener {
    private Component parent;
    private MediatorImpl mediator;
    private ClusterTbl clusterTbl;
    private AbstractSetCombinationModel abstractSetCombinationModel;
    private JButton infoListButton;
    private JButton setButton;
    private JButton exportButton;

    public SetCombinationControlButtonPanel(Component component, MediatorImpl mediatorImpl, AbstractSetCombinationModel abstractSetCombinationModel) {
        this.parent = component;
        this.mediator = mediatorImpl;
        this.abstractSetCombinationModel = abstractSetCombinationModel;
        this.createComponents();
    }

    private void createComponents() {
        this.setButton = new JButton("Create gene set...");
        this.setButton.addActionListener(this);
        this.infoListButton = new JButton("Property...");
        this.infoListButton.addActionListener(this);
        this.exportButton = new JButton("Save Data...");
        this.exportButton.addActionListener(this);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.infoListButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.add((Component)this.setButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.add((Component)this.exportButton, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
    }

    public void updateValue(ClusterTbl clusterTbl) {
        this.clusterTbl = clusterTbl;
        this.infoListButton.setText(SetCombinationControlButtonPanel.getInfoListButtonLabel(this.abstractSetCombinationModel.getSetType()));
        this.setButton.setText(SetCombinationControlButtonPanel.getCreateSetButtonLabel(this.abstractSetCombinationModel.getSetType()));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.infoListButton) {
            List list = this.abstractSetCombinationModel.getElementList(this.clusterTbl);
            AbstractElementSetFacade.showInfoListDialog(this.parent, this.mediator, this.clusterTbl, this.abstractSetCombinationModel.getSetType(), list);
        } else if (actionEvent.getSource() == this.exportButton) {
            this.export();
        } else if (actionEvent.getSource() == this.setButton) {
            List list = this.abstractSetCombinationModel.getElementList(this.clusterTbl);
            if (!AbstractElementSetFacade.validateExistElementList(this.parent, this.abstractSetCombinationModel.getSetType(), list)) {
                return;
            }
            Project project = ProjectAccesser.getSelectedProject();
            if (SetType.isGeneSet(this.abstractSetCombinationModel.getSetType())) {
                this.mediator.registerSetByGeneInfo(this.parent, 14, project.getProjectName(), list);
            } else {
                this.mediator.registerSetByClusterList(this.parent, 11, project.getProjectName(), list);
            }
        }
    }

    private void export() {
        Map map = this.abstractSetCombinationModel.getElementListMap(this.clusterTbl);
        ArrayList arrayList = new ArrayList();
        Object object = map.values().iterator();
        while (object.hasNext()) {
            arrayList.addAll((List)object.next());
        }
        object = null;
        object = this.abstractSetCombinationModel.isGeneSet() ? new GeneSet() : new ClusterSet();
        ((AbstractElementSet)object).setElementList(arrayList);
        Map map2 = AbstractElementSetFacade.createSetBitsInfoMap(this.abstractSetCombinationModel.getSetType(), this.abstractSetCombinationModel.getElementSetList(), map);
        if (!AbstractElementSetFacade.validateExistElementList(this.parent, ((AbstractElementSet)object).getSetType(), ((AbstractElementSet)object).getElementList())) {
            return;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string = AbstractElementSetFacade.createElementSetNameString(this.abstractSetCombinationModel.getElementSetList());
        hashMap.put("venn_bit_pattern", string);
        this.mediator.export((AbstractElementSet)object, map2, hashMap);
    }

    private static String getInfoListButtonLabel(int n) {
        if (SetType.isClusterSet(n)) {
            return "Cluster List";
        }
        return "Gene List";
    }

    private static String getCreateSetButtonLabel(int n) {
        if (SetType.isClusterSet(n)) {
            return "Create cluster set...";
        }
        return "Create gene set...";
    }
}

