/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.set;

import cgdp.recog.set.AbstractElementSet;
import cgdp.recog.set.ElementSetGroup;
import cgdp.recog.set.SetCondition;
import cgdp.recog.set.SetType;
import cgdp.recog.set.cluster.ClusterSet;
import cgdp.recog.set.cluster.ClusterSetCondition;
import cgdp.recog.set.cluster.ClusterSetFacade;
import cgdp.recog.set.gene.GeneSet;
import cgdp.recog.set.gene.GeneSetCondition;
import cgdp.recog.set.gene.GeneSetFacade;
import cgdp.recog.util.ColorUtil;
import cgdp.recog.util.FileImporter;
import cgdp.recog.util.StringTool;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Vector;

class SetConditionGroupImporter
extends FileImporter {
    private static final String TITLE_SET_CONDITION = "SetCondition";
    private static final String TITLE_ELEMENT_SET_GROUP = "ElementSetGroup";
    private static final String KEY_SET_TYPE = "#SetType";
    private static final String KEY_NAME = "#Name";
    private static final String KEY_NO_MATCH_COLOR = "#NoMatchColor";
    private static final String KEY_SYNC_ENABLE = "#SyncEnable";
    private static final String KEY_COMBINATION = "#Combination";
    private static final String KEY_COLOR = "#Color";
    private static final String KEY_ACTIVE_COLOR = "#ActiveColor";
    private static final String KEY_ACTIVE_FILTER = "#ActiveFilter";
    private static final String KEY_ELEMENT_SET = "#ElementSet";
    private static final String KEY_ELEMENT_SET_NOT_CONDITION = "#ElementSetNot";
    private static final String DELIMTER = "\t";
    private static final String DELIMTER_ELEMENT_SET = ",";
    private static final String SEP_SET_CONDITION = "////";
    private static final String SEP_ELEMENT_SET_GROUP = "//";
    private String filepath;
    private Map geneSetMap;
    private Map clusterSetMap;
    private List setConditionList = new ArrayList();
    private SetCondition setCondition;
    private ElementSetGroup elementSetGroup;

    SetConditionGroupImporter(String string) {
        this.filepath = string;
        this.geneSetMap = GeneSetFacade.createNameElementSetMap();
        this.clusterSetMap = ClusterSetFacade.createNameElementSetMap();
        this.setExistHeader(false);
    }

    @Override
    protected String getFilepath() {
        return this.filepath;
    }

    @Override
    protected void parseDataLine(int n, String string) {
        if (string.startsWith(KEY_SET_TYPE)) {
            int n2 = Integer.parseInt(this.getValue(KEY_SET_TYPE, string));
            this.setCondition = this.createSetCondition(n2);
        } else if (string.startsWith(KEY_NAME)) {
            String string2 = this.getValue(KEY_NAME, string);
            this.setCondition.setName(string2);
        } else if (string.startsWith(KEY_NO_MATCH_COLOR)) {
            Color color = ColorUtil.str2Color(this.getValue(KEY_NO_MATCH_COLOR, string));
            this.setCondition.setNoMatchColor(color);
        } else if (string.startsWith(KEY_SYNC_ENABLE)) {
            boolean bl = false;
            this.setCondition.setSyncEnable(bl);
        } else if (string.startsWith(KEY_COMBINATION)) {
            boolean bl = new Boolean(this.getValue(KEY_COMBINATION, string));
            this.setCondition.setCombination(bl);
        } else if (string.startsWith(TITLE_ELEMENT_SET_GROUP)) {
            this.elementSetGroup = new ElementSetGroup();
        } else if (string.startsWith(KEY_COLOR)) {
            Color color = ColorUtil.str2Color(this.getValue(KEY_COLOR, string));
            this.elementSetGroup.setColor(color);
        } else if (string.startsWith(KEY_ACTIVE_COLOR)) {
            boolean bl = new Boolean(this.getValue(KEY_ACTIVE_COLOR, string));
            this.elementSetGroup.setColorActive(bl);
        } else if (string.startsWith(KEY_ACTIVE_FILTER)) {
            boolean bl = new Boolean(this.getValue(KEY_ACTIVE_FILTER, string));
            this.elementSetGroup.setFilterActive(bl);
        } else if (string.startsWith(KEY_ELEMENT_SET_NOT_CONDITION)) {
            Vector vector = StringTool.splitString(this.getValue(KEY_ELEMENT_SET_NOT_CONDITION, string), DELIMTER_ELEMENT_SET);
            if (vector.size() == this.elementSetGroup.getElementSetCount()) {
                int n3 = 0;
                for (AbstractElementSet abstractElementSet : this.elementSetGroup.getElementSetList()) {
                    boolean bl = new Boolean((String)vector.get(n3));
                    this.elementSetGroup.setNotMap(abstractElementSet, bl);
                    ++n3;
                }
            }
        } else if (string.startsWith(KEY_ELEMENT_SET)) {
            Vector vector = StringTool.splitString(this.getValue(KEY_ELEMENT_SET, string), DELIMTER_ELEMENT_SET);
            List list = this.getElementSetList(vector);
            this.elementSetGroup.setElementSetList(list);
        } else if (string.equals(SEP_ELEMENT_SET_GROUP)) {
            this.setCondition.addElementSetGroup(this.elementSetGroup);
        } else if (string.equals(SEP_SET_CONDITION)) {
            this.setCondition.addElementSetGroup(this.elementSetGroup);
            this.setConditionList.add(this.setCondition);
            return;
        }
    }

    private String getValue(String string, String string2) {
        return string2.substring(string.length() + 1);
    }

    private SetCondition createSetCondition(int n) {
        SetCondition setCondition = null;
        if (SetType.isGeneSet(n)) {
            setCondition = new GeneSetCondition();
        } else if (SetType.isClusterSet(n)) {
            setCondition = new ClusterSetCondition();
        }
        setCondition.setSetType(n);
        return setCondition;
    }

    private List getElementSetList(Collection collection) {
        ArrayList<AbstractElementSet> arrayList = new ArrayList<AbstractElementSet>();
        for (String string : collection) {
            AbstractElementSet abstractElementSet;
            AbstractElementSet abstractElementSet2 = (AbstractElementSet)this.geneSetMap.get(string);
            if (abstractElementSet2 == null) {
                abstractElementSet2 = (AbstractElementSet)this.clusterSetMap.get(string);
            }
            if (abstractElementSet2 != null) {
                if (!abstractElementSet2.isExistElement()) {
                    if (abstractElementSet2.isGeneSet()) {
                        abstractElementSet2.setElementList(GeneSetFacade.getInstance().importElementList(abstractElementSet2));
                    } else if (abstractElementSet2.isClusterSet()) {
                        abstractElementSet2.setElementList(ClusterSetFacade.getInstance().importElementList(abstractElementSet2));
                    }
                }
                arrayList.add(abstractElementSet2);
                continue;
            }
            if (this.setCondition.isGeneSet()) {
                abstractElementSet = new GeneSet();
                abstractElementSet.setName(string);
                arrayList.add(abstractElementSet);
                continue;
            }
            abstractElementSet = new ClusterSet();
            abstractElementSet.setName(string);
            arrayList.add(abstractElementSet);
        }
        return arrayList;
    }

    @Override
    protected void parseHeaderLine(String string) {
    }

    public List getSetConditionList() {
        return this.setConditionList;
    }
}

