/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.set.cluster;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.controltree.ControlTitleNode;
import cgdp.recog.controltree.ControlTitleType;
import cgdp.recog.set.ElementSetGroup;
import cgdp.recog.set.ElementSetGroupTreeNode;
import cgdp.recog.set.SetCombinationTreeController;
import cgdp.recog.set.SetCondElementDeleteItem;
import cgdp.recog.set.SetCondition;
import cgdp.recog.set.SetConditionAddColorItem;
import cgdp.recog.set.SetConditionAddFilterItem;
import cgdp.recog.set.SetConditionDeleteItem;
import cgdp.recog.set.color.SetFilerColorItem;
import java.awt.Frame;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class ClusterSetCombinationTreeController
extends SetCombinationTreeController {
    public ClusterSetCombinationTreeController(Frame frame, MediatorImpl mediatorImpl) {
        super(frame, mediatorImpl, 2);
    }

    @Override
    public JPopupMenu createPopupMenu(JTree jTree, ActionListener actionListener) {
        TreePath[] treePathArray = jTree.getSelectionPaths();
        if (treePathArray == null || treePathArray.length == 0) {
            return null;
        }
        JPopupMenu jPopupMenu = new JPopupMenu();
        if (this.isShowSetCombinationMenu(treePathArray)) {
            List list = this.getSetConditionList(treePathArray);
            SetCondition setCondition = (SetCondition)list.get(0);
            jPopupMenu.add(new SetFilerColorItem(actionListener, this.mediator, setCondition));
            jPopupMenu.addSeparator();
            jPopupMenu.add(new SetConditionAddFilterItem(actionListener, this.mediator, list));
            jPopupMenu.add(new SetConditionAddColorItem(actionListener, this.mediator, list));
            jPopupMenu.addSeparator();
            jPopupMenu.add(new SetConditionDeleteItem(actionListener, this.mediator, list));
        } else if (this.isShowSetConditionMenu(treePathArray)) {
            ElementSetGroupTreeNode elementSetGroupTreeNode = (ElementSetGroupTreeNode)treePathArray[0].getLastPathComponent();
            ElementSetGroup elementSetGroup = elementSetGroupTreeNode.getElementSetGroup();
            SetCondition setCondition = elementSetGroup.getSetCondition();
            List list = this.getElementSetGroupList(setCondition, treePathArray);
            jPopupMenu.add(new SetCondElementDeleteItem(actionListener, this.mediator, setCondition, list));
        }
        return jPopupMenu;
    }

    private boolean isShowSetCombinationTitleMenu(TreePath[] treePathArray) {
        if (treePathArray[0].getPathCount() != 2) {
            return false;
        }
        TreePath treePath = treePathArray[0];
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getPathComponent(1);
        if (!(defaultMutableTreeNode instanceof ControlTitleNode)) {
            return false;
        }
        ControlTitleNode controlTitleNode = (ControlTitleNode)defaultMutableTreeNode;
        return ControlTitleType.isClusterSetCombination(controlTitleNode.getControlTitleType());
    }

    private boolean isShowSetCombinationMenu(TreePath[] treePathArray) {
        if (treePathArray[0].getPathCount() != 3) {
            return false;
        }
        TreePath treePath = treePathArray[0];
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getPathComponent(1);
        if (!(defaultMutableTreeNode instanceof ControlTitleNode)) {
            return false;
        }
        ControlTitleNode controlTitleNode = (ControlTitleNode)defaultMutableTreeNode;
        return ControlTitleType.isClusterSetCombination(controlTitleNode.getControlTitleType());
    }

    private boolean isShowSetConditionMenu(TreePath[] treePathArray) {
        if (treePathArray[0].getPathCount() != 4) {
            return false;
        }
        TreePath treePath = treePathArray[0];
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getPathComponent(3);
        if (!(defaultMutableTreeNode instanceof ElementSetGroupTreeNode)) {
            return false;
        }
        ElementSetGroupTreeNode elementSetGroupTreeNode = (ElementSetGroupTreeNode)defaultMutableTreeNode;
        return elementSetGroupTreeNode.isClusterSet();
    }
}

