/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.set.cluster;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.data.Cluster;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.info.MultiType;
import cgdp.recog.info.gene.GeneInfoUtil;
import cgdp.recog.process.AbstractThreadProcess;
import cgdp.recog.process.ProgressImpl;
import cgdp.recog.set.cluster.ClusterSet;
import cgdp.recog.set.cluster.ClusterSetRegister;
import cgdp.recog.set.gene.GeneSetFacade;
import cgdp.recog.util.CollectionUtil;
import cgdp.recog.util.MessageManager;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ClusterSetConverter
extends AbstractThreadProcess {
    private Component parent;
    private MediatorImpl mediator;
    private ClusterTbl clusterTbl;
    private Collection geneSetC;
    private List clusterList;
    private ClusterSet clusterSet;
    private int matchCond = 6;
    private List targetClusterList = new ArrayList();

    public ClusterSetConverter(Component component, MediatorImpl mediatorImpl, ClusterTbl clusterTbl, Collection collection, List list, ClusterSet clusterSet, int n) {
        this.parent = component;
        this.mediator = mediatorImpl;
        this.clusterTbl = clusterTbl;
        this.geneSetC = collection;
        this.clusterList = list;
        this.clusterSet = clusterSet;
        this.matchCond = n;
    }

    @Override
    public void execute(ProgressImpl progressImpl) {
        progressImpl.setTotal(this.clusterList.size());
        Map map = GeneSetFacade.createSetElementListMap(this.geneSetC);
        for (Collection collection : map.values()) {
            Set set = GeneInfoUtil.createOrganismCodeLocusTagSet(collection);
            Iterator iterator = this.clusterList.iterator();
            while (iterator.hasNext()) {
                if (progressImpl.isCanceled()) {
                    return;
                }
                progressImpl.increment();
                Cluster cluster = (Cluster)iterator.next();
                Set set2 = cluster.createOrganismLocusTagSet();
                if (!this.isMatch(set2, set)) continue;
                this.targetClusterList.add(cluster);
            }
        }
        progressImpl.nextProc();
        progressImpl.setTotal(100);
        progressImpl.setCount(0);
        progressImpl.increment();
        if (CollectionUtil.isNull(this.targetClusterList)) {
            return;
        }
        ClusterSetRegister clusterSetRegister = new ClusterSetRegister(this.parent, this.clusterSet, this.targetClusterList, this.clusterTbl);
        clusterSetRegister.execute(progressImpl);
    }

    private boolean isMatch(Set set, Set set2) {
        if (MultiType.isAll(this.matchCond)) {
            return set2.containsAll(set);
        }
        for (String string : set) {
            if (!set2.contains(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void done() {
        if (this.isCancel()) {
            return;
        }
        if (CollectionUtil.isNull(this.targetClusterList)) {
            String string = "There is no cluster.";
            MessageManager.showMessage(this.parent, string);
            return;
        }
        this.mediator.updateClusterSetTree();
    }
}

