/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.set.cluster;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.data.ClusterComparator;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.data.ClusterUtil;
import cgdp.recog.filefilter.FileFilterFactory;
import cgdp.recog.funccat.FunctionCategoryColorCellRenderer;
import cgdp.recog.set.cluster.ClusterSet;
import cgdp.recog.set.cluster.ClusterSetFacade;
import cgdp.recog.set.cluster.ClusterTableModel;
import cgdp.recog.util.AbstractApplyDialog;
import cgdp.recog.util.AbstractFileFilter;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.FocusTextField;
import cgdp.recog.util.MessageManager;
import cgdp.recog.util.StringTool;
import edu.emory.mathcs.backport.java.util.Collections;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumn;

public class ClusterSetEditDialog
extends AbstractApplyDialog {
    private static final ApplicationLogger logger = new ApplicationLogger(ClusterSetEditDialog.class);
    private static final String TITLE = "Edit cluster set";
    private static ClusterSetEditDialog CLUSTER_SET_EDIT_DIALLG;
    private static final AbstractFileFilter FILE_FITER_CLUSTTAB;
    private static final Dimension TABLE_SIZE;
    private MediatorImpl mediator;
    private ClusterTbl clusterTbl;
    private FocusTextField nameTextField;
    private JTable clusterTable;
    private JButton exportButton;
    private JButton deleteButton;
    private JFileChooser chooser;
    private ClusterSet baseClusterSet;

    private ClusterSetEditDialog(Frame frame, MediatorImpl mediatorImpl) {
        super(frame);
        this.mediator = mediatorImpl;
        this.createComponents();
    }

    public static void createInstance(Frame frame, MediatorImpl mediatorImpl) {
        if (CLUSTER_SET_EDIT_DIALLG != null) {
            return;
        }
        CLUSTER_SET_EDIT_DIALLG = new ClusterSetEditDialog(frame, mediatorImpl);
    }

    static ClusterSetEditDialog getInstance() {
        return CLUSTER_SET_EDIT_DIALLG;
    }

    private void createComponents() {
        this.setTitle(TITLE);
        this.setModal(true);
        this.setResizable(true);
        this.createFileChooser();
        JLabel jLabel = new JLabel("Name");
        this.nameTextField = new FocusTextField();
        JLabel jLabel2 = new JLabel("Cluster");
        this.clusterTable = new JTable(new ClusterTableModel());
        TableColumn tableColumn = this.clusterTable.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(80);
        TableColumn tableColumn2 = this.clusterTable.getColumnModel().getColumn(1);
        tableColumn2.setPreferredWidth(100);
        TableColumn tableColumn3 = this.clusterTable.getColumnModel().getColumn(2);
        tableColumn3.setCellRenderer(new FunctionCategoryColorCellRenderer(true));
        tableColumn3.setPreferredWidth(220);
        JScrollPane jScrollPane = new JScrollPane(this.clusterTable, 20, 30);
        jScrollPane.getViewport().setPreferredSize(TABLE_SIZE);
        this.exportButton = new JButton("Export...");
        this.exportButton.addActionListener(this);
        this.deleteButton = new JButton("Delete");
        this.deleteButton.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this.exportButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 5, 0, 0), 0, 0));
        jPanel.add((Component)this.deleteButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 5, 0, 0), 0, 0));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        jPanel2.add((Component)jScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel2.add((Component)jPanel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 10), 0, 0));
        this.getContentPane().add((Component)this.nameTextField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 10), 0, 0));
        this.getContentPane().add((Component)jLabel2, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 10, 0, 10), 0, 0));
        this.getContentPane().add((Component)jPanel2, new GridBagConstraints(1, 3, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 0, 0, 10), 0, 0));
        this.getContentPane().add((Component)this.getButtonPanel(), new GridBagConstraints(0, 4, 2, 1, 1.0, 0.0, 10, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void createFileChooser() {
        this.chooser = new JFileChooser();
        this.chooser.setDialogTitle("Export file");
        this.chooser.setFileFilter(FILE_FITER_CLUSTTAB);
    }

    void updateValue(ClusterSet clusterSet, ClusterTbl clusterTbl) {
        this.baseClusterSet = clusterSet;
        this.clusterTbl = clusterTbl;
        this.nameTextField.setText(clusterSet.getName());
        List list = clusterSet.getElementList();
        if (list == null) {
            list = new ArrayList();
        } else {
            list = clusterTbl.getClusterList(ClusterUtil.getClusterIdSet(list));
            Collections.sort(list, new ClusterComparator(6));
        }
        ClusterTableModel clusterTableModel = this.getClusterTableModel();
        clusterTableModel.setClusterList(list, clusterTbl.isOutgroup());
    }

    private ClusterTableModel getClusterTableModel() {
        return (ClusterTableModel)this.clusterTable.getModel();
    }

    private List getClusterList() {
        return this.getClusterTableModel().getClusterList();
    }

    private String getSetName() {
        return this.nameTextField.getText();
    }

    ClusterSet createClusterSet() {
        ClusterSet clusterSet = new ClusterSet();
        if (this.baseClusterSet != null) {
            clusterSet.copy(this.baseClusterSet);
        }
        clusterSet.setName(this.getSetName());
        clusterSet.setLocation(this.baseClusterSet.getLocation());
        clusterSet.setDomClustFilename(this.clusterTbl.getDomClustName());
        clusterSet.setDomClustId(this.clusterTbl.getClusterId());
        clusterSet.setElementList(this.getClusterList());
        clusterSet.setStatus(this.baseClusterSet.getStatus());
        if (!clusterSet.equalsName(this.baseClusterSet.getName())) {
            clusterSet.addEditName();
        }
        if (!clusterSet.equalsClusterList(this.baseClusterSet)) {
            clusterSet.addEditList();
        }
        return clusterSet;
    }

    @Override
    protected boolean check() {
        Object[] objectArray;
        if (StringTool.isNull(this.getSetName())) {
            MessageManager.showErrorMessage((Component)this, "Input name.");
            return false;
        }
        ClusterSet clusterSet = this.getDuplicateClusterSet();
        return clusterSet == null || MessageManager.showConfirmMessage((Component)this, objectArray = new String[]{"Overwrite gene set [" + this.getSetName() + "]?"});
    }

    private ClusterSet getDuplicateClusterSet() {
        ClusterSet clusterSet = this.createClusterSet();
        ClusterSet clusterSet2 = (ClusterSet)ClusterSetFacade.getInstance().getSameElementSet(clusterSet);
        if (clusterSet2 == null || clusterSet2.equalsElement(this.baseClusterSet)) {
            return null;
        }
        return clusterSet2;
    }

    @Override
    protected boolean apply() {
        return true;
    }

    private void export() {
        ClusterSet clusterSet = this.createClusterSet();
        this.mediator.export(clusterSet);
    }

    private void delete() {
        if (!MessageManager.showConfirmMessage((Component)this, "Delete clusters?")) {
            return;
        }
        int[] nArray = this.clusterTable.getSelectedRows();
        if (nArray == null || nArray.length == 0) {
            return;
        }
        this.getClusterTableModel().removeCluster(nArray);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        if (actionEvent.getSource() == this.exportButton) {
            this.export();
        } else if (actionEvent.getSource() == this.deleteButton) {
            this.delete();
        }
    }

    static {
        FILE_FITER_CLUSTTAB = FileFilterFactory.createDomClustTabFileWithDirFilter();
        TABLE_SIZE = new Dimension(400, 100);
    }
}

