/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.set.cluster;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.process.CommandImpl;
import cgdp.recog.set.cluster.ClusterSet;
import cgdp.recog.set.cluster.ClusterSetFacade;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.MessageManager;
import java.awt.Component;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;

class ClusterSetEditItem
extends JMenuItem
implements CommandImpl {
    private static final ApplicationLogger logger = new ApplicationLogger(ClusterSetEditItem.class);
    private Component parent;
    private MediatorImpl mediator;
    private ClusterTbl clusterTbl;
    private ClusterSet clusterSet;

    ClusterSetEditItem(ActionListener actionListener, Component component, MediatorImpl mediatorImpl, ClusterTbl clusterTbl, ClusterSet clusterSet) {
        super("Edit cluster set [" + clusterSet.getName() + "]...");
        this.parent = component;
        this.mediator = mediatorImpl;
        this.clusterSet = clusterSet;
        this.clusterTbl = clusterTbl;
        this.addActionListener(actionListener);
    }

    @Override
    public void execute() {
        try {
            ClusterSetFacade.getInstance().editClusterSet(this.mediator, this.clusterSet, this.clusterTbl);
        }
        catch (Exception exception) {
            String string = "Fail to edit cluster set.";
            logger.warn(string, exception);
            MessageManager.showErrorMessage(this.parent, string);
        }
    }
}

