/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.set.cluster;

import cgdp.recog.data.Cluster;
import cgdp.recog.util.CollectionUtil;
import cgdp.recog.util.FileUtil;
import cgdp.recog.util.GeneUtil;
import edu.emory.mathcs.backport.java.util.Collections;
import java.util.ArrayList;
import java.util.List;

class ClusterSetListExporter {
    private static final String DELIMITER = "\t";
    private static final String DELIMITER_ORGANISM = ":";
    public static final String DELIMITER_LOCUSTAG = " ";
    private String filepath;
    private List clusterList;

    ClusterSetListExporter(String string, List list) {
        this.filepath = string;
        this.clusterList = list;
    }

    public void execute() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        for (Cluster cluster : this.clusterList) {
            int n = cluster.getClusterId();
            int n2 = cluster.getSubClusterId();
            stringBuffer.append(n);
            stringBuffer.append(DELIMITER);
            stringBuffer.append(n2);
            stringBuffer.append(ClusterSetListExporter.createGeneInfoString(cluster));
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
        }
        FileUtil.outputFile(stringBuffer.toString(), this.filepath);
    }

    public static String createGeneInfoString(Cluster cluster) {
        ArrayList arrayList = new ArrayList(cluster.getSpSet());
        Collections.sort(arrayList);
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : arrayList) {
            List list = cluster.getGeneInformationList(string);
            if (CollectionUtil.isNull(list)) continue;
            List list2 = GeneUtil.getLocusTagList(list);
            String string2 = GeneUtil.getOrganismLocusTagsString(string, list2, DELIMITER_ORGANISM, DELIMITER_LOCUSTAG);
            stringBuffer.append(DELIMITER);
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }
}

