/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.set.cluster;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.process.CommandImpl;
import cgdp.recog.set.cluster.ClusterSetFacade;
import cgdp.recog.set.gene.GeneSetIOException;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.MessageManager;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;

class ClusterSetNewItem
extends JMenuItem
implements CommandImpl {
    private static final ApplicationLogger logger = new ApplicationLogger(ClusterSetNewItem.class);
    private Frame parent;
    private MediatorImpl mediator;
    private ClusterTbl clusterTbl;

    ClusterSetNewItem(ActionListener actionListener, Frame frame, MediatorImpl mediatorImpl, ClusterTbl clusterTbl) {
        super("File...");
        this.parent = frame;
        this.mediator = mediatorImpl;
        this.clusterTbl = clusterTbl;
        this.addActionListener(actionListener);
    }

    @Override
    public void execute() {
        try {
            ClusterSetFacade.createClusterSet(this.parent, this.mediator, this.clusterTbl);
        }
        catch (GeneSetIOException geneSetIOException) {
            logger.warn(geneSetIOException.getMessage(), geneSetIOException);
            MessageManager.showErrorMessage((Component)this.parent, geneSetIOException.getMessage());
        }
        catch (Exception exception) {
            String string = "Fail to register cluster set.";
            logger.warn(string, exception);
            MessageManager.showErrorMessage((Component)this.parent, string);
        }
    }
}

