/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.set.cluster;

import cgdp.recog.data.ClusterComparator;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.process.ProcessImpl;
import cgdp.recog.process.ProgressImpl;
import cgdp.recog.set.cluster.ClusterSet;
import cgdp.recog.set.cluster.ClusterSetFacade;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.MessageManager;
import edu.emory.mathcs.backport.java.util.Collections;
import java.awt.Component;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ClusterSetRegister
implements ProcessImpl {
    private static final ApplicationLogger logger = new ApplicationLogger(ClusterSetRegister.class);
    private static final int LIST_FILE = 1;
    private static final int CLUSTER_LIST = 2;
    private Component parent;
    private ClusterTbl clusterTbl;
    private ClusterSet clusterSet;
    private int type = 1;
    private String filepath;
    private List clusterList;

    public ClusterSetRegister(Component component, ClusterSet clusterSet, String string, ClusterTbl clusterTbl) {
        this.parent = component;
        this.clusterSet = clusterSet;
        this.filepath = string;
        this.clusterTbl = clusterTbl;
        this.type = 1;
    }

    public ClusterSetRegister(Component component, ClusterSet clusterSet, List list, ClusterTbl clusterTbl) {
        this.parent = component;
        this.clusterSet = clusterSet;
        this.clusterList = list;
        this.clusterTbl = clusterTbl;
        this.type = 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(ProgressImpl progressImpl) {
        Object object;
        progressImpl.setTotal(100);
        try {
            ClusterSetFacade.createClusterSetDirectory(this.clusterSet.getLocation(), this.clusterTbl.getClusterId());
            progressImpl.setCount(9);
            progressImpl.increment();
            try {
                List list = this.getClusterList();
                if (this.clusterSet.isAddList()) {
                    object = ClusterSetFacade.getInstance().importElementList(this.clusterSet, true);
                    this.clusterSet.setElementList((List)object);
                    this.clusterSet.addElementList(list);
                } else {
                    this.clusterSet.setElementList(list);
                }
            }
            catch (IOException iOException) {
                MessageManager.showErrorMessage(this.parent, iOException.getMessage());
                progressImpl.setCount(99);
                progressImpl.increment();
                return;
            }
            progressImpl.setCount(49);
            progressImpl.increment();
            Collections.sort(this.clusterSet.getElementList(), new ClusterComparator(6));
            progressImpl.setCount(69);
            progressImpl.increment();
            this.exportClusterSetConf();
            progressImpl.setCount(79);
            progressImpl.increment();
            ClusterSetFacade.getInstance().exportListFile(this.clusterSet, this.clusterSet.getElementList());
            this.clusterSet.setNormal();
            progressImpl.setCount(99);
            progressImpl.increment();
        }
        catch (Exception exception) {
            object = "Fail to register cluster set file.";
            logger.warn((String)object, exception);
            MessageManager.showErrorMessage(this.parent, (String)object);
        }
        finally {
            progressImpl.setCount(99);
            progressImpl.increment();
        }
    }

    private void exportClusterSetConf() throws Exception {
        List list = ClusterSetFacade.getInstance().getElementSetList();
        this.clusterSet.margeElementSet(list);
        ClusterSetFacade.getInstance().exportConfFile(list);
    }

    private List getClusterList() throws IOException {
        List list = new ArrayList();
        if (this.isListFile()) {
            list = ClusterSetFacade.getClusterListFromUserFile(this.filepath, this.clusterTbl);
        } else {
            list.addAll(this.clusterList);
        }
        return list;
    }

    private boolean isClusterList() {
        return this.type == 2;
    }

    private boolean isListFile() {
        return this.type == 1;
    }

    @Override
    public void done() {
    }
}

