/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.set.gene;

import cgdp.recog.process.AbstractThreadProcess;
import cgdp.recog.process.DummyProgressComponent;
import cgdp.recog.process.ProgressImpl;
import cgdp.recog.project.Project;
import cgdp.recog.set.AbstractElementSet;
import cgdp.recog.set.AbstractElementSetFacade;
import cgdp.recog.set.gene.GeneSet;
import cgdp.recog.set.gene.GeneSetDownloader;
import cgdp.recog.set.gene.GeneSetRegister;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.CollectionUtil;
import cgdp.recog.util.MessageManager;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class GeneSetDownloadExecuter
extends AbstractThreadProcess {
    private static final ApplicationLogger logger = new ApplicationLogger(GeneSetDownloadExecuter.class);
    private Component parent;
    private Project project;
    private Collection setC;
    private Set unableDeleteSetSet = new HashSet();
    private boolean errorHandling = true;
    private boolean overwriteCheck = false;

    public GeneSetDownloadExecuter(Component component, Collection collection, Project project) {
        this.parent = component;
        this.project = project;
        this.setC = collection;
    }

    public void setErrorHandling(boolean bl) {
        this.errorHandling = bl;
    }

    public void setOverwriteCheck(boolean bl) {
        this.overwriteCheck = bl;
    }

    @Override
    public void execute(ProgressImpl progressImpl) {
        progressImpl.setTotal(this.setC.size());
        try {
            Iterator iterator = this.setC.iterator();
            while (iterator.hasNext()) {
                if (progressImpl.isCanceled()) {
                    this.setCancel(true);
                    return;
                }
                progressImpl.increment();
                AbstractElementSet abstractElementSet = (AbstractElementSet)iterator.next();
                GeneSetDownloader geneSetDownloader = new GeneSetDownloader((GeneSet)abstractElementSet, this.project);
                geneSetDownloader.execute();
                List list = geneSetDownloader.getGeneInfoList();
                if (CollectionUtil.isNull(list)) {
                    this.unableDeleteSetSet.add(abstractElementSet);
                    continue;
                }
                abstractElementSet.setElementList(list);
            }
        }
        catch (Exception exception) {
            String string = "Fail to download gene set.";
            logger.warn(string, exception);
            this.setError(true);
            this.setErrorMessage(string);
        }
    }

    public Set getUnableDeleteSetSet() {
        return this.unableDeleteSetSet;
    }

    @Override
    public void done() {
        Object object;
        String[] stringArray;
        if (this.isCancel()) {
            return;
        }
        if (this.errorHandling) {
            if (this.isError()) {
                MessageManager.showErrorMessage(this.parent, this.getErrorMessages());
                return;
            }
            if (!CollectionUtil.isNull(this.unableDeleteSetSet)) {
                stringArray = new String[]{"The following set was not able to be downloaded.", AbstractElementSetFacade.createElementSetNameString(this.unableDeleteSetSet)};
                MessageManager.showWarningMessage(this.parent, stringArray);
            }
        }
        stringArray = new ArrayList(this.setC);
        stringArray.removeAll(this.unableDeleteSetSet);
        if (!(CollectionUtil.isNull(stringArray) || this.overwriteCheck && !AbstractElementSetFacade.validateSet(this.parent, (List)stringArray))) {
            object = stringArray.iterator();
            while (object.hasNext()) {
                GeneSet geneSet = (GeneSet)object.next();
                List list = geneSet.getElementList();
                GeneSetRegister geneSetRegister = new GeneSetRegister(this.parent, geneSet, list);
                geneSetRegister.execute(new DummyProgressComponent());
            }
        }
        if ((object = this.getAfterRunnable()) != null) {
            object.run();
        }
    }
}

