/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.set.gene;

import cgdp.recog.info.gene.GeneInfo;
import cgdp.recog.info.gene.GeneInfoTitle;
import cgdp.recog.set.SetFileType;
import cgdp.recog.set.gene.GeneInfoOrganismLocusTagComparator;
import cgdp.recog.util.FileImporter;
import cgdp.recog.util.GeneUtil;
import cgdp.recog.util.ServerStatus;
import cgdp.recog.util.StringTool;
import edu.emory.mathcs.backport.java.util.Collections;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class GeneSetImporter
extends FileImporter {
    protected List geneInfoList = new ArrayList();
    private String filepath;
    protected int fileType = -1;
    private boolean dataStart = false;
    protected Set registeredLocusTagSet = new HashSet();
    private List columnList = new ArrayList();
    private Set organismCodeSet = new HashSet();
    private Map organismCodeIndexMap = new HashMap();
    private boolean removeDomain = true;

    public GeneSetImporter(String string) {
        this.filepath = string;
        this.setExistHeader(false);
    }

    @Override
    protected String getFilepath() {
        return this.filepath;
    }

    public List getGeneInfoList() {
        return this.geneInfoList;
    }

    @Override
    protected void parseDataLine(int n, String string) {
        if (SetFileType.isNoType(this.fileType)) {
            this.fileType = SetFileType.analysisFormat(string);
            if (SetFileType.isNoType(this.fileType)) {
                this.setError(true);
                this.setErrorMessage("Invalid format. line:" + string);
                return;
            }
        }
        ArrayList arrayList = new ArrayList();
        if (SetFileType.isClustTab(this.fileType)) {
            arrayList.addAll(this.parseGeneInfoByClustTab(n, string, this.registeredLocusTagSet));
        } else if (SetFileType.isDclust(this.fileType)) {
            arrayList.addAll(this.parseGeneInfoByDclust(n, string, this.registeredLocusTagSet));
        } else if (SetFileType.isGeneList(this.fileType)) {
            arrayList.addAll(this.parseGeneInfoByGeneList(n, string, this.registeredLocusTagSet));
        }
        this.geneInfoList.addAll(arrayList);
    }

    private List parseGeneInfoByGeneList(int n, String string, Set set) {
        ArrayList arrayList = new ArrayList();
        if (n == 0) {
            this.setDataStart(true);
            return arrayList;
        }
        Vector vector = StringTool.splitString(string, "\t");
        if (vector.size() < 2) {
            return arrayList;
        }
        String string2 = (String)vector.get(0);
        String string3 = (String)vector.get(1);
        if (this.isRemoveDomain()) {
            string3 = GeneUtil.removeDomainNo(string3);
        }
        GeneSetImporter.createGeneInfo(string2, string3, arrayList, set);
        return arrayList;
    }

    private List parseGeneInfoByDclust(int n, String string, Set set) {
        this.setDataStart(true);
        ArrayList arrayList = new ArrayList();
        Vector vector = StringTool.splitString(string, SetFileType.DELIMITER_DCLUST);
        for (String string2 : vector) {
            Vector vector2;
            string2.trim();
            if (StringTool.isNull(string2) || (vector2 = StringTool.splitString(string2, ":")).size() != 2) continue;
            String string3 = (String)vector2.get(0);
            String string4 = (String)vector2.get(1);
            if (this.isRemoveDomain()) {
                string4 = GeneUtil.removeDomainNo(string4);
            }
            GeneSetImporter.createGeneInfo(string3, string4, arrayList, set);
        }
        return arrayList;
    }

    protected List parseGeneInfoByClustTab(int n, String string, Set set) {
        ArrayList arrayList = new ArrayList();
        if (!this.isDataStart()) {
            if (ServerStatus.isParameter(string)) {
                if (ServerStatus.isIngroup(string)) {
                    this.organismCodeSet.addAll(ServerStatus.getIngroupList(string));
                } else if (ServerStatus.isOutgroup(string)) {
                    this.organismCodeSet.addAll(ServerStatus.getOutgroupList(string));
                }
            } else if (string.startsWith("Cluster ID")) {
                this.columnList.addAll(StringTool.splitString(string, "\t"));
                for (int i = 0; i < this.columnList.size(); ++i) {
                    String string2 = (String)this.columnList.get(i);
                    if (!this.organismCodeSet.contains(string2)) continue;
                    this.organismCodeIndexMap.put(string2, new Integer(i));
                }
                this.setDataStart(true);
            }
            return arrayList;
        }
        Vector vector = StringTool.splitString(string, "\t");
        if (vector.size() < 2) {
            return arrayList;
        }
        for (String string3 : this.organismCodeSet) {
            int n2 = (Integer)this.organismCodeIndexMap.get(string3);
            String string4 = (String)vector.get(n2);
            Vector vector2 = StringTool.splitString(string4, " ");
            for (String string5 : vector2) {
                if (this.isRemoveDomain()) {
                    string5 = GeneUtil.removeDomainNo(string5);
                }
                GeneSetImporter.createGeneInfo(string3, string5, arrayList, set);
            }
        }
        return arrayList;
    }

    private static void createGeneInfo(String string, String string2, List list, Set set) {
        String string3 = GeneUtil.createOrganismLocusTagKey(string, string2);
        if (set.contains(string3)) {
            return;
        }
        GeneInfo geneInfo = new GeneInfo();
        geneInfo.putInfo(GeneInfoTitle.TITLE_ORGANISM_CODE, string);
        geneInfo.putInfo(GeneInfoTitle.TITLE_LOCUSTAG_SERVER, string2);
        list.add(geneInfo);
        set.add(string3);
    }

    @Override
    protected void parseHeaderLine(String string) {
    }

    @Override
    protected void afterProcess() {
        if (SetFileType.isNoType(this.fileType)) {
            this.setError(true);
            this.setErrorMessage("Invalid format.");
            return;
        }
        Collections.sort(this.geneInfoList, new GeneInfoOrganismLocusTagComparator());
    }

    private void setDataStart(boolean bl) {
        this.dataStart = bl;
    }

    private boolean isDataStart() {
        return this.dataStart;
    }

    public void setRemoveDomain(boolean bl) {
        this.removeDomain = bl;
    }

    public boolean isRemoveDomain() {
        return this.removeDomain;
    }
}

